/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.RandomSupplier;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class ExponentialHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final int DEFAULT_MAX_BUCKETS = 160;
    private static final int DEFAULT_STARTING_SCALE = 20;
    private static final Aggregation DEFAULT = new ExponentialHistogramAggregation(160);
    private final int maxBuckets;

    private ExponentialHistogramAggregation(int maxBuckets) {
        this.maxBuckets = maxBuckets;
    }

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(int maxBuckets) {
        Utils.checkArgument((maxBuckets >= 1 ? 1 : 0) != 0, (String)"maxBuckets must be > 0");
        return new ExponentialHistogramAggregation(maxBuckets);
    }

    @Override
    public <T, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        return new DoubleExponentialHistogramAggregator(() -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault())), this.maxBuckets, 20);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ExponentialHistogramAggregation{maxBuckets=" + this.maxBuckets + "}";
    }
}

