/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.logs.SdkLogger;
import javax.annotation.Nullable;

final class SdkLoggerBuilder
implements LoggerBuilder {
    private final ComponentRegistry<SdkLogger> registry;
    private final String instrumentationScopeName;
    @Nullable
    private String instrumentationScopeVersion;
    @Nullable
    private String schemaUrl;
    @Nullable
    private String eventDomain;

    SdkLoggerBuilder(ComponentRegistry<SdkLogger> registry, String instrumentationScopeName) {
        this.registry = registry;
        this.instrumentationScopeName = instrumentationScopeName;
    }

    public LoggerBuilder setEventDomain(String eventDomain) {
        this.eventDomain = eventDomain;
        return this;
    }

    public SdkLoggerBuilder setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    public SdkLoggerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        this.instrumentationScopeVersion = instrumentationScopeVersion;
        return this;
    }

    public SdkLogger build() {
        SdkLogger logger = this.registry.get(this.instrumentationScopeName, this.instrumentationScopeVersion, this.schemaUrl, Attributes.empty());
        return this.eventDomain == null ? logger : logger.withEventDomain(this.eventDomain);
    }
}

