/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.toolchain.core.configs;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.IExtensionManager;
import com.silabs.ss.framework.project.api.toolchain.core.ToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.configs.IStockConfigurationTemplateRegistry;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfigurationProperties;
import com.silabs.ss.framework.project.internal.api.toolchain.core.configs.BaseStockConfigurationDescriptor;
import com.silabs.ss.framework.project.internal.api.toolchain.core.configs.StockConfigurationManager;
import com.silabs.ss.framework.project.internal.api.toolchain.core.configs.StockConfigurationRegistry;
import com.silabs.ss.framework.project.internal.toolchain.core.Activator;
import com.silabs.ss.framework.project.internal.toolchain.core.configs.StockConfigurationManagerCompatibilityAdapter;
import com.silabs.ss.platform.api.descriptor.core.compatibility.IDescriptorCompatibilityAdapter;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseExtensionBackedRegistry;
import com.silabs.ss.platform.api.descriptor.core.registry.IExtensionBackedRegistryConfig;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryConfigFactory;
import com.silabs.ss.platform.api.descriptor.core.registry.plugins.IRegistryPluginProvider;
import com.silabs.ss.platform.api.descriptor.core.registry.plugins.RegistryTransientDescriptorProvider;
import java.util.Collection;
import java.util.stream.Stream;

public class StockConfigurationTemplateRegistry
extends BaseExtensionBackedRegistry<IStockConfigurationDescriptor>
implements IStockConfigurationTemplateRegistry {
    protected static final String PREF_SCOPE = "stockConfigs/";
    protected static final String EXTENSION_NAME = "toolchainSupport";
    private static final String ELEMENT_OPTION = "option";
    private static final String ATTR_OWNER = "owner";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_LIST_VALUE = "listValue";
    private static final String ATTR_BASE_TEMPLATE_ID = "baseTemplateId";
    private StockConfigurationManager manager;

    public StockConfigurationTemplateRegistry(IExtensionBackedRegistryConfig<IStockConfigurationDescriptor> config) {
        super(config);
    }

    void setManager(StockConfigurationManager manager) {
        this.manager = manager;
    }

    protected StockConfigurationTemplateRegistry(IExtensionManager extMgr, boolean isTestMode) {
        this((IExtensionBackedRegistryConfig<IStockConfigurationDescriptor>)StockConfigurationTemplateRegistry.createFactory().isTestMode(isTestMode).withExtensionManager(extMgr).createExtensionBackedRegistryConfig());
    }

    static RegistryConfigFactory<IStockConfigurationDescriptor> createBaseFactory(IExtensionManager extMgr, boolean isTestMode) {
        return StockConfigurationRegistry.createFactory().isTestMode(isTestMode).withExtensionManager(extMgr).withExtensionName(EXTENSION_NAME).withExtensionDescriptorElement("stockConfigurationTemplate", "stockConfig");
    }

    static RegistryConfigFactory<IStockConfigurationDescriptor> createFactory() {
        return RegistryConfigFactory.forDescriptor(IStockConfigurationDescriptor.class, BaseStockConfigurationDescriptor.class).forBundle(Activator.id()).withExtensionDescriptorElement("stockConfigurationTemplate", "stockConfig").withRegistryPluginProvider((IRegistryPluginProvider)new RegistryTransientDescriptorProvider()).withPreferenceScope(PREF_SCOPE).withExtensionName(EXTENSION_NAME);
    }

    protected IStockConfigurationDescriptor createDescriptor(IExtensionInformation el, Object context) {
        IStockConfigurationDescriptor descr = (IStockConfigurationDescriptor)super.createDescriptor(el, context);
        String baseId = el.getAttribute(ATTR_BASE_TEMPLATE_ID);
        if (TextUtils.isEmpty((String)baseId)) {
            baseId = null;
        }
        descr.setBaseTemplateId(baseId);
        descr.setProperty("toolchainCompatibility", el.getAttribute("toolchainCompatibility"));
        Collection options = (Collection)descr.getProperty(StockConfigurationProperties.STOCK_OPTIONS);
        IExtensionInformation[] iExtensionInformationArray = el.getChildren(ELEMENT_OPTION);
        int n = iExtensionInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionInformation op = iExtensionInformationArray[n2];
            String owner = op.getAttribute(ATTR_OWNER);
            Object key = op.getAttribute(ATTR_KEY);
            if (!((String)key).contains(".")) {
                key = owner + "." + (String)key;
            }
            String value = op.getAttribute(ATTR_VALUE);
            Stream<String> listVals = Stream.of(op.getChildren(ATTR_LIST_VALUE)).map(o -> o.getAttribute(ATTR_VALUE));
            ToolOption option = new ToolOption(owner, (String)key, value, listVals);
            options.add(option);
            ++n2;
        }
        descr.setProperty(StockConfigurationProperties.STOCK_OPTIONS, options);
        return descr;
    }

    protected IDescriptorCompatibilityAdapter<IStockConfigurationDescriptor> createDescriptorCompatibilityAdapter() {
        return new StockConfigurationManagerCompatibilityAdapter(this.manager);
    }
}

