/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.toolchain.core;

import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDetector;
import com.silabs.ss.framework.project.internal.toolchain.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IWriteableVersionedDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseDetector;
import com.silabs.ss.platform.api.rcp.core.process.BaseProcessStreamLineMonitor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public abstract class BaseToolchainDetector
extends BaseDetector<IToolchainDescriptor>
implements IToolchainDetector {
    public BaseToolchainDetector(String label, Class<IToolchainDescriptor> intfKlass) {
        super(label, intfKlass);
    }

    protected abstract ToolInfoStreamMonitor launchAndGetToolStreamMonitor(IWriteableVersionedDescriptor var1, IPath var2, String var3) throws CoreException;

    protected boolean fetchInfo(IWriteableVersionedDescriptor toolchain, IPath installPath, String toolchainLabel, String[] tools) {
        boolean anyWorked = false;
        StringBuilder sb = new StringBuilder();
        MultiStatus status = new MultiStatus(Activator.id(), 0, "Errors checking " + toolchainLabel + " status", null);
        ExecutorService service = Executors.newFixedThreadPool(5);
        ArrayList<Callable<ToolInfoStreamMonitor>> tasks = new ArrayList<Callable<ToolInfoStreamMonitor>>();
        String[] stringArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            String tool = stringArray[n2];
            tasks.add(() -> {
                ToolInfoStreamMonitor infoMonitor = this.launchAndGetToolStreamMonitor(toolchain, installPath, tool);
                return infoMonitor;
            });
            ++n2;
        }
        try {
            List futures = service.invokeAll(tasks, 3L, TimeUnit.MINUTES);
            service.shutdown();
            service.awaitTermination(15L, TimeUnit.SECONDS);
            for (Future future : futures) {
                try {
                    ToolInfoStreamMonitor infoMonitor = (ToolInfoStreamMonitor)((Object)future.get());
                    if (infoMonitor.getStatus() == null || infoMonitor.getStatus().isOK()) {
                        if (infoMonitor.getDescription() == null) continue;
                        sb.append(MessageFormat.format("<p><tt>{0}</tt></p>", infoMonitor.getDescription()));
                        anyWorked = true;
                        continue;
                    }
                    status.add(infoMonitor.getStatus());
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        status.add(((CoreException)e.getCause()).getStatus());
                        continue;
                    }
                    status.add(Activator.reporter.newErrorStatus("Internal error scanning " + toolchainLabel, e.getCause()));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        toolchain.setDescription(MessageFormat.format("<p>{0}</p>{1}", toolchain.getDescription(), sb.toString()));
        if (!status.isOK()) {
            Activator.reporter.log((IStatus)status);
            return anyWorked;
        }
        return true;
    }

    protected static abstract class ToolInfoStreamMonitor
    extends BaseProcessStreamLineMonitor {
        public String description;
        public String version;
        public IStatus status;

        protected ToolInfoStreamMonitor() {
        }

        protected String getDescription() {
            return this.description;
        }

        protected String getVersion() {
            return this.version;
        }

        protected IStatus getStatus() {
            return this.status;
        }
    }
}

