/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.servlet;

import com.google.common.base.Strings;
import com.silabs.java.utils.log.Log;
import com.silabs.ss.framework.uc.api.cli.WorkingDirectory;
import com.silabs.ss.framework.uc.core.internal.api.log.UcCoreLogger;
import com.silabs.ss.framework.uc.core.internal.persist.IPersistedCliConfig;
import com.silabs.ss.framework.uc.core.internal.persist.PersistedCliConfig;
import com.silabs.ss.framework.uc.internal.api.trace.SlcTelemetryUtils;
import com.silabs.uc.cli.instrumented.configuration.internal.api.instrument.shared.JsonPayloadArgumentGetter;
import com.silabs.uc.cli.instrumented.configuration.internal.api.instrument.shared.SlcCliTelemetryConfigure;
import com.silabs.uc.cli.internal.command.ICliRunner;
import com.silabs.uc.cli.internal.command.UcCli;
import com.silabs.uc.cli.internal.command.exception.JsonSchemaException;
import com.silabs.uc.cli.internal.daemon.CliSessionManager;
import com.silabs.uc.cli.internal.daemon.ICliSessionManager;
import com.silabs.uc.cli.internal.daemon.IPrintWriterSession;
import com.silabs.uc.cli.internal.daemon.PrintWriterSession;
import com.silabs.uc.cli.internal.model.CliOutput;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.servlet.JsonHttpServlet;
import com.silabs.uc.cli.internal.servlet.JsonTypesUtil;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class SlcCliRestEndpoint
extends JsonHttpServlet {
    private static final String JSON_COMMAND_LINE = "command_line";
    private static final String JSON_OUTPUT_PROPERTIES = "output_properties";
    private static final String JSON_COLOUR = "colour";
    private static final String JSON_USE_WEBSOCKET = "use_websocket";
    private static final String JSON_CONTEXT = "context";
    private static final long serialVersionUID = 1L;
    private final ICliSessionManager sessionManager;
    private final ICliRunner cliRunner;
    private final String endpointUniqueName;
    private volatile LocalDateTime lastRequest;
    private final Set<String> runningUuid = ConcurrentHashMap.newKeySet();
    private volatile boolean atLeastOneService;
    private static final ConcurrentMap<String, SlcCliRestEndpoint> registered = new ConcurrentHashMap<String, SlcCliRestEndpoint>();

    public SlcCliRestEndpoint(ICliSessionManager sessionManager, ICliRunner cliRunner, String endpointUniqueName) {
        this.sessionManager = sessionManager;
        this.cliRunner = cliRunner;
        this.endpointUniqueName = endpointUniqueName;
        this.updateLastRequest(false);
        this.register(sessionManager);
    }

    protected void register(ICliSessionManager sessionManager) {
        if (registered.put(this.contextPath(), this) != null) {
            throw new IllegalStateException("Already registered elsewhere: " + this.contextPath());
        }
        sessionManager.makeMasterWebSocket();
    }

    public static Optional<SlcCliRestEndpoint> getRegistered(String contextPath) {
        return Optional.ofNullable((SlcCliRestEndpoint)((Object)registered.get(contextPath)));
    }

    public SlcCliRestEndpoint(String endpointUniqueName) {
        this(new CliSessionManager(), UcCli.instance(), endpointUniqueName);
    }

    public SlcCliRestEndpoint() {
        this("");
    }

    public String contextPath() {
        return SlcCliRestEndpoint.contextPath(this.endpointUniqueName);
    }

    public static String contextPath(String endpoint) {
        return "/rest/uccli/action/commandline/" + endpoint;
    }

    private void updateLastRequest(boolean requested) {
        this.setLastRequest(LocalDateTime.now());
        if (requested) {
            this.setAtLeastOneService(true);
        }
    }

    public LocalDateTime lastRequest() {
        if (!this.runningUuid.isEmpty()) {
            return LocalDateTime.now();
        }
        return this.lastRequest;
    }

    public boolean atLeastOneService() {
        return this.atLeastOneService;
    }

    @Override
    protected final void doPost(HttpServletRequest req, HttpServletResponse resp, JSONObject json) throws ServletException, IOException {
        this.updateLastRequest(true);
        try {
            String action;
            switch (action = JsonTypesUtil.getString(json, "action")) {
                case "respond": {
                    resp.setStatus(200);
                    boolean usesSocket = JsonTypesUtil.getBooleanOptional(json, JSON_USE_WEBSOCKET).orElse(false);
                    if (!usesSocket) break;
                    String sessionId = UUID.randomUUID().toString();
                    JSONObject responseJson = new JSONObject();
                    responseJson.put("websocket_context", (Object)sessionId);
                    resp.getWriter().println(responseJson.toString());
                    break;
                }
                case "command": {
                    this.doCommand(resp, json);
                    break;
                }
                default: {
                    resp.getWriter().println("Unknown action " + action);
                }
            }
            resp.getWriter().flush();
        }
        catch (JsonSchemaException e) {
            resp.sendError(400, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCommand(HttpServletResponse resp, JSONObject json) throws IOException, JsonSchemaException {
        int finalReturnCode = -1;
        OpenTelemetry telemetry = SlcTelemetryUtils.telemetry();
        Context c = SlcCliTelemetryConfigure.extractContext((OpenTelemetry)telemetry, (Object)json, (TextMapGetter)JsonPayloadArgumentGetter.instance());
        String loggerUuid = JsonTypesUtil.getStringOptional(json, JSON_CONTEXT).orElse(UUID.randomUUID().toString());
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                Scope s = c.makeCurrent();
                try {
                    block28: {
                        ByteArrayOutputStream respOutStream = new ByteArrayOutputStream();
                        try {
                            try (ByteArrayOutputStream respErrStream = new ByteArrayOutputStream();){
                                this.updateRunningUuid(loggerUuid, true);
                                PrintStream respOutput = new PrintStream(respOutStream);
                                PrintStream respError = new PrintStream(respErrStream);
                                IPrintWriterSession printSession = this.sessionFor(json, respOutput, respError);
                                Path workingDirectory = WorkingDirectory.workingDirectory();
                                if (json.has("working_dir")) {
                                    String workingDir = JsonTypesUtil.getString(json, "working_dir");
                                    workingDirectory = Paths.get(workingDir, new String[0]);
                                }
                                boolean colour = false;
                                int consoleWidth = 80;
                                if (json.has(JSON_OUTPUT_PROPERTIES)) {
                                    JSONObject outputProps = json.getJSONObject(JSON_OUTPUT_PROPERTIES);
                                    colour = JsonTypesUtil.getBooleanOptional(outputProps, JSON_COLOUR).orElse(Boolean.FALSE);
                                    consoleWidth = JsonTypesUtil.getIntOptional(outputProps, "width").filter(i -> i > 0).orElse(80);
                                }
                                CliSessionData sessionData = new CliSessionData(printSession.out(), printSession.err(), loggerUuid, colour, consoleWidth);
                                CliOutput session = new CliOutput(sessionData, (IPersistedCliConfig)PersistedCliConfig.INSTANCE, workingDirectory, UcCoreLogger.baseLogger());
                                JSONArray jsonArgs = json.getJSONArray(JSON_COMMAND_LINE);
                                String[] args = new String[jsonArgs.length()];
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= jsonArgs.length()) {
                                        try {
                                            session.unifiedLogger().internalInfo("Command working directory: " + session.workingDirectory().toAbsolutePath().toString(), null);
                                            session.unifiedLogger().internalInfo("Colour Support? " + colour, null);
                                            session.unifiedLogger().internalInfo("Console Width: " + consoleWidth, null);
                                            finalReturnCode = this.cliRunner.doCommand(args, session);
                                            respOutput.flush();
                                            respError.flush();
                                            String outInfo = respOutStream.toString(StandardCharsets.UTF_8);
                                            String errInfo = respErrStream.toString(StandardCharsets.UTF_8);
                                            if (!Strings.isNullOrEmpty((String)outInfo) || !Strings.isNullOrEmpty((String)errInfo)) {
                                                JSONObject jsonResponse = new JSONObject();
                                                jsonResponse.put("out", (Object)outInfo);
                                                jsonResponse.put("err", (Object)errInfo);
                                                jsonResponse.put("return_code", finalReturnCode);
                                                resp.getWriter().write(jsonResponse.toString());
                                            }
                                        }
                                        catch (Exception e) {
                                            session.err().println("Command line operation " + Arrays.stream(args).collect(Collectors.joining(" ")) + " could not complete due to " + e.getMessage());
                                            Log.error((String)e.getMessage(), (Throwable)e);
                                        }
                                        break;
                                    }
                                    args[i2] = jsonArgs.get(i2).toString();
                                    ++i2;
                                }
                            }
                            if (respOutStream == null) break block28;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (respOutStream == null) throw throwable;
                            respOutStream.close();
                            throw throwable;
                        }
                        respOutStream.close();
                    }
                    if (s == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (s == null) throw throwable;
                    s.close();
                    throw throwable;
                }
                s.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        finally {
            this.updateRunningUuid(loggerUuid, false);
            this.sessionManager.alertClientsOfTermination(loggerUuid, finalReturnCode);
        }
    }

    private IPrintWriterSession sessionFor(JSONObject json, PrintStream out, PrintStream err) throws JsonSchemaException {
        return JsonTypesUtil.getStringOptional(json, JSON_CONTEXT).map(this.sessionManager::makeSessionFor).orElse(new PrintWriterSession(out, err));
    }

    public void notifyShutdown() {
        this.sessionManager.alertClientsOfShutdown();
    }

    protected void setLastRequest(LocalDateTime time) {
        this.lastRequest = time;
    }

    protected void updateRunningUuid(String uuid, boolean add) {
        if (add) {
            this.runningUuid.add(uuid);
        } else {
            this.updateLastRequest(true);
            this.runningUuid.remove(uuid);
        }
    }

    protected void setAtLeastOneService(boolean atLeastOne) {
        this.atLeastOneService = atLeastOne;
    }
}

