/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.google.common.base.Strings;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.uc.cli.internal.filter.SearchableComponent;
import java.util.List;
import java.util.Objects;

public class SearchedComponent {
    private final IUcComponent component;
    private final List<String> metadata;
    private final String dispId;

    public SearchedComponent(SearchableComponent comp, List<String> meta) {
        this.component = comp.component();
        this.metadata = meta;
        this.dispId = Strings.isNullOrEmpty((String)comp.extId()) ? comp.id() : comp.id() + " from " + comp.extId();
    }

    public String displayableId() {
        return this.dispId;
    }

    public IUcComponent component() {
        return this.component;
    }

    public List<String> metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchedComponent)) {
            return false;
        }
        SearchedComponent other = (SearchedComponent)o;
        return Objects.equals(this.component.id(), other.component.id()) && Objects.equals(this.metadata, other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.component.id(), this.metadata);
    }

    public String toString() {
        return this.component.displayableId() + String.valueOf(this.metadata);
    }
}

