/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.enums.Severity;
import com.silabs.ss.framework.uc.api.cli.WorkingDirectory;
import com.silabs.ss.framework.uc.core.api.context.IUcContext;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.internal.persist.IPersistedCliConfig;
import com.silabs.ss.framework.uc.core.internal.persist.PersistedCliConfig;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.LoggingCliOutput;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class CliOutput
extends LoggingCliOutput {
    private final CliSessionData session;
    private final IPersistedCliConfig config;
    private final Path workingDirectory;
    private final CliUnifiedLogger logger;
    private final Collection<IUcContext> contexts;

    public CliOutput(CliSessionData session, IPersistedCliConfig config, Path workingDirectory, IUnifiedLogger logger) {
        this(session, config, workingDirectory, logger, new HashSet<IUcContext>());
    }

    public static CliOutput systemDefaultWithWriters(CliSessionData session, IUnifiedLogger logger) {
        return new CliOutput(session, (IPersistedCliConfig)PersistedCliConfig.INSTANCE, WorkingDirectory.workingDirectory(), logger);
    }

    public CliOutput(CliSessionData session, IPersistedCliConfig config, Path workingDirectory, IUnifiedLogger logger, Collection<IUcContext> contexts) {
        super(session.out(), session.err());
        this.session = session;
        this.config = Objects.requireNonNull(config);
        this.workingDirectory = Objects.requireNonNull(workingDirectory);
        this.logger = new CliUnifiedLogger(session.uuid(), logger);
        this.contexts = contexts;
    }

    @Override
    public IUnifiedLogger unifiedLogger() {
        return this.logger;
    }

    @Override
    public IPersistedCliConfig config() {
        return this.config;
    }

    @Override
    public CliSessionData session() {
        return this.session;
    }

    @Override
    public Path resolve(String path) {
        return FileUtils.resolve((Path)this.workingDirectory, (String)path);
    }

    @Override
    public Path workingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void registerContext(IUcContext context) {
        this.contexts.add(context);
    }

    @Override
    public Collection<IUcContext> contexts() {
        return this.contexts;
    }

    @Override
    public CliOutput changeWorkingDirectory(Path p) {
        return new CliOutput(this.session, this.config, p, this.logger.wrap, this.contexts);
    }

    private class CliUnifiedLogger
    implements IUnifiedLogger {
        private final String preamble;
        private final IUnifiedLogger wrap;

        public CliUnifiedLogger(String uuid, IUnifiedLogger wrap) {
            this.preamble = uuid + ": ";
            this.wrap = wrap;
        }

        public void userMessage(String message, Throwable throwable) {
            CliOutput.this.loggingOutStream.printNoLog(message);
            this.writeToSharedLog(Severity.INFO, message, throwable);
        }

        public void userWarning(String message, Throwable throwable) {
            CliOutput.this.loggingOutStream.printNoLog(message);
            this.writeToSharedLog(Severity.WARNING, message, throwable);
        }

        public void userError(String message, Throwable throwable) {
            CliOutput.this.loggingErrStream.printNoLog(message);
            this.writeToSharedLog(Severity.ERROR, message, throwable);
        }

        public void internalInfo(String message, Throwable throwable) {
            this.writeToSharedLog(Severity.INFO, message, throwable);
        }

        public void internalWarning(String message, Throwable throwable) {
            this.writeToSharedLog(Severity.WARNING, message, throwable);
        }

        public void internalError(String message, Throwable throwable) {
            this.writeToSharedLog(Severity.ERROR, message, throwable);
        }

        private void writeToSharedLog(Severity sev, String message, Throwable throwable) {
            if (message == null && throwable == null) {
                return;
            }
            if (message == null) {
                message = throwable.getMessage();
            }
            if (message == null) {
                message = "";
            }
            String qualifiedMsg = message.startsWith(this.preamble) ? message : this.preamble + message;
            this.wrap.log(sev, this.convertThrowableToString(qualifiedMsg, throwable), null);
        }

        private String convertThrowableToString(String qualifiedMsg, Throwable throwable) {
            if (throwable == null) {
                return qualifiedMsg;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Throwable throwable2 = null;
            Object var5_6 = null;
            try (PrintWriter pw = new PrintWriter(bos){

                @Override
                public void print(String s) {
                    super.print("  " + s);
                }
            };){
                throwable.printStackTrace(pw);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            return qualifiedMsg + "\n" + bos.toString();
        }
    }
}

