/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.shared;

import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.util.Optional;

public interface RunningFileRead {
    public boolean isAwaiting();

    public Optional<SlcDaemonSharedData> connectedDaemon();

    public static enum EmptyStates implements RunningFileRead
    {
        NO_RUNNING_FILE{

            @Override
            public boolean isAwaiting() {
                return false;
            }

            @Override
            public Optional<SlcDaemonSharedData> connectedDaemon() {
                return Optional.empty();
            }
        }
        ,
        AWAITING_RUNNING_FILE{

            @Override
            public boolean isAwaiting() {
                return true;
            }

            @Override
            public Optional<SlcDaemonSharedData> connectedDaemon() {
                return Optional.empty();
            }
        }
        ,
        CORRUPTED_RUNNING_FILE{

            @Override
            public boolean isAwaiting() {
                return false;
            }

            @Override
            public Optional<SlcDaemonSharedData> connectedDaemon() {
                return Optional.empty();
            }
        };

    }

    public static final class ProperFile
    implements RunningFileRead {
        private final SlcDaemonSharedData data;

        ProperFile(SlcDaemonSharedData data) {
            this.data = data;
        }

        public SlcDaemonSharedData sharedData() {
            return this.data;
        }

        @Override
        public boolean isAwaiting() {
            return false;
        }

        @Override
        public Optional<SlcDaemonSharedData> connectedDaemon() {
            return Optional.of(this.data);
        }
    }
}

