/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.util;

import com.silabs.uc.cli.internal.model.ICliOutput;
import org.eclipse.core.runtime.IProgressMonitor;

public class FeedbackProgressMonitor
implements IProgressMonitor {
    private static final int NTH = 50;
    private int totalWork = 100;
    private int worked = 0;
    private int pastNth = 0;
    private boolean cancelled;
    private final ICliOutput feedback;

    public FeedbackProgressMonitor(ICliOutput feedback) {
        this.feedback = feedback;
    }

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        this.feedback.out().println("[" + " ".repeat(50) + "]");
        this.feedback.out().print("[");
    }

    public void done() {
    }

    public void internalWorked(double work) {
        this.worked = (int)((double)this.worked + work);
        int futureNth = this.calcPart();
        if (futureNth > this.pastNth) {
            this.pastNth = futureNth;
            this.feedback.out().print("=");
            if (futureNth >= 50) {
                this.feedback.out().println("]");
            }
        }
    }

    private int calcPart() {
        return (int)((double)this.worked / (double)this.totalWork * 50.0);
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void setCanceled(boolean value) {
        this.feedback.out().println("Cancellation Requested");
        this.cancelled = value;
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
        this.internalWorked(work);
    }
}

