/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.Result;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.thread.SilabsExecutors;
import com.silabs.java.utils.thread.SilabsThreadFactory;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.framework.uc.api.generation.UcGeneration;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspace;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceIncludedProject;
import com.silabs.ss.framework.uc.core.api.model.slcw.IUcWorkspaceMutable;
import com.silabs.ss.framework.uc.core.api.model.uihint.IHighlightHint;
import com.silabs.ss.framework.uc.core.api.model.uihint.IResolvedHighlightHint;
import com.silabs.ss.framework.uc.core.api.model.uihint.UiHint;
import com.silabs.ss.framework.uc.core.api.model.uihint.UiHintId;
import com.silabs.ss.framework.uc.core.api.project.state.ISessionToolchains;
import com.silabs.ss.framework.uc.core.api.project.state.IUcProjectState;
import com.silabs.ss.framework.uc.core.internal.api.parse.SpecVersionMilestones;
import com.silabs.ss.platform.api.rcp.core.CommonSplitters;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.UcCliPossibilities;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliProjectOrWorkspaceImplicit;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliGenerator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import picocli.CommandLine;

public final class CliGenerate {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Option(names={"--require-clean-project"}, description={"Requires that an .slcp have no warnings, otherwise generation will be halted."})
    boolean requireCleanProject;
    @CommandLine.Option(names={"-tlcn", "--toolchain"}, paramLabel="TOOLCHAIN", description={"The toolchain to generate for. Toolchain components brought in are not treated the same as standard components and should not appear in any other components dependency graph."})
    private String toolchain;
    @CommandLine.Option(names={"--toolchain-locations"}, paramLabel="TOOLCHAIN_LOCATION_ENTRY", description={"Comma separated list of session specific toolchain entries for this generation. Each entry is composed of a toolchain id (for instance, 'gcc'), a ':', and then the file path to the toolchain executable. Each entry is separated by a ','. In most cases, this field is better filled in using SLT Configuration files and has special rules. Whilst it can be set like any other cli option, the '[ toolchain ]' category is examined and each key/value there will be collected and treated as input to this option unless an SLT option for 'toolchain-locations' is explicitly defined."}, split=",")
    private List<String> toolchainLocations;
    @CommandLine.Option(names={"-o", "--output-type"}, completionCandidates=OutputTypeCandidates.class, description={"The output of the generation, effectively what kinds of files should be generated, and for what tools/ides. You may list more than one type, separated by commas. Some types may not be available depending on the selected project or components. All known output types: [ ${COMPLETION-CANDIDATES} ]"})
    private String outputType;
    @CommandLine.ArgGroup(exclusive=true, heading="Copy Options")
    CopyType copyType = new CopyType();
    @CommandLine.Option(names={"-tpl", "--template-output"}, description={"Causes all files to be generated as in the template style. This is useful for pre-made examples. This turns on no_copy and therefore cannot be used with copy sources."})
    private boolean templateOutput;
    @CommandLine.Option(names={"-np", "--new-project"}, description={"This runs the new project layout generation step. This will copy the slcp file and all files defined in the slcp into the output directory by default. All files referenced from the slcp will have their references updated to point to the copied location. Any sources that should be highlighted will be shown on the CLI output. The new location can be used for any subsequent generations."})
    private boolean newProject;
    @CommandLine.Option(names={"-extmpl", "--export-templates"}, paramLabel="EXPORT_TEMPLATES_FOLDER", description={"Specifies that the exporters should look in this directory for custom export templates. Each exporter requires it's own particular name for the files in this directory, but generally they are looking for the same files defined in the global exporter directory (<install>/developer/exporter_templates) using 'custom.<extension>' (e.g. custom.project.mak)"})
    private String exportTempLoc;
    @CommandLine.Option(names={"-tools", "--config-tools"}, description={"Specifies the tools that should generate based on the file extension. If this is not provided, then all active tools will generate. You may list more than one tool extension separated by commas."}, split=",")
    private List<String> tools = new ArrayList<String>();
    @CommandLine.Option(names={"-lfewp", "--list-files-ewp"}, description={"Forces the IAR *.ewp file generator to define all Project Configuration Tools contributed files in the *.ewp as well as the ipcf file. This may help some use-cases that don't support the ipcf mechanism."})
    private boolean iarListFilesEwp;
    @CommandLine.Option(names={"-name", "--project-name", "--workspace-name"}, paramLabel="OUTPUT_NAME", description={"The name of the output project or workspace. This will override the default name based on the slcp or slcw project name. This will only apply to the workspace when running generation for a workspace."})
    private String outputName;
    @CommandLine.Option(names={"--generator-timeout"}, paramLabel="GENERATOR_TIMEOUT_SECONDS", defaultValue="-1", description={"The timeout specified for each generation cycle in seconds. One call to 'generate' may result in multiple generation cycles, so the total generation time may be multiples of this input. The default is 30 seconds."})
    private long generatorTimeout;
    @CommandLine.ArgGroup(exclusive=false, heading="Incremental Build Commands")
    OverwriteSources overwriteSources = new OverwriteSources();
    private static final ExecutorService threadEngine = SilabsExecutors.newMaxCachedThreadPool((int)16, (ThreadFactory)SilabsThreadFactory.withName((String)"Cli-Generation-Thread").setDaemon(false).create());

    public BaseOptions getCliConfig() {
        return this.cliConfig;
    }

    public boolean validateExtraArgs(CliRoot root) {
        ICliOutput feedback = root.feedback(this.cliConfig);
        if (this.templateOutput && this.copyType.atLeastOneOption()) {
            feedback.err().println("template output option cannot be used with any copy sources argument.");
            return false;
        }
        if (TextUtils.hasContent((String)this.exportTempLoc)) {
            ProjectType.manager().loadFromExternalFolder(feedback.resolve(this.exportTempLoc).toFile());
        }
        return true;
    }

    public Integer runProjectGenerationNoWorkspace(CliProjectOrWorkspaceImplicit projectBase, IUcSdk sdk, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean force) {
        Optional<ProjectContainer> projectContainerOptional = projectBase.loadProjectContainer((IUcSdkContent)sdk, feedback, sltFeatures, true, true, this.requireCleanProject);
        if (projectContainerOptional.isEmpty()) {
            return -1;
        }
        ProjectContainer projectContainer = projectContainerOptional.get();
        IUcProjectMutable project = projectContainer.project();
        UcGeneration genOpts = this.setupGenerationOptions(null, project.ucFramework(), project.context().projectState(), projectBase.destination(), projectBase, feedback, force);
        return this.doRunProjectGeneration(projectContainer, genOpts, projectBase, feedback, force);
    }

    public Integer runProjectGenerationWithWorkspace(CliProjectOrWorkspaceImplicit workspaceBase, IUcWorkspaceMutable workspace, IUcSdk sdk, List<IUcWorkspaceIncludedProject> projectsToGenerate, Path workspaceLocation, String destination, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean force) {
        String realDestination = destination == null ? workspaceLocation.toString() : destination;
        Result<ProjectContainer, ? extends UcException> primaryContainerResults = this.loadWorkspaceProject(workspaceBase, workspace, sdk, workspace.primaryProject(), workspaceLocation, realDestination, feedback, sltFeatures, force);
        if (!primaryContainerResults.isOK()) {
            return ((UcException)primaryContainerResults.error()).exitCode();
        }
        if (this.outputName != null) {
            workspace.setName(this.outputName);
        }
        IUcProjectState projState = ((ProjectContainer)primaryContainerResults.okValue()).project().context().projectState();
        UcGeneration baseGenOpts = this.setupGenerationOptions(workspace, workspace.ucFramework(), projState, realDestination, workspaceBase, feedback, force);
        ArrayList<Callable<Pair>> projects = new ArrayList<Callable<Pair>>();
        for (IUcWorkspaceIncludedProject projectToGenerate : projectsToGenerate) {
            Result<ProjectContainer, ? extends UcException> projectContainerResult = projectToGenerate.equals(workspace.primaryProject()) ? primaryContainerResults : this.loadWorkspaceProject(workspaceBase, workspace, sdk, projectToGenerate, workspaceLocation, realDestination, feedback, sltFeatures, force);
            if (!projectContainerResult.isOK()) {
                return ((UcException)projectContainerResult.error()).exitCode();
            }
            projects.add(() -> this.runThreadedProjectGeneration(baseGenOpts.copy(), (ProjectContainer)projectContainerResult.okValue(), realDestination, workspaceBase, feedback, force));
        }
        try {
            List futures = threadEngine.invokeAll(projects);
            int exitCode = 0;
            for (Future future : futures) {
                Pair result = (Pair)future.get();
                if ((Integer)result.second == 0 || force) continue;
                feedback.out().println("Project " + (String)result.first + " in workspace failed to generate during generate-workspace command.");
                exitCode = (Integer)result.second;
            }
            if (exitCode != 0) {
                return exitCode;
            }
            return this.runWorkspaceGeneration(workspace, baseGenOpts.copy(), feedback);
        }
        catch (InterruptedException e) {
            feedback.unifiedLogger().userWarning("Workspace generation interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
            return -7;
        }
        catch (ExecutionException e) {
            feedback.unifiedLogger().userError("Failed to complete Workspace project generation!\n-- " + e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private Result<ProjectContainer, ? extends UcException> loadWorkspaceProject(CliProjectOrWorkspaceImplicit workspaceBase, IUcWorkspaceMutable workspace, IUcSdk sdk, IUcWorkspaceIncludedProject projectToLoad, Path workspaceLocation, String destination, ICliOutput feedback, SltSdkFeatures sltFeatures, boolean force) {
        Result<ProjectContainer, ? extends UcException> projectContainerResult = workspaceBase.loadWorkspaceProjectResults((IUcWorkspace)workspace, sdk, projectToLoad, feedback, sltFeatures, this.requireCleanProject, force);
        if (!projectContainerResult.isOK()) {
            UcException error = (UcException)projectContainerResult.error();
            feedback.unifiedLogger().userError(MessageFormat.format("Error loading project for workspace: {0}\n{1}", workspaceLocation, error.getMessage()), (Throwable)projectContainerResult.error());
        }
        return projectContainerResult;
    }

    private Pair<String, Integer> runThreadedProjectGeneration(UcGeneration genOpts, ProjectContainer project, String destination, CliProjectOrWorkspaceImplicit projectBase, ICliOutput feedback, boolean force) {
        Integer genResult = this.doRunProjectGeneration(project, genOpts, projectBase, feedback, force);
        return Pair.of((Object)project.project().id(), (Object)genResult);
    }

    private UcGeneration setupGenerationOptions(IUcWorkspaceMutable workspace, IUcFramework framework, IUcProjectState state, String genDir, CliProjectOrWorkspaceImplicit projectBase, ICliOutput feedback, boolean forceProjectGenerate) {
        ImmutableList outputTypes = this.outputType != null ? ImmutableList.copyOf((Iterable)CommonSplitters.CSV.split((CharSequence)this.outputType)) : Collections.emptyList();
        boolean cpSdk = this.copyType.preciseCopy.copySrcSdk();
        boolean cpProj = this.copyType.preciseCopy.copySrcProj();
        ImmutableList<Path> overridingAdapterPacksResolved = this.computeLocallySourcedAdapterPacks(projectBase, feedback);
        ISessionToolchains sessionToolchains = this.computeLocallySourcedToolchains(feedback);
        UcGeneration genOptions = new UcGeneration().setWorkspace(workspace).setWorkingDirectory(feedback.workingDirectory()).setInteractive(false).runAsync(false).setDestination(genDir).setAdapterPacks(overridingAdapterPacksResolved).setSessionToolchains(sessionToolchains).setCopyFiles(this.copyType.copySrc()).setCopySdk(cpSdk).setCopyProject(cpProj).setNoCopy(this.copyType.noCopy()).setTemplate(this.templateOutput).setNewProject(this.newProject).setListFilesEwp(this.iarListFilesEwp).setGenerateIfErrors(forceProjectGenerate).setOverwriteProjectConfigs(this.overwriteSources.shouldReplaceConfigs()).setOverwriteProjectSources(this.overwriteSources.shouldReplaceSources()).setIncrementalACs(!this.overwriteSources.disableIncrementalACs).setExportTemplateLocation(this.exportTempLoc).setTools(CliGenerator.convertToSetups(this.tools, feedback));
        if (workspace == null) {
            genOptions.setProjectName(this.outputName);
        }
        if (this.generatorTimeout != -1L) {
            genOptions.setGeneratorTimeout(this.generatorTimeout * 1000L);
        }
        if (!CliGenerator.handleProjectTypeSelection(genOptions, state, (Collection<String>)outputTypes, feedback)) {
            throw new UcException("", -8);
        }
        if (!CliGenerator.handleToolchainComponent(this.toolchain, framework, genOptions, feedback)) {
            throw new UcException("", -8);
        }
        return genOptions;
    }

    private ImmutableList<Path> computeLocallySourcedAdapterPacks(CliProjectOrWorkspaceImplicit projectBase, ICliOutput feedback) {
        CliExternalTools cliExtTools = projectBase.extTools();
        if (!cliExtTools.customsDefined()) {
            return null;
        }
        ImmutableList.Builder packBuilder = new ImmutableList.Builder();
        for (Path apackPath : cliExtTools.customAdapterPacks(feedback)) {
            if (!Files.isDirectory(apackPath, new LinkOption[0])) {
                feedback.out().println("Ignoring path (not a directory) for adapter pack on tool-path: " + String.valueOf(apackPath));
                continue;
            }
            packBuilder.add((Object)apackPath);
        }
        return packBuilder.build();
    }

    private ISessionToolchains computeLocallySourcedToolchains(ICliOutput feedback) {
        if (this.toolchainLocations == null) {
            return null;
        }
        HashMap<String, Path> toolchains = new HashMap<String, Path>();
        for (String toolchainEntry : this.toolchainLocations) {
            List idToLocSplit = CommonSplitters.COLON.splitToList((CharSequence)toolchainEntry);
            if (idToLocSplit.size() != 2) {
                feedback.out().println("Encountered an empty component:instance reference. Ensure there is only one comma between component ids in a 'with' or 'without' statement.");
                continue;
            }
            String id = (String)idToLocSplit.get(0);
            String location = (String)idToLocSplit.get(1);
            Path resolvedLocation = feedback.resolve(location);
            toolchains.put(id, resolvedLocation);
            feedback.unifiedLogger().internalInfo("Added custom toolchain location entry: " + id + " -> " + location + "(Location has resolved to )" + String.valueOf(resolvedLocation));
        }
        return ISessionToolchains.toolchainLocationsResolved(toolchains);
    }

    private Integer doRunProjectGeneration(ProjectContainer projectContainer, UcGeneration genOptions, CliProjectOrWorkspaceImplicit projectBase, ICliOutput feedback, boolean forceProjectGenerate) {
        String projectLabel;
        boolean forceClean;
        boolean bl = forceClean = SpecVersionMilestones.requireCleanProject((long)projectContainer.project().ucFramework().specVersion()) || this.requireCleanProject;
        if (forceClean && projectContainer.hasIssues() && !forceProjectGenerate) {
            String slcpName = projectContainer.project() != null ? projectContainer.project().parseStatus().parseLocation().map(Object::toString).orElse(".slcp") : ".slcp";
            feedback.out().println("Generation failed: " + slcpName + " contains parse issues. As of .slcs spec version " + SpecVersionMilestones.rangeToString((Range)SpecVersionMilestones.requireCleanProjectBoundary()) + ", projects must not contain any warnings to generate.");
            feedback.out().println("To override this behaviour, opt in using --force.");
            return 1;
        }
        IUcProjectMutable project = projectContainer.project();
        genOptions.setContext(project.context()).runWorkspaceGeneration(false);
        if (!genOptions.hasDestination()) {
            genOptions.setDestination(project.context().projectState().generationDirectory());
        }
        boolean success = CliGenerator.generate((IUcProject)project, genOptions, feedback);
        Path outputDir = genOptions.hasDestination() ? genOptions.destination() : project.context().projectState().generationDirectory();
        String string = projectLabel = TextUtils.hasContent((String)project.label()) ? project.label() : project.projectName();
        if (success) {
            feedback.out().println("Generation for " + projectLabel + " to " + String.valueOf(outputDir) + " has completed.");
            UiHint highlight = project.uiHint(UiHintId.HIGHLIGHTED_FILES);
            if (highlight.data().isPresent()) {
                this.renderHighlightedContent(((IHighlightHint)highlight.data().get()).resolveByProject((IUcProject)project), feedback);
            }
            return 0;
        }
        feedback.err().println("Generation to " + String.valueOf(outputDir.normalize()) + " for " + projectLabel + " did not succeed.");
        UcCliPossibilities.checkPossibilities((IUcProject)project, feedback, 20);
        return -1;
    }

    private void renderHighlightedContent(IResolvedHighlightHint highlight, ICliOutput feedback) {
        CliSessionData session = feedback.session();
        if (highlight.focus().isPresent()) {
            String focused = (String)highlight.focus().get();
            feedback.out().println(session.colourIfNeeded("Open " + focused + " to get started.", CliColour.GREEN));
        }
        if (!highlight.highlighted().isEmpty()) {
            feedback.out().println("Reference the following for more information: ");
            highlight.highlighted().forEach(hint -> feedback.out().println(session.colourIfNeeded("  " + hint, CliColour.GREEN)));
        }
    }

    private Integer runWorkspaceGeneration(IUcWorkspaceMutable workspace, UcGeneration genOptions, ICliOutput feedback) {
        boolean success;
        Path outputDir;
        genOptions.runProjectGeneration(false).runWorkspaceGeneration(true).setWorkspace(workspace);
        Path path = outputDir = genOptions.hasDestination() ? genOptions.destination() : (Path)workspace.generationDirectory().orElse(null);
        if (!genOptions.hasDestination()) {
            genOptions.setDestination(outputDir);
        }
        if (success = CliGenerator.generate(workspace, genOptions, feedback)) {
            feedback.out().println("Generation for Workspace " + workspace.name() + " to " + String.valueOf(outputDir) + " has completed.");
            return 0;
        }
        feedback.err().println("Generation for Workspace " + String.valueOf(outputDir.normalize()) + " for " + workspace.name() + " did not succeed.");
        return -10;
    }

    public static final class CopyType {
        @CommandLine.Option(names={"-cp", "--copy-sources"}, description={"Copies all files to be copied into the project including any headers. This will also ensure that all Component include paths and libraries point to the project locations. This cannot be used with template output or any other copy option."})
        private boolean copySrc;
        @CommandLine.ArgGroup(exclusive=false)
        PreciseCopyType preciseCopy = new PreciseCopyType();
        @CommandLine.Option(names={"-nocp", "--no-copy"}, description={"Causes all files to be linked into the generation location. Only generated files will exist in the generation location. This cannot be used with any other copy option."})
        private boolean noCopy;

        public boolean copySrc() {
            return this.copySrc;
        }

        public boolean noCopy() {
            return this.noCopy;
        }

        public boolean atLeastOneOption() {
            return this.copySrc || this.preciseCopy.atLeastOneOption() || this.noCopy;
        }
    }

    static class OutputTypeCandidates
    implements Iterable<String> {
        OutputTypeCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return OutputTypeCandidates.loadAllTypes().iterator();
        }

        private static List<String> loadAllTypes() {
            ArrayList<String> output = new ArrayList<String>();
            IProjectType[] iProjectTypeArray = ProjectType.manager().getAllProjectTypes();
            int n = iProjectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectType projType = iProjectTypeArray[n2];
                projType.matchingKeywords().stream().filter(s -> s.matches("\\w+")).findFirst().ifPresent(output::add);
                ++n2;
            }
            output.sort(String::compareTo);
            return output;
        }
    }

    private static final class OverwriteSources {
        @CommandLine.Option(names={"--overwrite-all"}, description={"Specifies that any files in the generation destination that have been changed in the SDK should be overwritten. This enables all subcommands in this group."})
        private boolean overwriteAll;
        @CommandLine.Option(names={"--replace-config"}, description={"Specifies that configuration files that already exist at the generation destination should be overwritten. This WILL DELETE USER PROJECT CONFIGURATION CUSTOMISATIONS! This is only intended to be used for CI/CD flows that with to have an incremental build during sdk, sdk extension, or other metadata development. "})
        private Boolean replaceConfig;
        @CommandLine.Option(names={"--replace-sources"}, description={"Specifies that any source files copied into the project should be overwritten. This WILL DELETE ANY USER CHANGES TO SOURCE CODE! This is only intended to be used for CI/CD flows that with to have an incremental build during sdk, sdk extension, or other metadata development. "})
        private Boolean replaceSources;
        @CommandLine.Option(names={"--no-incremental-ac"}, description={"Whether this generation should enable or disable automatic AC incremental generation."})
        private boolean disableIncrementalACs;

        private OverwriteSources() {
        }

        public boolean shouldReplaceConfigs() {
            if (this.replaceConfig == null) {
                return this.overwriteAll;
            }
            return this.replaceConfig;
        }

        public boolean shouldReplaceSources() {
            if (this.replaceSources == null) {
                return this.overwriteAll;
            }
            return this.replaceSources;
        }
    }

    private static final class PreciseCopyType {
        @CommandLine.Option(names={"-cpsdk", "--copy-sdk-sources"}, description={"Causes all files from the SDK to be copied into the project including any headers. This will also ensure that all Component include paths and libraries point to the project locations. This cannot be used with template output or copy all sources. This can be combined with copy project sources."})
        private boolean copySrcSdk;
        @CommandLine.Option(names={"-cpproj", "--copy-proj-sources"}, description={"Causes all files from the project file to be copied into the generation location including any headers. This will also ensure that all Component include paths and libraries point to the project locations. This cannot be used with template output or copy all sources. This can be combined with copy sdk sources."})
        private boolean copySrcProj;

        private PreciseCopyType() {
        }

        public boolean copySrcSdk() {
            return this.copySrcSdk;
        }

        public boolean copySrcProj() {
            return this.copySrcProj;
        }

        public boolean atLeastOneOption() {
            return this.copySrcSdk || this.copySrcProj;
        }
    }
}

