/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.UcSdkReference;
import com.silabs.ss.framework.uc.core.api.exception.UcException;
import com.silabs.ss.framework.uc.core.api.sdkextension.IUcSdkExtensionId;
import com.silabs.uc.cli.internal.command.mixin.ICliExtensionResolver;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.nio.file.Path;
import java.util.Optional;
import picocli.CommandLine;

public final class CliExtensionMixin
implements ICliExtensionResolver {
    @CommandLine.ArgGroup(exclusive=true)
    ExtensionArgs extensionArgs;

    public Optional<String> value() {
        if (TextUtils.hasContent((String)this.extensionId())) {
            return Optional.of(this.extensionId());
        }
        return this.extensionPath();
    }

    public String extensionId() {
        if (this.extensionArgs == null) {
            return null;
        }
        if (this.extensionArgs.extensionId != null) {
            return this.extensionArgs.extensionId;
        }
        if (this.extensionArgs.oldExtId != null) {
            return this.extensionArgs.oldExtId;
        }
        return null;
    }

    public Optional<String> extensionPath() {
        if (this.extensionArgs == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.extensionArgs.extensionPath);
    }

    public void overrideExtensionPath(String extPath, String reason, ICliOutput feedback) {
        if (this.extensionArgs == null) {
            this.extensionArgs = new ExtensionArgs();
        } else if (this.extensionArgs.extensionId != null || this.extensionArgs.oldExtId != null || this.extensionArgs.extensionPath != null) {
            feedback.out().println(reason);
        }
        this.extensionArgs.extensionId = null;
        this.extensionArgs.oldExtId = null;
        this.extensionArgs.extensionPath = extPath;
    }

    public Optional<IUcAdditionalFramework> findExtension(ICliOutput feedback, IUcFramework framework) {
        Optional<IUcAdditionalFramework> extFramework;
        String reference;
        if (this.extensionId() != null) {
            reference = this.extensionId();
            UcSdkReference extId = (UcSdkReference)UcSdkReference.fromCombinedString((String)this.extensionId()).unwrapOrThrow(s -> new UcException("Extension is incorrectly formatted: " + s, -8));
            extFramework = framework.findSdkExtension((IUcSdkExtensionId)extId);
        } else if (this.extensionPath().isPresent()) {
            reference = this.extensionPath().get();
            Path referencedExtension = CliExtensionMixin.determineReferencedExtension(reference, feedback);
            extFramework = framework.sdkExtensions().values().stream().filter(e -> {
                Path extPath = e.directory().toPath();
                return FileUtils.isSameFile((Path)referencedExtension, (Path)extPath);
            }).findFirst();
        } else {
            return Optional.empty();
        }
        if (!extFramework.isPresent()) {
            throw new UcException("SDK Extension not found for: " + reference + " in " + framework.name(), -8);
        }
        return extFramework;
    }

    private static Path determineReferencedExtension(String reference, ICliOutput feedback) {
        Path refExt = feedback.resolve(reference);
        if (refExt.getFileName().toString().endsWith(".slce")) {
            refExt = refExt.getParent();
        }
        return refExt;
    }

    @Override
    public Path resolverPath(IUcSdk sdk, ICliOutput feedback) {
        return this.extensionPath().or(() -> Optional.ofNullable(this.extensionId())).map(feedback::resolve).orElse(sdk.framework().directory().toPath());
    }

    static class ExtensionArgs {
        @CommandLine.Option(names={"-extid", "--extension-id"}, description={"Apply this operation to an extension within the sdk, as opposed to the sdk itself. The extension must be given in the form of 'id:version'. For instance, an extension with id 'arc' of version '2.0.1' would  be passed as 'arc:2.0.1'. If either extension option is left off, this operation will apply to the sdk itself."})
        private String extensionId;
        @CommandLine.Option(names={"-ext", "--extension"}, hidden=true)
        private String oldExtId;
        @CommandLine.Option(names={"-extpath", "--extension-path"}, description={"Apply this operation to an extension within the sdk, as opposed to the sdk itself. The extension must be  given in the form of a file path either relative to the SDK or absolute.  If either extension option is left off, this operation will apply to the sdk itself."})
        private String extensionPath;

        ExtensionArgs() {
        }
    }
}

