/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.mixin;

import com.google.common.collect.ImmutableList;
import com.silabs.ss.framework.uc.core.api.log.UcLogging;
import com.silabs.ss.framework.uc.core.internal.persist.IPersistedCliConfig;
import com.silabs.ss.framework.uc.core.internal.persist.PropertyBackedPersistedCliConfig;
import com.silabs.uc.cli.internal.command.mixin.HelpOptions;
import com.silabs.uc.cli.internal.model.CliOutput;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import picocli.CommandLine;

public class BaseOptions {
    @CommandLine.Mixin
    HelpOptions helpOptions;
    public static final ImmutableList<String> CLI_CONFIG_NAMES = ImmutableList.of((Object)"--cli-config");
    public static final ImmutableList<String> SLT_FILE_NAMES = ImmutableList.of((Object)"--slt-config");
    public static final ImmutableList<String> SLT_DEACTIVATION = ImmutableList.of((Object)"--ignore-slt");
    @CommandLine.Option(names={"--cli-config"}, description={"Location of old-world cli config file. For your system, this will default to your user home folder ${sys:user.home}, inside .uc${sys:file.separator}cli${sys:file.separator}cli.config"})
    private String cliConfiguration;
    @CommandLine.Option(names={"-wrk", "--working-directory"}, description={"Location of working directory. This is typically specified automatically but may be manually overridden. Relative paths are resolved against the automatically specified path."})
    private String workingDirectory;
    public static final ImmutableList<String> VERBOSITY_OPTIONS = ImmutableList.of((Object)"-v", (Object)"--verbose");
    @CommandLine.Option(names={"-v", "--verbose"}, paramLabel="VERBOSITY_LEVEL", converter={UcLoggingConverter.class}, description={"The verbosity level that should be logged. Value values: ${COMPLETION-CANDIDATES}"})
    private UcLogging verboseLevel;
    @CommandLine.Option(names={"-log", "--log-only"}, paramLabel="LOG_ONLY", description={"If set, all errors, warnings, and informational printing will go only to the process log files. Nothing will be printed to the console."})
    private boolean logOnly;
    @CommandLine.Option(names={"-debug"}, hidden=true, description={"Enable specialized debugging information. This will print information from the CLI Launcher and some commands may print debugging specific information."})
    private boolean debug;
    @CommandLine.Option(names={"-noperf", "--disable-performance-measure"}, hidden=true, description={"Opts out of performance measuring. By default, performance data is captured. If this is provided, performance becomes turned off. If this is running in daemon mode, all future calls will also have performance logging disabled."})
    private boolean noPerformanceLogging;
    @CommandLine.Option(names={"--slt-config"}, description={"Location of SLT Configuration File. If specified or if a default one is found in the working directory/project (depending on nature of the command) then the configuration options will be used to supply default values for any command line options. Refer to SLT Configuration documentation for more information. In general, data in [core] and [slc] are considered, and option names can be any of the --double-dash forms of any option. This alternative to supplying cli arguments on the command line itself applies to any option in any command. If multiple --double-dash names are used that refer to the same command but have different values in the configuration file or its included files, then the final value of the option is undefined. Do not do this."})
    private String sltConfigFile;
    @CommandLine.Option(names={"--ignore-slt"}, description={"If set on the command line, turns off SLT Configuration File processing and location. No command defaults will be supplied from any SLT Configuration File, even if one would otherwise be auto-detected. This only makes sense set as a command line option -- setting this in an SLT Configuration File itself is silly and won't work."})
    private boolean ignoreSlt;

    public boolean debug() {
        return this.debug;
    }

    public Optional<Path> chosenSltConfig(ICliOutput feedback) {
        return this.sltConfigFile != null ? Optional.of(feedback.resolve(this.sltConfigFile)) : Optional.empty();
    }

    public boolean ignoreSlt() {
        return this.ignoreSlt;
    }

    public IPersistedCliConfig cliConfiguration(IPersistedCliConfig systemConfig, Path workingDirectory) {
        return BaseOptions.cliConfiguration(systemConfig, workingDirectory, this.cliConfiguration);
    }

    public static IPersistedCliConfig cliConfiguration(IPersistedCliConfig systemConfig, Path workingDirectory, String cliConfig) {
        if (cliConfig != null) {
            Path configLocation = Paths.get(cliConfig, new String[0]);
            return new PropertyBackedPersistedCliConfig(configLocation.isAbsolute() ? configLocation : workingDirectory.resolve(configLocation));
        }
        System.lineSeparator();
        return systemConfig;
    }

    public Path workingDirectory(Path systemWorkingDirectory) {
        if (this.workingDirectory != null) {
            return systemWorkingDirectory.resolve(Paths.get(this.workingDirectory, new String[0]));
        }
        return systemWorkingDirectory;
    }

    public ICliOutput feedback(PrintStream out, PrintStream err, ICliOutput systemDefault) {
        this.setupVerbosity();
        Path workingDir = this.workingDirectory(systemDefault.workingDirectory());
        CliSessionData modifiedSession = new CliSessionData(out, err, systemDefault.session().uuid(), systemDefault.session().isColour(), systemDefault.session().consoleWidth());
        return new CliOutput(modifiedSession, this.cliConfiguration(systemDefault.config(), workingDir), workingDir, systemDefault.unifiedLogger(), systemDefault.contexts());
    }

    public void setupVerbosity() {
        UcLogging.setLoggingLevel((UcLogging)this.verboseLevel);
        UcLogging.setLogOnly((boolean)this.logOnly);
    }

    static class UcLoggingConverter
    implements CommandLine.ITypeConverter<UcLogging> {
        UcLoggingConverter() {
        }

        public UcLogging convert(String arg) throws Exception {
            switch (arg.toLowerCase(Locale.ROOT)) {
                case "0": {
                    return UcLogging.SILENT;
                }
                case "1": {
                    return UcLogging.DEFAULT_LOGGING;
                }
                case "2": {
                    return UcLogging.DEBUG;
                }
                case "3": {
                    return UcLogging.TRACE;
                }
            }
            return Stream.of(UcLogging.values()).filter(e -> e.name().equalsIgnoreCase(arg) || e.toString().equalsIgnoreCase(arg)).findFirst().orElseThrow(() -> new CommandLine.TypeConversionException("expected one of " + Arrays.toString(UcLogging.values()) + " (case-insensitive) but was '" + arg + "'"));
        }
    }
}

