/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.Result;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQualityUtils;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssue;
import com.silabs.ss.framework.uc.core.internal.api.parse.schema.slcu.SlcuValidator;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionLocation;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.mixin.ICliExtensionResolver;
import com.silabs.uc.cli.internal.command.model.ICliValidateLogic;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="validate-upgrade", description={"Validates the yaml of a single .slcu (upgrade manifest) file."})
public class UcCliValidateUpgrade
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={".slcu file to validate"}, paramLabel="SLCU_UPGRADE_MANIFEST")
    String manifestPath;
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliExtensionLocation extensionLocation;
    @CommandLine.ParentCommand
    private CliRoot root;
    private static final ICliValidateLogic SLCU_VALIDATE = (resolverPath, slcuFile, validQualities, feedback) -> {
        try {
            Result validatedRoot = SlcuValidator.parseAndValidate((Path)slcuFile);
            if (validatedRoot.isOK()) {
                feedback.out().println(".slcu is valid yaml.");
                return IApplication.EXIT_OK;
            }
            for (ParseIssue issue : (List)validatedRoot.right()) {
                feedback.out().println(issue.message());
            }
            return 1;
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Cannot open the .slcu file for verification: " + e.getLocalizedMessage(), (Throwable)e);
            return 2;
        }
    };

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runValidate((IUcSdk)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    public int runValidate(IUcSdk sdk, ICliOutput feedback) {
        return UcCliValidateUpgrade.runValidateExternal(sdk, this.manifestPath, this.extensionLocation, feedback);
    }

    public static int runValidateExternal(IUcSdk sdk, String metadataToValidate, ICliExtensionResolver extLoc, ICliOutput feedback) {
        Path resolverLocation = extLoc.resolverPath(sdk, feedback);
        Set validQualities = ComponentQualityUtils.getAllQualitiesFor((long)sdk.framework().specVersion());
        return ICliValidateLogic.subRunValidate(resolverLocation, metadataToValidate, validQualities, SLCU_VALIDATE, feedback);
    }
}

