/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.SdkSemanticVersion;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.context.IUcContext;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.upgrade.IProjectUpgraderSettings;
import com.silabs.ss.framework.uc.core.api.upgrade.IUpgradeCatalyst;
import com.silabs.ss.framework.uc.core.api.upgrade.ProjectUpgrader;
import com.silabs.ss.framework.uc.core.api.upgrade.ProjectUpgraderSettingsBuilder;
import com.silabs.ss.framework.uc.core.api.upgrade.UcUpgradeResult;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.ProjectRequiredException;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.command.type.SdkSemanticVersionType;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="upgrade", description={"Upgrade a project that was created with an older sdk"})
public final class UcCliUpgrade
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliExtensionMixin extensions;
    @CommandLine.Mixin
    private CliProjectImplicit projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    AllowedSeverity allowedSeverity;
    @CommandLine.Option(names={"--dry-run"}, paramLabel="DRY_RUN", description={"If present, indicates that no matter whether an upgrade would succeed or not, all that happens is a summary is reported of all run upgrade rules, but the actual upgrade is never applied to the project."})
    private boolean dryRun;
    @CommandLine.Option(names={"--source-sdk-version"}, paramLabel="SOURCE_SDK_VERSION", converter={SdkSemanticVersionType.class}, description={"Ignores the sdk reference in the .slcp file and assumes a compatible sdk reference of the given version. Effectively forces upgrade rules past a specific version to be run. This can be used by sdk authors for a 'first pass' upgraded sdk project."})
    private SdkSemanticVersion sourceSdkVersion;

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        return this.projectBase.loadProjectContainer((IUcSdkContent)sdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), true, true, false, true, true, true).map(ProjectContainer::project).map(p -> this.runUpgrade((IUcProject)p, feedback, this.force.forceOperations())).orElseThrow(ProjectRequiredException::new);
    }

    private boolean verified() {
        if (this.allowedSeverity == null) {
            return false;
        }
        return this.allowedSeverity.verified;
    }

    private boolean force() {
        if (this.allowedSeverity == null) {
            return false;
        }
        return this.allowedSeverity.force;
    }

    private Integer runUpgrade(IUcProject project, ICliOutput feedback, boolean force) {
        try {
            boolean isUngenerated;
            Path projectFileLocation = feedback.resolve(this.projectBase.projectLocation());
            Path destination = projectFileLocation.getParent();
            Path configFiles = destination.resolve("config");
            boolean bl = isUngenerated = !Files.exists(configFiles, new LinkOption[0]);
            if (isUngenerated && this.sourceSdkVersion == null) {
                feedback.out().println("There is no generated 'config' folder at " + String.valueOf(destination) + " -- only projects already generated have need of upgrades.");
                return -3;
            }
            EnumSet<UcUpgradeResult.Status> doNotWantStatuses = EnumSet.complementOf(EnumSet.of(UcUpgradeResult.Status.AUTOMATIC, UcUpgradeResult.Status.NOTHING));
            if (this.verified() || this.force()) {
                doNotWantStatuses.remove(UcUpgradeResult.Status.USER_VERIFICATION);
            }
            if (this.force()) {
                doNotWantStatuses.remove(UcUpgradeResult.Status.IMPOSSIBLE);
            }
            ProjectUpgraderSettingsBuilder settingsBuilder = IProjectUpgraderSettings.builder();
            if (this.sourceSdkVersion != null) {
                settingsBuilder.setExplicitSdkVersion(this.sourceSdkVersion);
            }
            Optional<IUcAdditionalFramework> requestedExtension = this.extensions.findExtension(feedback, project.ucFramework());
            List requestedExtList = requestedExtension.map(IUcAdditionalFramework::extensionId).map(List::of).orElse(List.of());
            IProjectUpgraderSettings settings = settingsBuilder.build();
            IUpgradeCatalyst catalyst = IUpgradeCatalyst.forProject((IUcProject)project, (String)projectFileLocation.getFileName().toString(), (String)project.projectName());
            List results = ProjectUpgrader.createUpgradedProject((IUcContext)project.context(), (IUcFramework)project.ucFramework(), requestedExtList, (Path)configFiles, (Path)destination, (IUpgradeCatalyst)catalyst, (IProjectUpgraderSettings)settings, (IUnifiedLogger)feedback.unifiedLogger());
            boolean haltUpgrade = results.stream().anyMatch(res -> doNotWantStatuses.contains(res.status()));
            if (haltUpgrade) {
                results.forEach(result -> this.renderResult((UcUpgradeResult)result, feedback));
                feedback.out().println("upgrade was cancelled because of invalid statuses.");
                return -14;
            }
            haltUpgrade = results.stream().allMatch(res -> res.status() == UcUpgradeResult.Status.NOTHING);
            results.forEach(result -> this.renderResult((UcUpgradeResult)result, feedback));
            if (!haltUpgrade) {
                if (!this.dryRun) {
                    boolean writeConfigs = !isUngenerated;
                    ProjectUpgrader.commitUpgradedProject((IUcContext)project.context(), (IUpgradeCatalyst)catalyst, (Path)projectFileLocation, (boolean)writeConfigs);
                    boolean anyImpossible = results.stream().anyMatch(res -> res.status() == UcUpgradeResult.Status.IMPOSSIBLE);
                    if (!anyImpossible) {
                        feedback.out().println("Project has been upgraded.");
                    } else {
                        feedback.out().println("Despite issues, the project was requested to be upgraded.");
                    }
                    feedback.out().println("A full generation should be run to sync the generated content with the new SDK.");
                } else {
                    feedback.out().println("Project is otherwise upgradeable, but a dry run was requested. Nothing has been modified.");
                }
                return IApplication.EXIT_OK;
            }
            feedback.out().println("An upgrade was not performed.");
            return -14;
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Cannot run upgrade due to " + e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private void renderResult(UcUpgradeResult result, ICliOutput feedback) {
        CliColour resultColour = this.matchColour(result, feedback);
        String res = result.status().description() + ": " + result.message();
        feedback.out().println(feedback.session().colourIfNeeded(res, resultColour));
    }

    private CliColour matchColour(UcUpgradeResult result, ICliOutput feedback) {
        switch (result.status()) {
            case NOTHING: 
            case AUTOMATIC: {
                return CliColour.GREEN;
            }
            case IMPOSSIBLE: {
                return CliColour.RED;
            }
            case USER_VERIFICATION: {
                if (this.verified() || this.force()) {
                    return CliColour.YELLOW;
                }
                return CliColour.RED;
            }
        }
        feedback.unifiedLogger().internalError("No colour mapping for status " + String.valueOf(result.status()), null);
        return CliColour.MAGENTA;
    }

    private static final class AllowedSeverity {
        @CommandLine.Option(names={"--verified"}, paramLabel="VERIFIED", description={"If present, indicates an upgrade should follow through even if some upgrade rules indicate they require user verification."})
        private boolean verified;
        @CommandLine.Option(names={"--force-upgrade"}, paramLabel="FORCE", description={"If present, forces an upgrade regardless of any impossible or verification required results. Use with caution."})
        private boolean force;

        private AllowedSeverity() {
        }
    }
}

