/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.project.state.UcHardware;
import com.silabs.ss.framework.uc.core.internal.api.parse.SlccKey;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliProjectUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="show-available", description={"Shows available options for generation commands or filter commands on slcc files"})
public final class UcCliShowAvailable
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-t", "--toolchains"}, description={"show all available toolchains"})
    boolean showToolchains;
    @CommandLine.Option(names={"-o", "--output-types"}, description={"show all available project types"})
    boolean showProjectTypes;
    @CommandLine.Option(names={"-p", "--project-types"}, hidden=true)
    boolean legacyShowProjectTypes;
    @CommandLine.Parameters(description={"zero or more names of .slcc metadata to show all instances of. This can only accept searchable metadata."}, paramLabel="METADATA_TO_SEARCH", split=",")
    List<String> metadataToSearch = new ArrayList<String>();

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runShowAvailable((IUcSdk)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    public int runShowAvailable(IUcSdk sdk, ICliOutput feedback) {
        IUcFramework framework = sdk.framework();
        int returnCode = IApplication.EXIT_OK;
        boolean atLeastOnce = false;
        if (this.showToolchains) {
            feedback.out().println("toolchains:");
            UcCliShowAvailable.printAvailableToolchains(framework, feedback);
            atLeastOnce = true;
        }
        if (this.showProjectTypes || this.legacyShowProjectTypes) {
            feedback.out().println("project types: ");
            CliProjectUtility.printAllProjectTypes(feedback);
            atLeastOnce = true;
        }
        for (String metadata : this.metadataToSearch) {
            if (UcCliShowAvailable.checkAndPrintSlccKey(metadata, framework, feedback)) {
                atLeastOnce = true;
                continue;
            }
            feedback.err().println(metadata + " not recognised. Only searchable slcc metadata values (ex: provides, name, category) allowed.");
            returnCode = -1;
        }
        if (!atLeastOnce) {
            feedback.out().println("Nothing was specified to show. Please see usage for options.");
            this.spec.commandLine().usage(feedback.out());
        }
        return returnCode;
    }

    private static void printAvailableToolchains(IUcFramework framework, ICliOutput feedback) {
        feedback.out().println("Available Toolchains: " + UcHardware.toolchain().findAllComponents((IUcComponentContainer)framework).stream().collect(Collectors.joining(", ")));
        feedback.out().println("Toolchains can be provided omitting the 'toolchain_' prefix.");
    }

    private static boolean checkAndPrintSlccKey(String arg, IUcFramework framework, ICliOutput feedback) {
        SlccKey key = SlccKey.find((String)arg);
        if (key == SlccKey.UNKNOWN) {
            return false;
        }
        if (!key.isSearchable()) {
            feedback.err().println(arg + " is not a printable input.");
            return true;
        }
        String output = framework.allComponents().flatMap(arg_0 -> ((SlccKey)key).searchable(arg_0)).distinct().sorted().collect(Collectors.joining(System.lineSeparator(), "Defined values for " + arg + ":" + System.lineSeparator(), ""));
        feedback.out().println(output);
        return true;
    }
}

