/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.silabs.ss.framework.project.api.core.property.IDefine;
import com.silabs.ss.framework.uc.api.python.validator.ConfigValidationIssue;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.IUcSharedMetadata;
import com.silabs.ss.framework.uc.core.api.comp.ApiPartaker;
import com.silabs.ss.framework.uc.core.api.comp.ConfigFile;
import com.silabs.ss.framework.uc.core.api.comp.IOverrideable;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.ValidationScript;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.validate.ApiExpression;
import com.silabs.ss.framework.uc.core.api.validate.ComponentRule;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.ss.framework.uc.core.internal.api.config.DefineParser;
import com.silabs.ss.framework.uc.internal.api.project.setup.UcConfigurationValidator;
import com.silabs.ss.framework.uc.internal.api.python.validator.PyProjectValidation;
import com.silabs.ss.platform.api.rcp.core.CommonSplitters;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.mixin.PythonDryRunnerCommonOptions;
import com.silabs.uc.cli.internal.command.pyvalidate.PyComponentIdDryRun;
import com.silabs.uc.cli.internal.command.pyvalidate.PyConfigurableDryRun;
import com.silabs.uc.cli.internal.command.pyvalidate.PyValidationProjectDryRun;
import com.silabs.uc.cli.internal.command.pyvalidate.UserAdded;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="validation-test", description={"Run a validation script without a project context by manually supplying #define values, selected components, and libraries. Most arguments can take long lists of things with spaces, so be sure to double-quote all relevant arguments."})
public final class UcCliPythonDryRunner
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private PythonDryRunnerCommonOptions dryOptions;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-noapi", "--no-api-list"}, description={"comma separated list of apis that should be removed from consideration, even if a selected component would otherwise be providing said api."}, paramLabel="NO_API_LIST", split=",")
    private List<String> apiSubtract = new ArrayList<String>();
    static final Splitter SPACE = Splitter.on((char)' ').omitEmptyStrings().trimResults();

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runDryRunner((IUcSdkContent)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    private int runDryRunner(IUcSdkContent sdk, ICliOutput feedback) {
        ValidationScript script = ValidationScript.fromFile((Path)feedback.resolve(this.dryOptions.scriptPath()));
        Set<ValidationScript> finalLibraries = UcCliPythonDryRunner.parseLibraries(this.dryOptions.libraries(), feedback);
        IUcFramework framework = sdk.framework();
        PyValidationProjectDryRun pyApi = new PyValidationProjectDryRun(framework);
        HashMap<String, PyConfigurableDryRun> generatedConfigs = new HashMap<String, PyConfigurableDryRun>();
        UcCliPythonDryRunner.parseDefines(this.dryOptions.componentDefines(), pyApi, generatedConfigs, feedback);
        ImmutableSetMultimap<ApiId, ComponentRule> apis = ImmutableSetMultimap.of();
        if (!Strings.isNullOrEmpty((String)this.dryOptions.componentIds())) {
            List compAndInstances = CommonSplitters.CSV.splitToList((CharSequence)this.dryOptions.componentIds());
            List<String> components = compAndInstances.stream().map(compInsta -> (String)SPACE.split((CharSequence)compInsta).iterator().next()).collect(Collectors.toList());
            apis = this.computeAvailableApis(framework, components);
            for (String compInsta2 : compAndInstances) {
                UcCliPythonDryRunner.handleComponentListing(compInsta2, framework, (Set<ApiId>)apis.keySet(), pyApi, generatedConfigs, feedback);
            }
        }
        pyApi.setProvided(apis.keySet().stream().map(ApiId::id).collect(Collectors.toSet()));
        Path reportDestination = this.dryOptions.report() != null ? feedback.workingDirectory().resolve(this.dryOptions.report()) : null;
        framework.allComponents().map(IUcSharedMetadata::id).forEach(pyApi::registerComponentToSdk);
        String output = UcConfigurationValidator.customValidate(Collections.singletonList(script), finalLibraries, (PyProjectValidation)pyApi, (IUnifiedLogger)feedback.unifiedLogger()).map(ConfigValidationIssue::message).collect(Collectors.joining(System.lineSeparator()));
        feedback.out().println(output);
        UcCliPythonDryRunner.reportResults(reportDestination, output, feedback);
        return Strings.isNullOrEmpty((String)output) ? IApplication.EXIT_OK : -1;
    }

    public static void reportResults(Path reportDestination, String output, ICliOutput feedback) {
        block13: {
            try {
                if (reportDestination == null) break block13;
                if (Files.isDirectory(reportDestination, new LinkOption[0])) {
                    feedback.out().println("cannot generate report -- path provided is a directory.");
                    break block13;
                }
                if (!Files.exists(reportDestination, new LinkOption[0])) {
                    Files.createFile(reportDestination, new FileAttribute[0]);
                }
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedWriter reportWriter = Files.newBufferedWriter(reportDestination, new OpenOption[0]);){
                    reportWriter.write(output);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                feedback.unifiedLogger().userError("Could not create report file due to " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Set<ValidationScript> parseLibraries(String rawLibraries, ICliOutput feedback) {
        HashSet<ValidationScript> libraries = new HashSet<ValidationScript>();
        if (!Strings.isNullOrEmpty((String)rawLibraries)) {
            for (String lib : CommonSplitters.CSV.split((CharSequence)rawLibraries)) {
                ImmutableList pathAndName = ImmutableList.copyOf((Iterable)SPACE.split((CharSequence)lib));
                if (pathAndName.size() != 2) {
                    feedback.out().println("Library entry '" + lib + " is not divided properly into library path/name by a single space");
                }
                String libPath = (String)pathAndName.get(0);
                String libName = (String)pathAndName.get(1);
                libraries.add(ValidationScript.fromNamedFile((Path)feedback.resolve(libPath), (String)libName));
            }
        }
        return libraries;
    }

    public static void parseDefines(String rawDefines, PyValidationProjectDryRun pyProject, Map<String, PyConfigurableDryRun> generatedConfigs, ICliOutput feedback) {
        if (!Strings.isNullOrEmpty((String)rawDefines)) {
            for (String defineAndValue : CommonSplitters.CSV.split((CharSequence)rawDefines)) {
                ImmutableList defVal = ImmutableList.copyOf((Iterable)SPACE.split((CharSequence)defineAndValue));
                if (defVal.size() != 2) {
                    feedback.out().println("#define entry '" + defineAndValue + "' is not divided properly into define/value by a single space.");
                    continue;
                }
                generatedConfigs.put((String)defVal.get(0), pyProject.addConfigurable((String)defVal.get(0), (String)defVal.get(1)));
            }
        }
    }

    private ImmutableSetMultimap<ApiId, ComponentRule> computeAvailableApis(IUcFramework framework, Collection<String> componentIds) {
        ImmutableSetMultimap initialApis = UcApiUtils.totalApisUnconditional(componentIds.stream().map(arg_0 -> ((IUcFramework)framework).findComponent(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        ImmutableSetMultimap.Builder convertedApis = ImmutableSetMultimap.builder();
        if (!this.apiSubtract.isEmpty()) {
            Set ignore = this.apiSubtract.stream().collect(Collectors.toSet());
            for (ApiId existing : initialApis.keySet()) {
                if (ignore.contains(existing.id())) continue;
                convertedApis.putAll((Object)existing, (Iterable)initialApis.get((Object)existing));
            }
        } else {
            convertedApis.putAll((Multimap)initialApis);
        }
        for (String api : this.dryOptions.apiAdd()) {
            UserAdded userAdded = new UserAdded(api);
            convertedApis.put((Object)ApiId.make((String)api), (Object)new ComponentRule((ApiPartaker)userAdded, userAdded.rule()));
        }
        return convertedApis.build();
    }

    private static void handleComponentListing(String compAndInstances, IUcFramework framework, Set<ApiId> totalApis, PyValidationProjectDryRun pyApi, Map<String, PyConfigurableDryRun> generatedConfigs, ICliOutput feedback) {
        Iterator compInsta = SPACE.split((CharSequence)compAndInstances).iterator();
        String componentName = (String)compInsta.next();
        PyComponentIdDryRun pyComp = pyApi.selectComponent(componentName);
        ArrayList<String> instances = new ArrayList<String>();
        while (compInsta.hasNext()) {
            String nextInstance = (String)compInsta.next();
            instances.add(nextInstance);
            pyComp.addInstance(nextInstance);
        }
        Optional found = framework.findComponent(componentName);
        if (!found.isPresent()) {
            feedback.out().println("Component " + componentName + " not in sdk. Ignoring.");
        } else {
            IUcComponent c = (IUcComponent)found.get();
            for (IConditional cfgCond : c.configFiles()) {
                if (!ApiExpression.create((IConditional)cfgCond, totalApis).satisfied()) continue;
                ConfigFile cfg = (ConfigFile)((IOverrideable)cfgCond.data()).data();
                Path cfgFile = cfg.sourceFile();
                String cfgFileName = cfgFile.getFileName().toString();
                try {
                    Throwable throwable = null;
                    Object var18_21 = null;
                    try (BufferedReader reader = Files.newBufferedReader(cfgFile);){
                        for (IDefine nextDefine : DefineParser.parseDefines((BufferedReader)reader)) {
                            ArrayList<String> modifiedDefines = new ArrayList<String>();
                            if (instances.isEmpty()) {
                                modifiedDefines.add(nextDefine.getName());
                            } else {
                                for (String ins : instances) {
                                    modifiedDefines.add(nextDefine.getName().replace("INSTANCE", ins));
                                }
                            }
                            for (String define : modifiedDefines) {
                                PyComponentIdDryRun glue = pyApi.tieConfigurableToComponent(define, c.id(), nextDefine.getExpansion());
                                PyConfigurableDryRun pyConfg = pyApi.defineIdToDefine().get(define);
                                pyConfg.tieToComponent(glue);
                                pyConfg.tieToFile(cfgFileName);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (NoSuchFileException e) {
                    feedback.unifiedLogger().userWarning("Potential .slcc metadata error: config file " + String.valueOf(cfg) + " from " + c.id() + " does not exist.", (Throwable)e);
                }
                catch (IOException e) {
                    feedback.unifiedLogger().userWarning("Unexpected error opening config file " + String.valueOf(cfgFile) + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

