/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Strings;
import com.silabs.java.utils.log.Log;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.meta.IMetaSource;
import com.silabs.ss.framework.uc.core.internal.persist.CorePersistables;
import com.silabs.ss.framework.uc.core.internal.persist.PersistEntry;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="editor", hidden=true, description={"Opens the configured external editor against a component so that it may be edited. This command is experimental."})
public class UcCliEditor
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-u", "--supported"}, description={"Suspends actual editor opening -- instead, prints out a list of third-party editors known to work with this command."})
    private boolean showSupported;
    @CommandLine.Parameters
    private List<String> componentIdMaybe = new ArrayList<String>();

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        if (this.showSupported) {
            UcCliEditor.printSupported(feedback.out());
            return IApplication.EXIT_OK;
        }
        if (this.componentIdMaybe.isEmpty()) {
            feedback.err().println("a component id must be specified to open an editor for it.");
            return -1;
        }
        return this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).map(sdk -> this.runEditor((IUcSdk)sdk, feedback)).orElseThrow(SdkRequiredException::new);
    }

    private int runEditor(IUcSdk sdk, ICliOutput feedback) {
        assert (!this.componentIdMaybe.isEmpty());
        return sdk.framework().findComponent(this.componentIdMaybe.get(0)).map(comp -> UcCliEditor.handleEditorOpen(comp, feedback)).orElse(-1);
    }

    private static void printSupported(PrintStream feedback) {
        feedback.println("Known Supported Apps: ");
        feedback.println("Atom, Notepad++");
    }

    private static int handleEditorOpen(IUcComponent found, ICliOutput feedback) {
        IMetaSource source = found.metaSource();
        String argument = source.path().toAbsolutePath().normalize().toString();
        String editor = feedback.config().get((PersistEntry)CorePersistables.EXTERNAL_APP_EDITOR).orElse("");
        if (Strings.isNullOrEmpty((String)editor)) {
            feedback.out().println("Cannot open editor: none defined. Use 'slc configuration' to set a path.");
            return -1;
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(feedback.workingDirectory().toFile());
        pb.command(editor, argument);
        try {
            pb.start();
            return IApplication.EXIT_OK;
        }
        catch (IOException e) {
            feedback.err().println("Editor could not start: " + e.getMessage());
            Log.warning((String)e.getMessage(), (Throwable)e);
            return -1;
        }
    }
}

