/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.framework.uc.core.internal.persist.CorePersistables;
import com.silabs.ss.framework.uc.core.internal.persist.PersistEntry;
import com.silabs.uc.cli.internal.command.UcCliConfigWarning;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="whitelist", description={"Allows the addition or removal of directories in an sdk to a [WARNING: This configuration is currently unused] whitelist. The whitelist means that even with warnings disabled, warnings for those directories will still be displayed. This is intended to allow sdk developers to turn off warnings except for whatever sdk parts they are actively working on. The whitelist is ignored for full some commands however, such as full sdk validation."})
public class UcCliConfigWhitelist
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Whitelist action. Valid actions are: ${COMPLETION-CANDIDATES}"})
    WhitelistAction action;
    @CommandLine.Parameters(index="1..*", description={"Optional list of parameters for the action. Add and remove both take a list of entries to either add or remove."})
    List<String> actionParams = new ArrayList<String>();
    @CommandLine.ParentCommand
    UcCliConfigWarning warningCommand;

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.warningCommand.session();
        Set whitelist = feedback.config().get((PersistEntry)CorePersistables.CLI_WARNING_WHITELIST).orElse(new HashSet());
        switch (this.action) {
            case add: {
                if (this.actionParams.isEmpty()) {
                    feedback.err().println("whitelist Usage: " + UcCliConfigWhitelist.whitelistUsage());
                    return -1;
                }
                for (String value : this.actionParams) {
                    if (whitelist.add(value)) {
                        feedback.out().println("Added whitelist entry " + value);
                        continue;
                    }
                    feedback.out().println("Whitelist entry " + value + " already exists");
                }
                break;
            }
            case remove: {
                if (this.actionParams.isEmpty()) {
                    feedback.err().println("whitelist Usage: " + UcCliConfigWhitelist.whitelistUsage());
                    return -1;
                }
                for (String value : this.actionParams) {
                    if (whitelist.remove(value)) {
                        feedback.out().println("Removed whitelist entry " + value);
                        continue;
                    }
                    feedback.out().println("Whitelist entry " + value + " does not exist");
                }
                break;
            }
            case examine: {
                if (!this.actionParams.isEmpty()) {
                    feedback.err().println("Examine command takes no additional parameters.");
                    return -1;
                }
                if (whitelist.isEmpty()) {
                    feedback.out().println("No whitelisted entries");
                }
                for (String w : whitelist) {
                    feedback.out().println(w);
                }
                break;
            }
            case clear: {
                if (!this.actionParams.isEmpty()) {
                    feedback.err().println("Clear command takes no additional parameters.");
                    return -1;
                }
                int size = whitelist.size();
                whitelist.clear();
                feedback.out().println("Cleared " + size + " entries");
                break;
            }
            default: {
                throw new RuntimeException("Case statement not included: " + String.valueOf((Object)this.action));
            }
        }
        feedback.config().set((PersistEntry)CorePersistables.CLI_WARNING_WHITELIST, (Object)whitelist);
        feedback.config().persist();
        return IApplication.EXIT_OK;
    }

    private static String whitelistUsage() {
        return "add <path>, remove <path>, examine, clear";
    }

    public static enum WhitelistAction {
        add,
        remove,
        examine,
        clear;

    }
}

