/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.log.UcLogging;
import com.silabs.ss.framework.uc.core.api.project.gen.GenerationFilenameConstants;
import com.silabs.ss.framework.uc.core.api.slt.ISltConfigUnit;
import com.silabs.ss.framework.uc.core.api.slt.InvalidSltFileCheckedException;
import com.silabs.ss.framework.uc.core.api.slt.SltConfig;
import com.silabs.ss.framework.uc.core.api.slt.SltConfigUtils;
import com.silabs.ss.framework.uc.internal.api.trace.SlcTelemetryUtils;
import com.silabs.ss.platform.api.content.core.asset.AssetUtilities;
import com.silabs.ss.platform.api.security.core.trust.TrustedStorageManager;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.ICliRunner;
import com.silabs.uc.cli.internal.command.UcCliOperation;
import com.silabs.uc.cli.internal.command.UcCliStateSetup;
import com.silabs.uc.cli.internal.command.dynamic.IUcCliOperationProvider;
import com.silabs.uc.cli.internal.command.exception.CliExceptionHandler;
import com.silabs.uc.cli.internal.command.exception.CliExceptionMapper;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliProject;
import com.silabs.uc.cli.internal.command.mixin.CliProjectOrWorkspace;
import com.silabs.uc.cli.internal.command.slt.SltDefaultProvider;
import com.silabs.uc.cli.internal.command.util.OptionExtraction;
import com.silabs.uc.cli.internal.model.ICliOutput;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

public class UcCli
implements ICliRunner {
    private static final ImmutableCollection<IUcCliOperationProvider> OPERATION_PROVIDERS = ImmutableList.of();
    private static final UcCli INSTANCE = new UcCli(OPERATION_PROVIDERS);
    private final ImmutableCollection<IUcCliOperationProvider> localProviders;

    public static UcCli instance() {
        return INSTANCE;
    }

    private UcCli(ImmutableCollection<IUcCliOperationProvider> providers) {
        this.localProviders = providers;
    }

    public static UcCli junitNewInstance(ImmutableCollection<IUcCliOperationProvider> providers) {
        Preconditions.checkState((boolean)RuntimeUtils.isJUnitRunning(), (Object)"This method should only be called in a Junit test.");
        return new UcCli(providers);
    }

    public static int handleCliCommands(String[] args, ICliOutput feedback) {
        return INSTANCE.doCommand(args, feedback);
    }

    public static int handleCliCommands(String[] args, ICliOutput feedback, ImmutableCollection<IUcCliOperationProvider> operationProviders) {
        UcCli customCli = new UcCli(operationProviders);
        return customCli.doCommand(args, feedback);
    }

    @Override
    public int doCommand(String[] args, ICliOutput feedback) {
        CommandLine cmd = this.setUpCommandLineObjectInternal(args, feedback);
        return this.executeCommandLineObject(cmd, args, feedback);
    }

    public CommandLine junitSetUpCommandLineObject(String[] args, ICliOutput feedback) {
        Preconditions.checkState((boolean)RuntimeUtils.isJUnitRunning(), (Object)"Cannot call this method outside of a unit test!");
        CommandLine cmd = this.setUpCommandLineObjectInternal(args, feedback);
        return cmd;
    }

    private CommandLine setUpCommandLineObjectInternal(String[] args, ICliOutput feedback) {
        Tracer tracer = SlcTelemetryUtils.slcCoreTracer();
        Span picocliLoadup = tracer.spanBuilder("slc-command-setup").startSpan();
        try {
            CommandLine commandLine;
            block14: {
                Throwable throwable = null;
                Object var6_7 = null;
                Scope s = picocliLoadup.makeCurrent();
                try {
                    feedback.unifiedLogger().internalInfo("Program Arguments: " + Arrays.toString(args), null);
                    TrustedStorageManager.overrideDefaultTrustLocation((boolean)true);
                    AssetUtilities.setAssetsEnabled((boolean)false);
                    UcCliStateSetup.setupInitialState(args);
                    CommandLine cmd = new CommandLine((Object)new CliRoot(feedback));
                    CommandLine genCmd = (CommandLine)cmd.getSubcommands().get("generate-completion");
                    assert (genCmd != null) : "generate-completion command incorrectly removed as subcommand from root";
                    CommandLine.Model.CommandSpec genCmdSpec = genCmd.getCommandSpec();
                    String[] description = genCmdSpec.usageMessage().description();
                    description[0] = description[0] + " Make sure to configure an sdk first with slc configuration --sdk <sdk_path>";
                    genCmdSpec.usageMessage().description(description);
                    this.populateDynamicCommands(args, feedback, cmd);
                    this.assignSltValueProvidersIfNeeded(args, feedback, cmd);
                    cmd.setExitCodeExceptionMapper((CommandLine.IExitCodeExceptionMapper)CliExceptionMapper.INSTANCE);
                    cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new CliExceptionHandler(feedback));
                    cmd.setOut(new PrintWriter(feedback.out()));
                    cmd.setErr(new PrintWriter(feedback.err()));
                    CommandLine.Help.Ansi color = feedback.session().isColour() ? CommandLine.Help.Ansi.ON : CommandLine.Help.Ansi.OFF;
                    cmd.setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)color));
                    commandLine = cmd;
                    if (s == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (s != null) {
                            s.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                s.close();
            }
            return commandLine;
        }
        finally {
            picocliLoadup.end();
        }
    }

    private int executeCommandLineObject(CommandLine cmd, String[] args, ICliOutput feedback) {
        Tracer tracer = SlcTelemetryUtils.slcCoreTracer();
        Span commandExecution = tracer.spanBuilder("slc-command-execution").setAttribute("slc-args", Arrays.toString(args)).startSpan();
        try {
            int n;
            block16: {
                Throwable throwable = null;
                Object var7_8 = null;
                Scope s = commandExecution.makeCurrent();
                try {
                    Stopwatch commandTimer = UcLogging.shouldLogTiming() ? Stopwatch.createStarted() : null;
                    int returnVal = cmd.execute(args);
                    if (commandTimer != null) {
                        commandTimer.stop();
                        feedback.out().println("Command execution time (minus startup) : " + commandTimer.elapsed(TimeUnit.MILLISECONDS) + " milliseconds");
                    }
                    try {
                        feedback.shutdownContexts();
                    }
                    catch (Throwable t) {
                        feedback.unifiedLogger().userWarning("Failed to properly shutdown SLC projects! If running in Daemon mode some projects may not operate correctly in future calls!", t);
                    }
                    int exitCode = returnVal == 0 ? IApplication.EXIT_OK : returnVal;
                    feedback.unifiedLogger().internalInfo("Command exited with exit code: " + exitCode, null);
                    n = exitCode;
                    if (s == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        if (s != null) {
                            s.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                s.close();
            }
            return n;
        }
        finally {
            commandExecution.end();
        }
    }

    private void populateDynamicCommands(String[] args, ICliOutput feedback, CommandLine cmd) {
        this.localProviders.stream().flatMap(p -> p.subOperations(args, feedback).stream()).forEach(sub -> UcCli.safeAddCommand(cmd, sub, feedback));
    }

    private void assignSltValueProvidersIfNeeded(String[] args, ICliOutput feedback, CommandLine cmd) {
        OptionExtraction.argValue(args, BaseOptions.SLT_FILE_NAMES).map(feedback::resolve).or(() -> this.findSltFile(args, feedback)).ifPresent(sltFile -> {
            try {
                ISltConfigUnit slt = SltConfig.manager().fromSltConfigurationFile(sltFile, false);
                cmd.setDefaultValueProvider((CommandLine.IDefaultValueProvider)new SltDefaultProvider(slt, feedback));
            }
            catch (InvalidSltFileCheckedException e) {
                String msg = "Problems loading an SLT configuration file found at " + String.valueOf(sltFile) + ": " + e.getMessage();
                feedback.unifiedLogger().userWarning(msg, (Throwable)e);
            }
        });
    }

    private Optional<Path> findSltFile(String[] args, ICliOutput feedback) {
        boolean ignoreSlt = OptionExtraction.argToggle(args, BaseOptions.SLT_DEACTIVATION);
        if (ignoreSlt) {
            return Optional.empty();
        }
        Optional<Path> sltFile = OptionExtraction.argValue(args, CliProject.GEN_DEST_NAMES).map(feedback::resolve).flatMap(destination -> UcCli.findSltFileInFolderOrAutogen(destination, feedback));
        if (sltFile.isPresent()) {
            feedback.out().println("Using .slconf in generation destination: " + ((Path)sltFile.get()).getFileName().toString());
            return sltFile;
        }
        sltFile = UcCli.computeProjectLocation(args, feedback).flatMap(projFolder -> UcCli.findSltFileInFolderOrAutogen(projFolder, feedback));
        if (sltFile.isPresent()) {
            feedback.out().println("Using .slconf in project/workspace location: " + sltFile.get().getFileName().toString());
            return sltFile;
        }
        sltFile = UcCli.findSltFileInFolderOrAutogen(feedback.workingDirectory(), feedback);
        if (sltFile.isPresent()) {
            feedback.out().println("Using .slconf in current working directory of SLC invocation: " + sltFile.get().getFileName().toString());
            return sltFile;
        }
        return Optional.empty();
    }

    private static Optional<Path> findSltFileInFolderOrAutogen(Path folder, ICliOutput feedback) {
        List sltFiles = SltConfigUtils.searchSltIn((Path)folder, (IUnifiedLogger)feedback.unifiedLogger());
        if (sltFiles.isEmpty()) {
            sltFiles = SltConfigUtils.searchSltIn((Path)folder.resolve(GenerationFilenameConstants.autogen()), (IUnifiedLogger)feedback.unifiedLogger());
        }
        if (sltFiles.isEmpty()) {
            return Optional.empty();
        }
        if (sltFiles.size() > 1) {
            feedback.out().println("Multiple slconf files found " + sltFiles.toString());
        }
        return Optional.of((Path)sltFiles.get(0));
    }

    private static Optional<Path> computeProjectLocation(String[] args, ICliOutput feedback) {
        return OptionExtraction.argValue(args, CliProject.PROJECT_OPTIONS).or(() -> OptionExtraction.argValue(args, CliProjectOrWorkspace.WORKSPACE_OPTIONS)).or(() -> UcCli.findProjectPositionalParameter(args, feedback)).map(feedback::resolve).map(p -> "slcp".equals(FileUtils.getExtension((String)p.getFileName().toString())) ? p.getParent() : p);
    }

    private static Optional<String> findProjectPositionalParameter(String[] args, ICliOutput feedback) {
        return Optional.empty();
    }

    private static void safeAddCommand(CommandLine cmd, UcCliOperation op, ICliOutput feedback) {
        try {
            CommandLine.Model.CommandSpec spec = op.command(feedback);
            cmd.addSubcommand(op.name(), (Object)spec);
        }
        catch (CommandLine.InitializationException e) {
            feedback.unifiedLogger().userError("Dynamic command providers reported an issue with building the command line. " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            feedback.unifiedLogger().userError("Unknown exception occurred when populating dynamic command line arguments: " + e.getMessage(), (Throwable)e);
        }
    }
}

