/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.templates.manager;

import com.silabs.java.utils.ITypedFilter;
import com.silabs.java.utils.extension.ExcludeTestPluginsFilter;
import com.silabs.java.utils.extension.IExtensionInformation;
import com.silabs.java.utils.extension.OnlyTestPluginsFilter;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.ITemplateExecuteProcessesExtension;
import com.silabs.ss.framework.project.api.templates.TemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.manager.ITemplateManager;
import com.silabs.ss.framework.project.internal.templates.manager.TemplateRegistry;
import com.silabs.ss.platform.api.descriptor.core.manager.BaseManager;
import com.silabs.ss.platform.api.descriptor.core.manager.IManagerConfig;
import com.silabs.ss.platform.api.descriptor.core.manager.ManagerConfigFactory;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.sdk.core.SDK;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateManager
extends BaseManager<ITemplateDescriptor, ITemplate>
implements ITemplateManager {
    protected static final String TEMPLATE_PROVIDER_ELEMENT = "templateProvider";
    private static final String TEMPLATE_EXECUTION_EXTENSION = "templateExecutionExtension";
    private final Map<String, ITemplateExecuteProcessesExtension> templateExtensions = new ConcurrentHashMap<String, ITemplateExecuteProcessesExtension>();

    public static TemplateManager create() {
        TemplateManager tmpMgr = new TemplateManager(false, (ITypedFilter<IExtensionInformation>)new ExcludeTestPluginsFilter());
        return tmpMgr;
    }

    public static TemplateManager createForTesting() {
        TemplateManager tmpMgr = new TemplateManager(true, (ITypedFilter<IExtensionInformation>)new OnlyTestPluginsFilter());
        tmpMgr.getExtensionManager().startup();
        return tmpMgr;
    }

    public static TemplateManager createWithFilterForTesting(ITypedFilter<IExtensionInformation> filter) {
        TemplateManager tmpMgr = new TemplateManager(true, filter);
        tmpMgr.getExtensionManager().startup();
        return tmpMgr;
    }

    protected TemplateManager(boolean testMode, ITypedFilter<IExtensionInformation> filter) {
        super(TemplateManager.createConfig(testMode, filter));
    }

    private static IManagerConfig<ITemplateDescriptor, ITemplate> createConfig(boolean testMode, ITypedFilter<IExtensionInformation> filter) {
        SDK.manager().equals(null);
        return ManagerConfigFactory.forRegistryAndEntity(TemplateRegistry.createFactory(), ITemplate.class).isTestMode(testMode).withSyncLabel("Scanning examples...").isAutoEnable(true).withRegistry(TemplateRegistry.class).withProviderExtensionElement(TEMPLATE_PROVIDER_ELEMENT).createExtensionBackedManagerConfig();
    }

    protected IRegistry<ITemplateDescriptor> createExtensionManagedRegistry() {
        IRegistry reg = super.createExtensionManagedRegistry();
        this.getExtensionManager().addHandler(TEMPLATE_EXECUTION_EXTENSION, (el, added, context) -> {
            if (added) {
                this.templateExtensions.put(el.getAttribute("class"), (ITemplateExecuteProcessesExtension)el.createExecutableExtension("class"));
            } else {
                this.templateExtensions.remove(el.getAttribute("class"));
            }
        });
        return reg;
    }

    public ITemplateDescriptor createDescriptor() {
        return new TemplateDescriptor();
    }

    public ITemplateDescriptor createDescriptor(MDescriptor desc) {
        return new TemplateDescriptor(desc);
    }

    public Collection<ITemplateExecuteProcessesExtension> getTemplateExtensions() {
        return this.templateExtensions.values();
    }
}

