/*
 * Decompiled with CFR 0.152.
 */
package com.arm.cmsis.config.model;

import com.arm.cmsis.config.model.IConfigWizardItem;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigWizardItem
implements IConfigWizardItem {
    private static final String CANNOT_SET_ARRAY_FOR_NON_ARRAY_TYPE = "Cannot set array for non ARRAY type: ";
    private IConfigWizardItem fParent;
    private IConfigWizardItem.EItemType fItemType;
    private IConfigWizardItem.EItemErrorType fItemErrorType;
    private int fStartLine;
    private int fEndLine;
    private String fName;
    private String fTooltip;
    private int fSkipNumber;
    private int fMinBit;
    private int fMaxBit;
    private String fIdentifier;
    private boolean fSelection;
    private long fMinValue;
    private long fMaxValue;
    private long fValue;
    private String fIdentifierValue;
    private String fString;
    private int fStringLength;
    private int fBase;
    private long fSpinStep;
    private char fModification;
    private long fModifier;
    private boolean fInconsistent;
    private boolean fInvertValue;
    private Map<Long, String> fItems;
    private Map<String, String> fIdentifierItems;
    private LinkedList<IConfigWizardItem> fChildren;
    private Object confDefault;
    private int fArrayLength = -1;
    private int[] fArrayValues;
    private int[] fDefaultArrayValues;
    private Integer fDefaultIntegerValue = null;
    private String fDefaultStringSelection = null;
    private String fFormat = null;
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("Default:\\W+([a-zA-Z0-9 _]+)");

    public ConfigWizardItem(IConfigWizardItem.EItemType itemType, int line, IConfigWizardItem parent) {
        this.fParent = parent;
        this.fItemType = itemType;
        this.fStartLine = line;
        this.fEndLine = line;
        this.fItemErrorType = IConfigWizardItem.EItemErrorType.NO_ERROR;
        this.fName = "";
        this.fTooltip = "";
        this.fString = "";
        this.fMinBit = -1;
        this.fMaxBit = -1;
        this.fIdentifier = null;
        this.fIdentifierValue = null;
        this.fBase = 16;
        this.fModifier = 0L;
        this.fSpinStep = 0L;
        this.fItems = new TreeMap<Long, String>();
        this.fIdentifierItems = new LinkedHashMap<String, String>();
        this.fChildren = new LinkedList();
    }

    @Override
    public IConfigWizardItem getParent() {
        return this.fParent;
    }

    @Override
    public IConfigWizardItem.EItemType getItemType() {
        return this.fItemType;
    }

    @Override
    public void setItemType(IConfigWizardItem.EItemType type) {
        this.fItemType = type;
    }

    @Override
    public IConfigWizardItem.EItemErrorType getItemErrorType() {
        return this.fItemErrorType;
    }

    @Override
    public void setItemErrorType(IConfigWizardItem.EItemErrorType errorType) {
        this.fItemErrorType = errorType;
    }

    @Override
    public int getStartLine() {
        return this.fStartLine;
    }

    @Override
    public int getEndLine() {
        return this.fEndLine;
    }

    @Override
    public void setEndLine(int line) {
        this.fEndLine = line;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public Optional<Object> getDefault() {
        Optional<Object> explicitDefault = this.getTypedDefault();
        if (explicitDefault.isPresent()) {
            return explicitDefault;
        }
        return Optional.ofNullable(this.confDefault);
    }

    private Optional<Object> getTypedDefault() {
        switch (this.getItemType()) {
            case ARRAY: {
                return Optional.ofNullable(this.getDefaultArrayValues());
            }
            case OPTION_SELECT: {
                if (this.hasItems()) {
                    return this.safelyGetDefaultIntValue();
                }
                if (!this.hasIdentifierItems()) break;
                return Optional.ofNullable(this.getDefaultStringValue());
            }
            case HEADING_ENABLE: 
            case OPTION: 
            case OPTION_CHECK: {
                return this.safelyGetDefaultIntValue();
            }
            case OPTION_STRING: {
                return Optional.ofNullable(this.getDefaultStringValue());
            }
            default: {
                return Optional.ofNullable(null);
            }
        }
        return Optional.ofNullable(null);
    }

    private Optional<Object> safelyGetDefaultIntValue() {
        try {
            return Optional.of(this.getDefaultIntValue());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return this.getDefault().flatMap(this::mapDefaultToDefaultValue);
    }

    private Optional<Object> mapDefaultToDefaultValue(Object theDefault) {
        if (this.getItemType() == IConfigWizardItem.EItemType.OPTION_SELECT) {
            if (theDefault instanceof String) {
                if (this.fIdentifierItems.containsKey(theDefault)) {
                    return Optional.of(theDefault);
                }
                for (Long key : this.fItems.keySet()) {
                    String value = this.fItems.get(key);
                    if (!theDefault.equals(value)) continue;
                    return Optional.of(key);
                }
            }
            String theDefaultString = String.valueOf(theDefault);
            for (String key : this.fIdentifierItems.keySet()) {
                String value = this.fIdentifierItems.get(key);
                if (!theDefaultString.equals(value)) continue;
                return Optional.of(key);
            }
            if (theDefault instanceof Number) {
                int intValue = ((Number)theDefault).intValue();
                for (Long key : this.fItems.keySet()) {
                    if (key != (long)intValue) continue;
                    return Optional.of(theDefault);
                }
            }
            return Optional.empty();
        }
        return Optional.of(theDefault);
    }

    @Override
    public void extendTooltip(String moreTooltip) {
        String theDefault;
        Matcher defMatcher = DEFAULT_PATTERN.matcher(moreTooltip);
        if (defMatcher.find() && !Strings.isNullOrEmpty((String)(theDefault = defMatcher.group(1)))) {
            try {
                Long theDefaultLong = Long.parseLong(theDefault);
                this.confDefault = theDefaultLong;
            }
            catch (NumberFormatException numberFormatException) {
                this.confDefault = theDefault;
            }
        }
        if (!this.fTooltip.isEmpty()) {
            this.fTooltip = String.valueOf(this.fTooltip) + System.lineSeparator();
        }
        this.fTooltip = String.valueOf(this.fTooltip) + moreTooltip;
    }

    @Override
    public String getTooltip() {
        return this.fTooltip;
    }

    @Override
    public int getSkipNumber() {
        return this.fSkipNumber;
    }

    @Override
    public void setSkipNumber(int skipNumber) {
        this.fSkipNumber = skipNumber;
    }

    @Override
    public int getMinBit() {
        return this.fMinBit;
    }

    @Override
    public void setMinBit(int minBit) {
        this.fMinBit = minBit;
    }

    @Override
    public int getMaxBit() {
        return this.fMaxBit;
    }

    @Override
    public void setMaxBit(int maxBit) {
        this.fMaxBit = maxBit;
    }

    @Override
    public String getMacroName() {
        return this.fIdentifier;
    }

    @Override
    public void setMacroName(String id) {
        this.fIdentifier = id;
    }

    @Override
    public boolean isSelection() {
        return this.fSelection;
    }

    @Override
    public void setIsSelection(boolean isSelection) {
        this.fSelection = isSelection;
    }

    @Override
    public long getMinValue() {
        return this.fMinValue;
    }

    @Override
    public void setMinValue(long minValue) {
        this.fMinValue = minValue;
    }

    @Override
    public long getMaxValue() {
        return this.fMaxValue;
    }

    @Override
    public void setMaxValue(long maxValue) {
        this.fMaxValue = maxValue;
    }

    @Override
    public long getValue() {
        return this.fValue;
    }

    @Override
    public void setValue(long value) {
        this.fValue = value;
    }

    @Override
    public String getString() {
        return this.fString;
    }

    @Override
    public void setString(String string) {
        this.fString = string;
    }

    @Override
    public int getStringLength() {
        return this.fStringLength;
    }

    @Override
    public void setStringLength(int stringLength) {
        this.fStringLength = stringLength;
    }

    @Override
    public int getBase() {
        return this.fBase;
    }

    @Override
    public void setBase(int base) {
        this.fBase = base;
    }

    @Override
    public long getSpinStep() {
        return this.fSpinStep;
    }

    @Override
    public void setSpinStep(long spinStep) {
        this.fSpinStep = spinStep;
    }

    @Override
    public char getModification() {
        return this.fModification;
    }

    @Override
    public void setModification(char modification) {
        this.fModification = modification;
    }

    @Override
    public long getModifier() {
        return this.fModifier;
    }

    @Override
    public void setModifier(long modifier) {
        this.fModifier = modifier;
    }

    @Override
    public boolean isInconsistent() {
        return this.fInconsistent;
    }

    @Override
    public void setInconsistent(boolean inconsistent) {
        this.fInconsistent = inconsistent;
    }

    @Override
    public boolean invertValue() {
        return this.fInvertValue;
    }

    @Override
    public void setInvertValue(boolean invertValue) {
        this.fInvertValue = invertValue;
    }

    @Override
    public Map<Long, String> getItems() {
        return this.fItems;
    }

    @Override
    public void addItem(long key, String value) {
        this.fItems.put(key, value);
    }

    @Override
    public boolean hasItems() {
        return this.fItems.size() > 0;
    }

    @Override
    public Map<String, String> getIdentifierItems() {
        return this.fIdentifierItems;
    }

    @Override
    public void addIdentifierItem(String key, String value) {
        this.fIdentifierItems.put(key, value);
    }

    @Override
    public boolean hasIdentifierItems() {
        return this.fIdentifierItems.size() > 0;
    }

    @Override
    public void setMacroValue(String value) {
        this.fIdentifierValue = value;
    }

    @Override
    public String getMacroValue() {
        return this.fIdentifierValue;
    }

    @Override
    public void setArrayLength(int len) {
        if (this.fItemType != IConfigWizardItem.EItemType.ARRAY) {
            throw new IllegalArgumentException(CANNOT_SET_ARRAY_FOR_NON_ARRAY_TYPE + this.fItemType.name());
        }
        if (this.fArrayLength != -1) {
            throw new IllegalArgumentException("Array length cannot be modified");
        }
        this.fArrayLength = len;
    }

    @Override
    public int getArrayLength() {
        return this.fArrayLength;
    }

    @Override
    public int[] getArrayValues() {
        int[] copy = new int[this.fArrayValues.length];
        System.arraycopy(this.fArrayValues, 0, copy, 0, this.fArrayValues.length);
        return copy;
    }

    @Override
    public void setArrayValues(int[] values) {
        if (this.fItemType != IConfigWizardItem.EItemType.ARRAY) {
            throw new IllegalArgumentException(CANNOT_SET_ARRAY_FOR_NON_ARRAY_TYPE + this.fItemType.name());
        }
        if (values == null || values.length != this.fArrayLength) {
            throw new IllegalArgumentException("Array must be length: " + this.fArrayLength);
        }
        if (this.fArrayValues == null) {
            this.fArrayValues = new int[this.getArrayLength()];
        }
        System.arraycopy(values, 0, this.fArrayValues, 0, this.fArrayLength);
    }

    @Override
    public void setDefaultArrayValues(int[] values) {
        if (this.fItemType != IConfigWizardItem.EItemType.ARRAY) {
            throw new IllegalArgumentException(CANNOT_SET_ARRAY_FOR_NON_ARRAY_TYPE + this.fItemType.name());
        }
        if (this.fDefaultArrayValues != null) {
            throw new IllegalArgumentException("Default values already set");
        }
        if (values == null || values.length != this.fArrayLength) {
            throw new IllegalArgumentException("Array must be length: " + this.fArrayLength);
        }
        this.fDefaultArrayValues = new int[this.fArrayLength];
        System.arraycopy(values, 0, this.fDefaultArrayValues, 0, this.fArrayLength);
    }

    @Override
    public int[] getDefaultArrayValues() {
        return this.fDefaultArrayValues;
    }

    @Override
    public void setDefaultIntValue(int value) {
        if (this.fDefaultIntegerValue != null) {
            throw new IllegalArgumentException("Default value already set");
        }
        this.fDefaultIntegerValue = value;
    }

    @Override
    public int getDefaultIntValue() {
        if (this.fDefaultIntegerValue == null) {
            throw new IllegalArgumentException("No default value set");
        }
        return this.fDefaultIntegerValue;
    }

    @Override
    public String getDefaultStringValue() {
        return this.fDefaultStringSelection;
    }

    @Override
    public void setDefaultStringValue(String key) {
        this.fDefaultStringSelection = key;
    }

    @Override
    public List<IConfigWizardItem> getChildren() {
        return this.fChildren;
    }

    @Override
    public IConfigWizardItem getLastChild() {
        if (this.fChildren == null || this.fChildren.isEmpty()) {
            return null;
        }
        return this.fChildren.getLast();
    }

    @Override
    public void addChild(IConfigWizardItem child) {
        this.fChildren.add(child);
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    public void removeChild(IConfigWizardItem item) {
        this.fChildren.remove(item);
    }

    @Override
    public boolean canModify() {
        if (this.fItemType == IConfigWizardItem.EItemType.ROOT) {
            return true;
        }
        if (this.fItemType == IConfigWizardItem.EItemType.HEADING_ENABLE) {
            return this.getValue() > 0L && this.getParent().canModify();
        }
        return this.getParent().canModify();
    }

    @Override
    public String getFormat() {
        return this.fFormat;
    }

    @Override
    public void setFormat(String format) {
        this.fFormat = format;
    }

    public String toString() {
        return this.fName;
    }
}

