/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.part.core;

import com.silabs.java.utils.HostUtils;
import com.silabs.ss.platform.api.content.core.asset.IAssetService;
import com.silabs.ss.platform.api.demos.core.DemoProperties;
import com.silabs.ss.platform.api.demos.core.IDemoDescriptor;
import com.silabs.ss.platform.api.demos.core.IDemoHandler;
import com.silabs.ss.platform.api.demos.core.IDemoHandler2;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.rcp.core.process.HostProcessLauncherFactory;
import com.silabs.ss.platform.api.rcp.core.process.IProcessLauncher;
import com.silabs.ss.platform.api.rcp.core.process.IProcessMonitor;
import com.silabs.ss.platform.api.rcp.core.process.ProcessLauncherParameters;
import com.silabs.ss.support.mcu.api.part.core.MCUDemoUtils;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.osgi.framework.ServiceReference;

public class RunHostAppDemoHandler
implements IDemoHandler,
IDemoHandler2 {
    public static final int PRIORITY = 105;
    public static final String DEMO_TITLE = "Run with host application";
    public static final String ID = "com.silabs.ss.support.mcu.part.core.RunHostAppDemoHandler";

    public String getId() {
        return ID;
    }

    public String getLabel() {
        return DEMO_TITLE;
    }

    public boolean isDemoSupported(IDemoDescriptor demoDesc) {
        return this.validateInput(demoDesc).isOK();
    }

    public int getPriority() {
        return 105;
    }

    public void start(IDemoDescriptor demo, IDevice device) throws CoreException {
        HostAppDemoJob job = new HostAppDemoJob(demo, device);
        job.setUser(true);
        job.schedule();
    }

    public IStatus validateInput(IDemoDescriptor demo) {
        boolean hasMacLaunchArgs;
        if (demo == null) {
            return this.createErrorStatus("DemoDescriptor cannot be null", new IllegalArgumentException("Demo descriptor must be provided"));
        }
        Object hostAppUri = demo.getProperty(DemoProperties.HOST_APP_URI);
        if (hostAppUri == null || hostAppUri != null && hostAppUri.toString().length() == 0) {
            return this.createErrorStatus("No host app URL provided", new IllegalArgumentException("No host app URL provided"));
        }
        boolean hasWinLaunchArgs = demo.getProperty(DemoProperties.HOST_APP_LAUNCH_ARGS_WIN) != null;
        boolean hasLinuxLaunchArgs = demo.getProperty(DemoProperties.HOST_APP_LAUNCH_ARGS_LINUX) != null;
        boolean bl = hasMacLaunchArgs = demo.getProperty(DemoProperties.HOST_APP_LAUNCH_ARGS_MAC) != null;
        if (!(hasWinLaunchArgs || hasLinuxLaunchArgs || hasMacLaunchArgs)) {
            return this.createErrorStatus("No hostAppLaunchArgs provided", new IllegalArgumentException("No host app launch args"));
        }
        return Status.OK_STATUS;
    }

    private File getHostAppV4(String hostAppUri, String hostAppLaunchArgs, IProgressMonitor monitor) throws CoreException {
        ServiceReference serviceReference = Activator.getContext().getServiceReference(IAssetService.class.getName());
        IAssetService assetService = (IAssetService)Activator.getContext().getService(serviceReference);
        try {
            File assetLocation = assetService.resolveAsset(new URI(hostAppUri), false, null);
            File file = new Path(assetLocation.getAbsolutePath()).append(hostAppLaunchArgs).toFile();
            return file;
        }
        catch (Exception e) {
            throw Activator.reporter.newCoreException(MessageFormat.format("Failed to get hostApp at {0}", hostAppUri), (Throwable)e);
        }
        finally {
            Activator.getContext().ungetService(serviceReference);
        }
    }

    public byte[] createChecksum(String filename, String algorithmName) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream fis = new FileInputStream(filename);){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(algorithmName);
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            return complete.digest();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getChecksum(String filename, String algorithmName) throws Exception {
        byte[] b = this.createChecksum(filename, algorithmName);
        String result = "";
        int i = 0;
        while (i < b.length) {
            result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return result;
    }

    public IStatus flashDeviceAndRunApp(final File hostAppExeFile, final IDemoDescriptor demo, IDevice device, boolean resume) {
        try {
            Job flashJob = MCUDemoUtils.createFlashDemoJob(demo, device, resume);
            flashJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        HostProcessLauncherFactory factory = new HostProcessLauncherFactory();
                        RunHostAppDemoHandler.this.launchHostApp(factory, hostAppExeFile, demo, HostUtils.isWindows(), (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
            flashJob.setUser(true);
            flashJob.schedule();
        }
        catch (CoreException e) {
            Activator.reporter.logError("Error flashing device for " + demo.getLabel() + "demo", (Throwable)e);
            return this.createErrorStatus("Error flashing device for demo " + demo.getLabel(), (Exception)((Object)e));
        }
        catch (Exception e) {
            Activator.reporter.logError("Error flashing device for " + demo.getLabel() + "demo", (Throwable)e);
            return this.createErrorStatus("Error flashing device for demo " + demo.getLabel(), e);
        }
        return Status.OK_STATUS;
    }

    public IStatus launchHostApp(HostProcessLauncherFactory factory, File hostAppExe, IDemoDescriptor demoDesc, boolean isWindows, IProgressMonitor monitor) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            Activator.reporter.logWarning("Error with delay to launch host app");
            Thread.currentThread().interrupt();
        }
        ProcessLauncherParameters params = ProcessLauncherParameters.create((String[])new String[]{hostAppExe.getAbsolutePath()});
        IProcessLauncher launcher = factory.createProcessLauncher(params);
        try {
            IProcessMonitor processMonitor = launcher.createProcess(monitor);
            processMonitor.runWithoutOutput();
        }
        catch (CoreException e1) {
            Activator.reporter.logError("Error launching host app", (Throwable)e1);
            return this.createErrorStatus("Error creating process for demo", (Exception)((Object)e1));
        }
        return Status.OK_STATUS;
    }

    public IStatus createErrorStatus(String errMsg, Exception e) {
        return new Status(4, "com.silabs.ss.support.mcu.part.core", errMsg, (Throwable)e);
    }

    protected IStatus verifyLinuxDependencies(IDemoDescriptor demo, File exeFile) {
        BufferedReader input = null;
        try {
            String[] cmdarray = new String[]{"/bin/sh", "-c", "ldd " + exeFile.getAbsolutePath() + " | grep -i 'not found'"};
            Process lddProcess = Runtime.getRuntime().exec(cmdarray);
            int exitValue = lddProcess.waitFor();
            if (exitValue == 0) {
                input = new BufferedReader(new InputStreamReader(lddProcess.getInputStream()));
                StringBuilder strBldr = new StringBuilder();
                String line = null;
                boolean hasLibiconv = false;
                while ((line = input.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    strBldr.append(line);
                    strBldr.append("\n");
                    if (hasLibiconv || !line.toLowerCase(Locale.ROOT).contains("libiconv")) continue;
                    hasLibiconv = true;
                }
                if (hasLibiconv) {
                    strBldr.append("\n");
                    strBldr.append("Install Libiconv in /usr from http://www.gnu.org/software/libiconv/");
                }
                if (strBldr.length() > 0) {
                    IStatus iStatus = Activator.reporter.newErrorStatus(String.valueOf(demo.getLabel()) + " Demo is missing dependencies", new Throwable("Please install these dependencies: \n" + strBldr.toString()));
                    return iStatus;
                }
            }
        }
        catch (IOException e) {
            Activator.reporter.logError("Error checking demo dependencies", (Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.reporter.logError("Interrupt demo dependencies check", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Activator.reporter.logError("Error closing stream", (Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void start(IDemoDescriptor demo, Map<IDemoDescriptor, IDevice> nodes) throws CoreException {
        if (nodes.size() != 1) {
            Activator.reporter.logException((Throwable)new Exception("Invalid number of IDevice nodes"));
            return;
        }
        IDevice device = nodes.values().iterator().next();
        this.start(demo, device);
    }

    public class HostAppDemoJob
    extends Job {
        private IDemoDescriptor demo;
        private IDevice device;

        public HostAppDemoJob(IDemoDescriptor demo, IDevice device) {
            super(String.valueOf(demo.getLabel()) + " Demo");
            this.demo = demo;
            this.device = device;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status;
            monitor.beginTask(this.demo.getLabel(), -1);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IStatus validateStatus = RunHostAppDemoHandler.this.validateInput(this.demo);
            if (!validateStatus.isOK()) {
                return validateStatus;
            }
            String hostAppUri = ((URI)this.demo.getProperty(DemoProperties.HOST_APP_URI)).toString();
            String hostAppLaunchArgs = ((Collection)this.demo.getProperty(DemoProperties.HOST_APP_LAUNCH_ARGS_WIN)).toString();
            if (HostUtils.isOSX()) {
                hostAppLaunchArgs = ((Collection)this.demo.getProperty(DemoProperties.HOST_APP_LAUNCH_ARGS_MAC)).toString();
            } else if (HostUtils.isLinux()) {
                hostAppLaunchArgs = ((Collection)this.demo.getProperty(DemoProperties.HOST_APP_LAUNCH_ARGS_LINUX)).toString();
            }
            File exeFile = null;
            try {
                if (hostAppUri.startsWith("http")) {
                    throw new IllegalStateException("Host demo is using http and should not be!");
                }
                if (!hostAppUri.startsWith("asset")) {
                    return RunHostAppDemoHandler.this.createErrorStatus("Invalid hostAppUri property in demo " + this.demo.getLabel(), null);
                }
                exeFile = RunHostAppDemoHandler.this.getHostAppV4(hostAppUri, hostAppLaunchArgs, monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            exeFile.setExecutable(true);
            if (exeFile.exists() && HostUtils.isLinux() && !(status = RunHostAppDemoHandler.this.verifyLinuxDependencies(this.demo, exeFile)).isOK()) {
                return status;
            }
            IStatus flashAndRunAppStatus = RunHostAppDemoHandler.this.flashDeviceAndRunApp(exeFile, this.demo, this.device, false);
            if (!flashAndRunAppStatus.isOK()) {
                Activator.reporter.logError("Error running host app or flahsing demo. Cause: " + flashAndRunAppStatus.getMessage());
                return flashAndRunAppStatus;
            }
            return Status.OK_STATUS;
        }
    }
}

