/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.part.core;

import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.type.IType;
import com.silabs.ss.platform.api.descriptor.core.type.ITypeConverter;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import com.silabs.ss.support.mcu.internal.part.core.MemoryRegion;
import java.util.ArrayList;
import java.util.List;

public class MemoryRegionListTypeConverter
implements ITypeConverter {
    public static final String ID = "com.silabs.ss.support.mcu.part.core.memoryRegionList";

    public Object createFromString(IType type, String value, IDescriptor context) throws IllegalArgumentException {
        ArrayList<MemoryRegion> regions = new ArrayList<MemoryRegion>(0);
        if (value == null) {
            return regions;
        }
        try {
            String[] stringArray = value.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String region = stringArray[n2];
                regions.add(MemoryRegion.fromString(region));
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
        return regions;
    }

    public String convertToString(IType type, Object value, IDescriptor context) throws IllegalArgumentException {
        StringBuilder regionList = new StringBuilder();
        try {
            List regions = (List)value;
            for (MemoryRegion region : regions) {
                regionList.append(region.toString());
                regionList.append(";");
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
        return regionList.substring(0, regionList.length() - 1).toString();
    }
}

