/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.variables.engine.IStockVariableAdapter;
import com.silabs.ss.platform.api.content.part.core.BasePart;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.IPartGroup;
import com.silabs.ss.platform.api.content.part.core.PartCommonProperties;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IWriteablePropertyAccess;
import com.silabs.ss.support.mcu.api.part.core.IMCUPart;
import com.silabs.ss.support.mcu.api.part.core.IMemoryRegion;
import com.silabs.ss.support.mcu.api.part.core.MCUPartVariableAdapter;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import com.silabs.ss.support.mcu.internal.part.core.MemoryRegion;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MCUPart
extends BasePart
implements IMCUPart {
    private IStockVariableAdapter variableAdapter;

    public static String getArchitectureFamily(IDescriptor desc) {
        return (String)desc.getProperty(PartCommonProperties.ARCHITECTURE_FAMILY);
    }

    public MCUPart(IPartDescriptor partDesc, IPartGroup parentGroup, String providingBundleId) {
        super(partDesc, parentGroup, providingBundleId);
    }

    @Override
    public IMemoryRegion[] getMemoryRegions() {
        List<MemoryRegion> regions = this.doGetMemoryRegions();
        if (regions != null) {
            return regions.toArray(new MemoryRegion[regions.size()]);
        }
        return new MemoryRegion[0];
    }

    private List<MemoryRegion> doGetMemoryRegions() {
        ArrayList<MemoryRegion> regions = null;
        regions = new ArrayList<MemoryRegion>();
        class MemRegInfo {
            String addr;
            String size;
            String pageSize;
            String access;

            MemRegInfo() {
            }
        }
        HashMap<String, MemRegInfo> regInfos = new HashMap<String, MemRegInfo>(1);
        IWriteablePropertyAccess propAccess = this.getPropertyAccess();
        while (propAccess != null) {
            Map props = propAccess.getRawPropertyMap();
            for (String key : props.keySet()) {
                if (!key.startsWith("memory.") && !key.startsWith("hardware.part.memory.")) continue;
                String value = (String)props.get(key);
                String[] keyComponents = key.replace("hardware.part.", "").split("\\.");
                if (keyComponents.length < 3) {
                    Activator.reporter.logWarning(MessageFormat.format("Invalid memory property key [{0}] in descriptor file for {1}", key, ((IPartDescriptor)this.getDescriptor()).getName()));
                    continue;
                }
                String name = keyComponents[1];
                String attr = keyComponents[2];
                MemRegInfo info = (MemRegInfo)regInfos.get(name);
                if (info == null) {
                    info = new MemRegInfo();
                    regInfos.put(name, info);
                }
                switch (attr) {
                    case "addr": {
                        info.addr = value;
                        break;
                    }
                    case "size": {
                        info.size = value;
                        break;
                    }
                    case "pageSize": {
                        info.pageSize = value;
                        break;
                    }
                    case "access": {
                        info.access = value;
                        break;
                    }
                }
            }
            propAccess = propAccess.getParentAccess();
        }
        for (String key : regInfos.keySet()) {
            MemRegInfo m = (MemRegInfo)regInfos.get(key);
            try {
                regions.add(MemoryRegion.fromString(key, m.addr, m.size, m.pageSize, m.access));
            }
            catch (Exception exception) {
                Activator.reporter.logWarning(MessageFormat.format("Invalid memory region definition for [{0}]. Make sure ''addr'', ''size'' and ''access'' are defined.", key));
            }
        }
        return regions;
    }

    @Override
    public String getArchitectureFamily() {
        return MCUPart.getArchitectureFamily((IDescriptor)this);
    }

    protected String getDefaultPropertyScope() {
        return "part";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IStockVariableAdapter.class.equals(adapter)) {
            if (this.variableAdapter == null) {
                this.variableAdapter = new MCUPartVariableAdapter((IDescriptor)this);
            }
            return adapter.cast(this.variableAdapter);
        }
        return (T)super.getAdapter(adapter);
    }
}

