/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.platform.api.apack.core.model.FunctionType;
import com.silabs.ss.platform.api.device.core.DeviceUtils;
import com.silabs.ss.platform.api.device.core.IDevice;
import java.util.HashMap;
import java.util.Map;

public class CommanderArgs {
    public static final FunctionType DETECT_PART = FunctionType.make((String)"detectPart");
    private static final String ARG_SERIAL_NUMBER = "sn";
    private static final String ARG_ADDRESS = "addr";
    private static final String ARG_DEBUG_INTERFACE = "tif";
    private static final String ARG_DEVICE = "device";

    private CommanderArgs() {
        throw new IllegalStateException("Commander args utility class");
    }

    public static void addAddressToCommanderArgs(IDevice device, Map<String, Object> args) {
        String ipAddress = device.hardware().adapterIPAddress();
        if (ipAddress != null && (ipAddress.equals("localhost") || ipAddress.equals("127.0.0.1")) && device.hardware().adapterSerialNumber() != null) {
            args.put(ARG_SERIAL_NUMBER, device.hardware().adapterSerialNumber());
        } else if (DeviceUtils.isEthernetDevice((IDevice)device)) {
            args.put(ARG_ADDRESS, device.hardware().adapterIPAddress());
        } else if (DeviceUtils.isUsbDevice((IDevice)device)) {
            args.put(ARG_SERIAL_NUMBER, device.hardware().adapterSerialNumber());
        } else {
            throw new IllegalArgumentException("Can't use commander with device: " + device.toString());
        }
    }

    public static Map<String, Object> makeDetectPartArguments(IDevice device, String debugInterface, String deviceType) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        CommanderArgs.addAddressToCommanderArgs(device, args);
        if (TextUtils.hasContent((String)debugInterface)) {
            args.put(ARG_DEBUG_INTERFACE, debugInterface);
        }
        args.put(ARG_DEVICE, deviceType);
        return args;
    }
}

