/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.project.api.generator.template.ITemplateContribution;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.ILibrary;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.ResolvedInclude;
import com.silabs.ss.framework.uc.core.api.comp.ConfigFile;
import com.silabs.ss.framework.uc.core.api.comp.IConflict;
import com.silabs.ss.framework.uc.core.api.comp.IOverrideable;
import com.silabs.ss.framework.uc.core.api.comp.IRecommendation;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcTemplateFile;
import com.silabs.ss.framework.uc.core.api.comp.Overrider;
import com.silabs.ss.framework.uc.core.api.comp.ValidationScript;
import com.silabs.ss.framework.uc.core.api.meta.SourceFile;
import com.silabs.ss.framework.uc.core.api.model.uihint.UiHint;
import com.silabs.ss.framework.uc.core.api.model.uihint.UiHintId;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.rule.ApiRule;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliUtility;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ComponentRender {
    private static final String PAD_NO_LB = "                  ";
    private static final String PAD = System.lineSeparator() + "                  ";

    private ComponentRender() {
        throw new RuntimeException("ComponentReader is a static utility class and is not intended to be instantiated.");
    }

    public static void renderComponent(IUcComponent component, IUcFramework framework, PrintOptions opts, PrintStream writer) {
        ImmutableList conflicts;
        ImmutableList recommended;
        List<ApiRule> required;
        List<ApiRule> provided;
        Path sdkRoot = framework.directory().toPath();
        CliColour labelStyle = opts.useColour ? CliColour.YELLOW : null;
        writer.println(ComponentRender.renderLabel("--------- " + component.displayableId() + " ---------", "", labelStyle));
        writer.println(component.description());
        writer.println(ComponentRender.renderLabel("Source", component.metaSource().reportedLocation(), labelStyle));
        writer.println(ComponentRender.renderLabel("Displayed As", component.label(), labelStyle));
        writer.println(ComponentRender.renderLabel("Author", component.author(), labelStyle));
        writer.println(ComponentRender.renderLabel("Category", component.category(), labelStyle));
        writer.println(ComponentRender.renderLabel("Quality", component.qualityDescription(), labelStyle));
        writer.println(ComponentRender.renderLabel("Tag", component.tags().stream().collect(Collectors.joining(", ")), labelStyle));
        writer.println(ComponentRender.renderLabel("Package", component.packagedAs(), labelStyle));
        writer.println(ComponentRender.renderLabel("Instantiability", component.instantiability().toString(), labelStyle));
        ArrayList allDocs = Lists.newArrayList((Iterable)Iterables.concat((Iterable)component.documentation(), (Iterable)component.customDocumentation()));
        if (!allDocs.isEmpty()) {
            String docValue = component.documentation().stream().map(doc -> ComponentRender.renderConditional(doc, printOptions.useColour, Object::toString)).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Documentation", docValue, labelStyle));
        }
        if (!component.sourceFiles().isEmpty()) {
            String sourcesValue = ComponentRender.renderConditionalSources((Collection<IConditional<SourceFile>>)component.sourceFiles(), opts.useColour, opts.consoleWidth, false);
            writer.println(ComponentRender.renderLabel("Sources", sourcesValue, labelStyle));
        }
        if (!component.includePaths().isEmpty()) {
            String includesValue = component.includePaths().stream().map(inc -> ComponentRender.renderInclude((IConditional<ResolvedInclude>)inc, sdkRoot, printOptions.useColour, printOptions.consoleWidth)).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Includes", includesValue, labelStyle));
        }
        if (!component.otherFiles().isEmpty()) {
            String othersValue = ComponentRender.renderConditionalSources((Collection<IConditional<SourceFile>>)component.otherFiles(), opts.useColour, opts.consoleWidth, false);
            writer.println(ComponentRender.renderLabel("Others", othersValue, labelStyle));
        }
        if (!(provided = component.providedApis().collect(Collectors.toList())).isEmpty()) {
            String providedValue = ComponentRender.renderApiRules(true, provided, opts.useColour, opts.consoleWidth);
            writer.println(ComponentRender.renderLabel("Provides", providedValue, labelStyle));
        }
        if (!(required = component.requiredApis().collect(Collectors.toList())).isEmpty()) {
            String requiredValue = ComponentRender.renderApiRules(false, required, opts.useColour, opts.consoleWidth);
            writer.println(ComponentRender.renderLabel("Requires", requiredValue, labelStyle));
        }
        if (!(recommended = component.recommendations()).isEmpty()) {
            String recommendations = recommended.stream().map(rec -> ComponentRender.renderConditional(rec, printOptions.useColour, ComponentRender.renderRecommended((IRecommendation)rec.data()))).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Recommends", recommendations, labelStyle));
        }
        if (!component.templates().isEmpty()) {
            String templateFileValue = component.templates().stream().map(file -> ComponentRender.renderConditional(file, printOptions.useColour, ComponentRender.renderPath(((IUcTemplateFile)file.data()).templateFile()) + (((IUcTemplateFile)file.data()).isExported() ? " [ exported ] " : ""))).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Template Files", templateFileValue, labelStyle));
        }
        if (!component.libraries().isEmpty()) {
            String libValue = component.libraries().stream().map(lib -> ComponentRender.renderConditional(lib, printOptions.useColour, ((ILibrary)lib.data()).toString())).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Libraries", libValue, labelStyle));
        }
        if (!component.validationScripts().isEmpty()) {
            ComponentRender.renderValidationScripts((ImmutableList<IConditional<ValidationScript>>)component.validationScripts(), writer, true, opts.useColour, labelStyle);
        }
        if (!component.validationLibraries().isEmpty()) {
            ComponentRender.renderValidationScripts((ImmutableList<IConditional<ValidationScript>>)component.validationLibraries(), writer, false, opts.useColour, labelStyle);
        }
        if (!component.templateContributions().isEmpty()) {
            String contribs = component.templateContributions().stream().map(template -> ComponentRender.renderConditional(template, printOptions.useColour, ((ITemplateContribution)template.data()).toString())).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Template Contrib", contribs, labelStyle));
        }
        if (!component.configFiles().isEmpty()) {
            String configs = component.configFiles().stream().map(cond -> ComponentRender.renderConditional(cond, printOptions.useColour, ComponentRender::renderConfigFile)).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Config Files", configs, labelStyle));
        }
        if (!component.overriderConfigFiles().isEmpty()) {
            String overs = component.overriderConfigFiles().stream().map(cond -> ComponentRender.renderConditional(cond, printOptions.useColour, (T over) -> ComponentRender.renderOverrider(over, ComponentRender::renderSimpleConfigFile, printOptions.useColour))).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("O.riders (cfg)", overs, labelStyle));
        }
        if (!(conflicts = component.conflicts()).isEmpty()) {
            String conflictsStr = conflicts.stream().map(c -> ComponentRender.renderConditional(c, printOptions.useColour, ((IConflict)c.data()).apiId())).collect(Collectors.joining(PAD));
            writer.println(ComponentRender.renderLabel("Conflicts", conflictsStr, labelStyle));
        }
        component.metadata().ifPresent(meta -> writer.println(ComponentRender.renderLabel("Metadata", meta.toString(), labelStyle)));
        UiHint visHint = component.uiHint(UiHintId.DATA_VISIBILITY);
        visHint.data().ifPresent(vis -> {
            String string = ComponentRender.renderLabel("[ui] visibility", vis.toString(), labelStyle);
        });
    }

    private static void renderValidationScripts(ImmutableList<IConditional<ValidationScript>> scripts, PrintStream writer, boolean isScript, boolean colour, CliColour labelStyle) {
        String scriptValue = scripts.stream().map(script -> ComponentRender.renderConditional(script, colour, ((ValidationScript)script.data()).toString())).collect(Collectors.joining(PAD));
        writer.println(ComponentRender.renderLabel(isScript ? "V. Scripts" : "V. Libraries", scriptValue, labelStyle));
    }

    public static String renderConditionalSources(Collection<IConditional<SourceFile>> sources, boolean colour, int consoleWidth, boolean alwaysPad) {
        TreeMultimap catToFile = TreeMultimap.create(String::compareTo, (srcThis, srcThat) -> ((SourceFile)srcThis.data()).projectFileName().compareTo(((SourceFile)srcThat.data()).projectFileName()));
        for (IConditional<SourceFile> source : sources) {
            catToFile.put((Object)((SourceFile)source.data()).categoryPath(), source);
        }
        ArrayDeque<String> categories = new ArrayDeque<String>();
        int level = 0;
        StringBuilder rendered = new StringBuilder();
        boolean firstTime = true;
        for (String cat : catToFile.keySet()) {
            if (!categories.isEmpty()) {
                level = ComponentRender.adjustLevel(categories, cat, level);
            }
            if (firstTime) {
                firstTime = false;
            } else {
                rendered.append(PAD);
            }
            int padding = level * 4;
            rendered.append(Strings.repeat((String)" ", (int)(padding > 2 ? padding - 2 : padding))).append("- ");
            String cutCat = categories.isEmpty() ? cat : ComponentRender.cutCat((String)categories.peek(), cat);
            rendered.append(CliUtility.colourIfNeeded(cutCat, CliColour.GREEN, colour));
            padding = ++level * 4;
            int width = consoleWidth - PAD.length() - padding;
            rendered.append(PAD).append(Strings.repeat((String)" ", (int)(padding > 2 ? padding - 2 : padding))).append("- ");
            int remainingWidth = width;
            Iterator nextFileIter = catToFile.get((Object)cat).iterator();
            while (nextFileIter.hasNext()) {
                IConditional nextFile = (IConditional)nextFileIter.next();
                String conditionStatement = nextFile.isUnconditional() ? "" : " if " + nextFile.conditionExpression();
                String refinedConditionStatement = CliUtility.colourIfNeeded(conditionStatement, CliColour.MAGENTA, colour);
                String toRender = ((SourceFile)nextFile.data()).projectFileName() + refinedConditionStatement + (nextFileIter.hasNext() ? ", " : "");
                int widthGobbled = ((SourceFile)nextFile.data()).projectFileName().length() + conditionStatement.length() + 2;
                if ((remainingWidth -= widthGobbled) < 0) {
                    remainingWidth = width;
                    rendered.append(PAD).append(Strings.repeat((String)" ", (int)padding));
                }
                rendered.append(toRender);
            }
            categories.push(cat);
        }
        return rendered.toString();
    }

    private static int adjustLevel(Deque<String> categories, String category, int level) {
        int curLevel = level;
        while (!categories.isEmpty()) {
            String pastCat = categories.peek();
            if (category.startsWith(pastCat)) {
                return curLevel;
            }
            categories.pop();
            --curLevel;
        }
        return 0;
    }

    private static String cutCat(String lastCat, String cat) {
        if (cat.startsWith(lastCat)) {
            return cat.substring(lastCat.length(), cat.length());
        }
        return cat;
    }

    public static <T> String renderConditional(IConditional<T> object, boolean colour, Function<T, String> renderer) {
        StringBuilder value = new StringBuilder();
        value.append(renderer.apply(object.data()));
        return ComponentRender.renderConditional(object, colour, value.toString());
    }

    public static String renderConditional(IConditional<?> object, boolean colour, String rendered) {
        if (!object.isUnconditional()) {
            String ifRender = CliUtility.colourIfNeeded(" if " + object.conditionExpression(), CliColour.MAGENTA, colour);
            return rendered + ifRender;
        }
        return rendered;
    }

    public static String renderRecommended(IRecommendation rec) {
        return rec.recommendedId() + rec.from().map(f -> " from " + f).orElse("") + (rec.recommendedInstances().isEmpty() ? "" : rec.recommendedInstances().stream().collect(Collectors.joining(", ", " [ ", " ]")));
    }

    public static <T> String renderOverrider(Overrider<T> over, Function<T, String> overRender, boolean useColour) {
        return CliUtility.colourIfNeeded(over.componentId(), CliColour.GREEN, useColour) + over.from().map(ext -> " from " + ext).orElse("") + " with " + CliUtility.colourIfNeeded(over.overrideId(), CliColour.YELLOW, useColour) + over.instance().map(inst -> " only for instance " + CliUtility.colourIfNeeded(inst, CliColour.YELLOW, useColour)).orElse("") + " is overriden with { " + overRender.apply(over.data()) + " } ";
    }

    public static String renderConfigFile(IOverrideable<ConfigFile> overConfigFile) {
        ConfigFile configFile = (ConfigFile)overConfigFile.data();
        Object config = ComponentRender.renderSimpleConfigFile(configFile);
        if (!overConfigFile.overrideId().equals("")) {
            config = (String)config + " [Overrideable id: " + overConfigFile.overrideId() + "]";
        }
        return config;
    }

    public static String renderSimpleConfigFile(ConfigFile configFile) {
        Object config = ComponentRender.renderPath(configFile.sourceFile());
        if (!"".equals(configFile.directory())) {
            config = (String)config + " (generated in " + configFile.directory() + ")";
        }
        return config;
    }

    public static String renderApiRules(boolean provided, List<ApiRule> rules, boolean colour, int consoleWidth) {
        ArrayList<String> unconditionals = new ArrayList<String>();
        ArrayList<String> conditionals = new ArrayList<String>();
        for (ApiRule rule : rules) {
            IConditional<ApiId> api = ComponentRender.ruleToCond(rule, provided);
            String allowMultiple = rule.providedMultiple() ? " [shared]" : "";
            String result = ComponentRender.renderConditional(api, colour, ((ApiId)api.data()).id()) + allowMultiple;
            if (api.isUnconditional()) {
                unconditionals.add(result);
                continue;
            }
            conditionals.add(result);
        }
        Collections.sort(unconditionals);
        Collections.sort(conditionals);
        return ComponentRender.splitPrettyPrint(unconditionals, conditionals, consoleWidth);
    }

    private static IConditional<ApiId> ruleToCond(ApiRule rule, boolean provided) {
        return provided ? rule.getProvided() : rule.getRequired();
    }

    public static String renderSourceFile(SourceFile source) {
        StringBuilder render = new StringBuilder();
        render.append(source.category().stream().collect(Collectors.joining("/")));
        render.append("/").append(source.projectFileName()).append(" ");
        source.physicalFile().ifPresent(phys -> {
            StringBuilder stringBuilder2 = render.append("[ ").append(ComponentRender.renderPath(phys)).append(" ]");
        });
        return render.toString();
    }

    public static String renderInclude(IConditional<ResolvedInclude> include, Path sdkRoot, boolean colour, int consoleWidth) {
        StringBuilder render = new StringBuilder();
        Path dir = ((ResolvedInclude)include.data()).includeDirectory();
        Path correctedDir = sdkRoot.relativize(dir);
        String correctedDirString = correctedDir.toString().replace("\\", "/");
        render.append("Include Path: ").append(ComponentRender.renderConditional(include, colour, CliUtility.colourIfNeeded(correctedDirString, CliColour.GREEN, colour))).append(PAD);
        ArrayList<String> unconditionals = new ArrayList<String>();
        ArrayList<String> conditionals = new ArrayList<String>();
        for (IConditional source : StreamUtils.iterableOf((Stream)((ResolvedInclude)include.data()).headerFiles())) {
            String renderedCond = ComponentRender.renderConditional(source, colour, (T s) -> ComponentRender.cutCat(correctedDirString, s.projectPath()).substring(1));
            if (source.isUnconditional()) {
                unconditionals.add(renderedCond);
                continue;
            }
            conditionals.add(renderedCond);
        }
        Collections.sort(unconditionals);
        Collections.sort(conditionals);
        return render.append(ComponentRender.splitPrettyPrint(unconditionals, conditionals, consoleWidth)).toString();
    }

    private static String splitPrettyPrint(List<String> unconditionals, List<String> conditionals, int consoleWidth) {
        int modConsoleWidth = consoleWidth - PAD_NO_LB.length();
        ByteArrayOutputStream uncondInternalWriter = new ByteArrayOutputStream();
        PrintStream uncondWriter = new PrintStream(uncondInternalWriter);
        CliUtility.printStringsNicely(unconditionals, uncondWriter, s -> s, modConsoleWidth, PAD_NO_LB);
        ByteArrayOutputStream condInternalWriter = new ByteArrayOutputStream();
        PrintStream condWriter = new PrintStream(condInternalWriter);
        CliUtility.printStringsNicely(conditionals, condWriter, s -> s, modConsoleWidth, PAD_NO_LB);
        return uncondInternalWriter.toString() + (String)(conditionals.isEmpty() ? "" : PAD_NO_LB + condInternalWriter.toString());
    }

    public static String renderPath(Path p) {
        return p.toAbsolutePath().normalize().toString();
    }

    public static String renderLabel(String label, String content, CliColour labelStyle) {
        String justifiedLabel = String.format("%-16s: ", label);
        if (labelStyle != null) {
            return CliUtility.colourIfNeeded(justifiedLabel, labelStyle, true) + content;
        }
        return justifiedLabel + content;
    }

    public static final class PrintOptions {
        private boolean useColour = true;
        private int consoleWidth = 80;

        public PrintOptions consoleWidth(int width) {
            this.consoleWidth = width;
            return this;
        }

        public PrintOptions useColour(boolean use) {
            this.useColour = use;
            return this;
        }
    }
}

