/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.google.common.collect.Streams;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TemporaryFile;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.ss.framework.project.api.core.type.IProjectTypeInfo;
import com.silabs.ss.framework.project.api.core.utils.ProjectUtils;
import com.silabs.ss.framework.uc.api.project.UcProjectUtils;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.ComponentQuality;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.context.IUcContext;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.meta.IMetaParseEngine;
import com.silabs.ss.framework.uc.core.api.meta.ParseIssue;
import com.silabs.ss.framework.uc.core.api.meta.SourceFile;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.project.state.IUcProjectState;
import com.silabs.ss.framework.uc.core.api.project.state.UcHardware;
import com.silabs.ss.framework.uc.core.api.projectfilter.IProjectFilters;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.ss.framework.uc.core.api.validate.UcApiValidator;
import com.silabs.ss.framework.uc.core.api.validate.ValidationContext;
import com.silabs.ss.framework.uc.core.internal.context.UcContext;
import com.silabs.ss.platform.api.content.board.core.Board;
import com.silabs.ss.platform.api.content.board.core.IBoardDescriptor;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.compatibility.ICompatibilityQuery;
import com.silabs.ss.platform.api.descriptor.core.hardware.IHardwareContext;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.uc.cli.internal.model.IUcExampleResult;
import com.silabs.uc.cli.internal.model.UcExampleDefinition;
import com.silabs.uc.cli.internal.model.UcExampleResults;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UcExampleProjectResult
implements IUcExampleResult {
    public static final String ERROR_STR = "Project loading failures";
    private static final String DEVICE_FAMILY_PROVIDES = "device_family_";
    private static final String SIMPLICITY_IDE_ID = "simplicity-ide";
    private final UcExampleResults parent;
    private final File slcpFile;
    private final IUcProject project;
    private final IMetaParseEngine engine;
    private final String pkgBoardCompat;
    private final String pkgPartCompat;
    private final Collection<String> pkgRequiredProvides;
    private final Collection<String> pkgRestrictProvides;
    private final boolean ignoreRevisions;
    private final ExecutorService threadEngine;
    private Collection<IUcComponent> computedBoardComps;
    private String partCompat;
    private String boardCompat;
    private String toolchainCompat;
    private String ideCompat;
    private String projectFilters;
    private final Map<Set<String>, UcApiUtils.SelectedWithApis> selectedWithApisMap = new ConcurrentHashMap<Set<String>, UcApiUtils.SelectedWithApis>();
    private final Map<Set<String>, Boolean> boardCompatibleMap = new ConcurrentHashMap<Set<String>, Boolean>();

    public static UcExampleProjectResult create(UcExampleResults parent, File slcpFile, ExecutorService threadPool) {
        Pair result = UcProjectUtils.loadUnconnectedProject((IUcFramework)parent.framework(), (File)slcpFile);
        return new UcExampleProjectResult(parent, slcpFile, (IUcProject)result.first, (IMetaParseEngine)result.second, threadPool);
    }

    public UcExampleProjectResult(UcExampleResults parent, File slcpFile, IUcProject proj, IMetaParseEngine engine, ExecutorService threadEngine) {
        this.parent = parent;
        this.slcpFile = slcpFile;
        this.project = proj;
        this.engine = engine;
        this.threadEngine = threadEngine;
        UcExampleDefinition exampleDef = parent.exampleDefinition();
        this.pkgBoardCompat = exampleDef == null ? "" : exampleDef.boardCompat(this.packaged());
        this.pkgPartCompat = exampleDef == null ? "" : exampleDef.partCompat(this.packaged());
        this.pkgRequiredProvides = exampleDef == null ? Collections.emptySet() : exampleDef.requiredProvides(this.packaged());
        this.pkgRestrictProvides = exampleDef == null ? Collections.emptySet() : exampleDef.restrictProvides(this.packaged());
        this.ignoreRevisions = exampleDef == null ? false : exampleDef.ignoreRevisions(this.packaged());
    }

    public File slcpFile() {
        return this.slcpFile;
    }

    public IUcProject project() {
        return this.project;
    }

    @Override
    public String name() {
        return this.project().id();
    }

    @Override
    public String title() {
        return "Project";
    }

    @Override
    public boolean isValid() {
        return this.project() != null;
    }

    @Override
    public File file() {
        return this.slcpFile();
    }

    @Override
    public List<ParseIssue> warnings() {
        if (!this.engine.hasWarnings()) {
            return List.of();
        }
        return this.engine.warnings().collect(Collectors.toList());
    }

    @Override
    public List<ParseIssue> errors() {
        if (!this.engine.hasError()) {
            return List.of();
        }
        return this.engine.errors().collect(Collectors.toList());
    }

    @Override
    public String packaged() {
        return this.project == null ? ERROR_STR : this.project.packagedAs();
    }

    @Override
    public ComponentQuality quality() {
        return this.project == null ? ComponentQuality.UNKNOWN : this.project.quality();
    }

    @Override
    public String description() {
        return this.project == null ? "" : this.project.description();
    }

    @Override
    public String category() {
        return this.project == null ? "" : this.project.category();
    }

    @Override
    public List<SourceFile> readmeFiles() {
        return this.project == null ? List.of() : this.project.readmeFiles();
    }

    @Override
    public String projectFilters() {
        if (this.projectFilters == null) {
            IProjectFilters filters = this.project().projectFilters();
            this.projectFilters = CoreTypes.STRING_LIST.stringize((Object)filters.getAllProjectFilterPaths());
        }
        return this.projectFilters;
    }

    @Override
    public MDescriptor createTemplate(Path templFile) {
        MDescriptor mdesc = this.parent.createTemplate(templFile, this);
        mdesc.setName(this.project().id());
        mdesc.setLabel(this.project().label());
        return mdesc;
    }

    @Override
    public String partCompat() {
        if (!this.parent.calculateCompatibility()) {
            return this.pkgPartCompat;
        }
        if (this.partCompat == null) {
            this.partCompat = this.getComputedBoardComps().stream().map(this::getPartFamily).filter(Objects::nonNull).distinct().map(i -> ".*" + i + ".*").sorted().collect(Collectors.joining(" "));
        }
        return this.partCompat;
    }

    @Override
    public String boardCompat() {
        if (!this.parent.calculateCompatibility()) {
            return this.pkgBoardCompat;
        }
        if (this.boardCompat == null) {
            this.boardCompat = this.getComputedBoardComps().stream().filter(c -> !c.tags().contains((Object)"hardware:fake_hardware")).map(this.ignoreRevisions ? arg_0 -> ((UcHardware.BoardMapper)UcHardware.board()).unrevisionedBoardId(arg_0) : arg_0 -> ((UcHardware.BoardMapper)UcHardware.board()).toHardwareId(arg_0)).sorted().collect(Collectors.joining(" "));
        }
        return this.boardCompat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String ideCompatibility() {
        if (this.ideCompat != null) return this.ideCompat;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                UcContext context = UcContext.disconnected((IUcSdkContent)this.parent.sdk());
                try {
                    try (TemporaryFile genDir = TemporaryFile.directory((String)"examples_gen");){
                        IUcProjectState projState = context.projectState();
                        IUcProjectState.IHardwareSetter hardware = projState.hardware();
                        if (this.parent.calculateCompatibility() && !this.getComputedBoardComps().isEmpty()) {
                            String boardCompId = this.getComputedBoardComps().stream().filter(c -> !c.tags().contains((Object)"hardware:fake_hardware")).findFirst().orElseGet(() -> this.getComputedBoardComps().iterator().next()).id();
                            Optional boardComp = this.project.ucFramework().findComponent(boardCompId);
                            boardComp.map(arg_0 -> ((UcHardware.BoardMapper)UcHardware.board()).resolveHardwareId(arg_0)).ifPresent(string -> {
                                IUcProjectState.IHardwareSetter iHardwareSetter2 = hardware.setBoardIds(new String[]{string});
                            });
                            boardComp.map(this::getPartComponent).map(arg_0 -> ((UcHardware.PartMapper)UcHardware.part()).resolveHardwareId(arg_0)).ifPresent(arg_0 -> ((IUcProjectState.IHardwareSetter)hardware).setPartId(arg_0));
                        }
                        hardware.setToolchainCompat((Collection)TextUtils.splitByCharacterToList((String)this.toolchainCompat(), (char)' ')).apply();
                        projState.setGenerationDirectory(genDir.path());
                        Collection compatList = projState.compatibleProjectTypes().stream().map(p -> (IProjectTypeInfo)p.getAdapter(IProjectTypeInfo.class)).filter(Objects::nonNull).map(IProjectTypeInfo::ideCompatibilityId).collect(Collectors.toCollection(TreeSet::new));
                        if (this.isStudioIdeCompatible((IUcContext)context, projState)) {
                            compatList.add(SIMPLICITY_IDE_ID);
                            if (compatList.contains(ProjectUtils.getMakefileIdeCompatibilityId())) {
                                compatList.add(ProjectUtils.getGenericTemplateCompatibilityId());
                            }
                        }
                        this.ideCompat = TextUtils.catenateStrings((Collection)compatList, (String)" ");
                    }
                    if (context == null) return this.ideCompat;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (context == null) throw throwable;
                    context.close();
                    throw throwable;
                }
                context.close();
                return this.ideCompat;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Throwable)e);
        }
        return this.ideCompat;
    }

    private boolean isStudioIdeCompatible(IUcContext context, IUcProjectState state) {
        return !"HOST".equals(state.getAllowedCoreArchitecture());
    }

    @Override
    public String toolchainCompat() {
        if (this.toolchainCompat == null) {
            Stream<Object> tcComps = UcHardware.toolchain().findAllComponents((IUcComponentContainer)this.project.ucFramework()).stream();
            if (this.parent.calculateCompatibility() && !this.getComputedBoardComps().isEmpty()) {
                String boardComp = this.getComputedBoardComps().iterator().next().id();
                tcComps = tcComps.filter(t -> this.isCompatible(Set.of(t, boardComp)));
            }
            this.toolchainCompat = tcComps.map(arg_0 -> ((IUcFramework)this.project.ucFramework()).findComponent(arg_0)).filter(Optional::isPresent).map(Optional::get).map(arg_0 -> ((UcHardware.ToolchainMapper)UcHardware.toolchain()).toHardwareId(arg_0)).sorted().collect(Collectors.joining(" "));
        }
        return this.toolchainCompat;
    }

    private Collection<IUcComponent> getComputedBoardComps() {
        if (this.computedBoardComps != null) {
            return this.computedBoardComps;
        }
        this.computedBoardComps = this.threadOperations(this.getComputedPkgBoardComps(), this::isCompatible).collect(Collectors.toSet());
        return this.computedBoardComps;
    }

    private Set<IUcComponent> getComputedPkgBoardComps() {
        return this.parent.pkgBoardComps().computeIfAbsent(this.packaged(), this::loadPkgBoardComp);
    }

    private Set<IUcComponent> loadPkgBoardComp(String pkg) {
        ICompatibilityQuery boardQuery = Compatibility.fromGrammarString((IRegistry)Board.manager(), (String)this.pkgBoardCompat);
        ICompatibilityQuery partQuery = Compatibility.fromGrammarString((IRegistry)Part.manager(), (String)this.pkgPartCompat);
        List boardComps = UcHardware.board().findAllComponents((IUcComponentContainer)this.project.ucFramework());
        return this.threadOperations(boardComps, b -> this.filterPkgCompatibleBoard((String)b, (ICompatibilityQuery<IBoardDescriptor>)boardQuery, (ICompatibilityQuery<IPartDescriptor>)partQuery)).collect(Collectors.toCollection(() -> new TreeSet(this::comparePkgBoardComps)));
    }

    private <E, T> Stream<T> threadOperations(Collection<E> entries, Function<E, T> func) {
        List operations = entries.stream().map(e -> this.threadEngine.submit(() -> func.apply(e))).collect(Collectors.toList());
        return operations.stream().map(t -> {
            try {
                return t.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.error((Throwable)e);
                Thread.currentThread().interrupt();
                return null;
            }
        }).filter(Objects::nonNull);
    }

    private IUcComponent filterPkgCompatibleBoard(String boardId, ICompatibilityQuery<IBoardDescriptor> boardQuery, ICompatibilityQuery<IPartDescriptor> partQuery) {
        IUcComponent board = this.project.ucFramework().findComponent(boardId).orElse(null);
        if (board == null) {
            return null;
        }
        boolean preFilter = this.pkgRequiredProvides.isEmpty() && this.pkgRestrictProvides.isEmpty() ? this.filterByStudioHardware(boardQuery, partQuery, board) : this.filterByProvides(board);
        if (!preFilter) {
            return null;
        }
        if (TextUtils.hasContent((String)this.getPartFamily(board))) {
            return board;
        }
        return null;
    }

    private int comparePkgBoardComps(IUcComponent c1, IUcComponent c2) {
        if (!this.ignoreRevisions) {
            return c1.id().compareTo(c2.id());
        }
        return UcHardware.board().unrevisionedBoardId(c1).compareTo(UcHardware.board().unrevisionedBoardId(c2));
    }

    private boolean filterByStudioHardware(ICompatibilityQuery<IBoardDescriptor> boardQuery, ICompatibilityQuery<IPartDescriptor> partQuery, IUcComponent comp) {
        IHardwareContext hwcontext = UcHardware.findHardware((IUcComponent[])new IUcComponent[]{comp}).hwcontext;
        if (hwcontext.isEmpty()) {
            return true;
        }
        IBoardDescriptor[] boards = (IBoardDescriptor[])hwcontext.getHardware(IBoardDescriptor.class);
        if (boards.length == 0) {
            return true;
        }
        return this.isDescriptorCompatible(boards, boardQuery, partQuery);
    }

    private boolean isDescriptorCompatible(IBoardDescriptor[] boards, ICompatibilityQuery<IBoardDescriptor> boardQuery, ICompatibilityQuery<IPartDescriptor> partQuery) {
        return Stream.of(boards).filter(arg_0 -> boardQuery.isCompatibleWith(arg_0)).map(IBoardDescriptor::getAllowedPartIds).flatMap(stringArray -> Stream.of(stringArray)).anyMatch(arg_0 -> partQuery.isCompatibleWith(arg_0));
    }

    private boolean filterByProvides(IUcComponent comp) {
        Set realApis = this.loadSelectedWithApis(comp.id()).totalApis().keySet().stream().map(ApiId::id).collect(Collectors.toSet());
        if (!this.pkgRequiredProvides.isEmpty()) {
            if (this.pkgRequiredProvides.stream().noneMatch(realApis::contains)) {
                return false;
            }
        }
        if (!this.pkgRestrictProvides.isEmpty()) {
            if (this.pkgRestrictProvides.stream().anyMatch(realApis::contains)) {
                return false;
            }
        }
        return true;
    }

    private IUcComponent getPartComponent(IUcComponent board) {
        UcApiUtils.SelectedWithApis result = this.loadSelectedWithApis(board.id());
        Collection parts = UcHardware.part().filterToComponents((Collection)result.trulySelected());
        return parts.isEmpty() ? null : (IUcComponent)parts.iterator().next();
    }

    private String getPartFamily(IUcComponent comp) {
        UcApiUtils.SelectedWithApis result = this.loadSelectedWithApis(comp.id());
        String partFamily = result.totalApis().keys().stream().map(ApiId::id).filter(id -> id.startsWith(DEVICE_FAMILY_PROVIDES)).map(id -> id.substring(DEVICE_FAMILY_PROVIDES.length())).distinct().reduce((o1, o2) -> o1.length() > o2.length() ? o1 : o2).orElse(null);
        return partFamily;
    }

    private IUcComponent isCompatible(IUcComponent boardComponent) {
        if (this.isCompatible(Set.of(boardComponent.id()))) {
            return boardComponent;
        }
        return null;
    }

    private boolean isCompatible(Set<String> components) {
        boolean isValid = this.boardCompatibleMap.computeIfAbsent(components, c -> {
            UcApiUtils.SelectedWithApis result = this.loadSelectedWithApis((Set<String>)c);
            return !UcApiValidator.validate((ValidationContext)ValidationContext.fromSelected((List)result.everythingSelected())).findAny().isPresent();
        });
        return isValid;
    }

    private UcApiUtils.SelectedWithApis loadSelectedWithApis(String boardComponent) {
        return this.loadSelectedWithApis(Set.of(boardComponent));
    }

    private UcApiUtils.SelectedWithApis loadSelectedWithApis(Set<String> components) {
        return this.selectedWithApisMap.computeIfAbsent(components, c -> {
            Stream componentStream = Streams.concat((Stream[])new Stream[]{this.project.selectedComponents(), c.stream().map(IConditional::unconditional)}).distinct();
            UcApiUtils.SelectedWithApis result = UcApiUtils.calculateAllRequiredComponents((IUcProject)this.project, componentStream, (IUcFramework)this.project.ucFramework());
            return result;
        });
    }
}

