/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.model;

import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliUtility;
import java.io.PrintStream;

public final class CliSessionData {
    private final PrintStream out;
    private final PrintStream err;
    private final String uuid;
    private final boolean colour;
    private final int consoleWidth;

    public CliSessionData(PrintStream out, PrintStream err, String uuid, boolean colour, int consoleWidth) {
        this.out = out;
        this.err = err;
        this.colour = colour;
        this.consoleWidth = consoleWidth;
        this.uuid = uuid;
    }

    public PrintStream out() {
        return this.out;
    }

    public PrintStream err() {
        return this.err;
    }

    public String uuid() {
        return this.uuid;
    }

    public boolean isColour() {
        return this.colour;
    }

    public int consoleWidth() {
        return this.consoleWidth;
    }

    public String colourIfNeeded(String toColour, CliColour colour) {
        return CliUtility.colourIfNeeded(toColour, colour, this.isColour());
    }

    public String colourBasedFeedback(String ifColour, String ifNotColour) {
        if (this.isColour()) {
            return ifColour;
        }
        return ifNotColour;
    }
}

