/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.shared;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.StreamUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.java.utils.thread.SilabsThreadFactory;
import com.silabs.uc.cli.internal.daemon.shared.DaemonSearchResult;
import com.silabs.uc.cli.internal.daemon.shared.DaemonVersionInfo;
import com.silabs.uc.cli.internal.daemon.shared.DataDirectoryStatus;
import com.silabs.uc.cli.internal.daemon.shared.IInfoTracer;
import com.silabs.uc.cli.internal.daemon.shared.ISlcDaemon;
import com.silabs.uc.cli.internal.daemon.shared.LockFileAcquisitionException;
import com.silabs.uc.cli.internal.daemon.shared.RunningFileRead;
import com.silabs.uc.cli.internal.daemon.shared.RunningFileWaitTimeExceededException;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public final class DaemonUtils {
    public static final String RUNNING_FILE_NAME = ".running";
    public static final String VERSION_FILE_NAME = ".version";
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String PROP_PORT_NUMBER = "port_number";
    public static final String PROP_PROCESS_ID = "process_id";
    private static final long ALLOWED_LOCK_AGE_MS = 100L;
    private static final ExecutorService lockWatcherPool = Executors.newFixedThreadPool(1, SilabsThreadFactory.withName((String)"daemon-lock-watcher").setDaemon(true).create());
    private static final ExecutorService runningWatcherPool = Executors.newFixedThreadPool(1, SilabsThreadFactory.withName((String)"daemon-running-file-watcher").setDaemon(true).create());
    private static final int TOTAL_LOCK_ACQ_ATTEMPTS = 100;
    private static final int TOTAL_WAIT_FOR_AWAITING_FILE_FILLED_IN_S = 30;
    private static IDaemonProcessFunctions daemonProcessFunctions = DaemonProcessFunctions.INSTANCE;

    private static Stream<Path> dataDirIterate(Path parent, ISlcDaemon creator) throws IOException {
        return Files.list(parent).filter(p -> p.getFileName().toString().startsWith(creator.daemonName()) && Files.isDirectory(p, new LinkOption[0])).sorted((p1, p2) -> p1.getFileName().toString().compareTo(p2.getFileName().toString()));
    }

    public static DaemonSearchResult searchForMatchingOrAwaiting(ISlcDaemon creator, DaemonVersionInfo ourVersion, IInfoTracer logger) throws IOException {
        logger.daemonLog(() -> "Searching for matching/awaiting files for " + creator.daemonName() + (ourVersion != null ? " using version matching" : " ignoring versions"));
        Path parent = creator.location();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            logger.daemonLog(() -> "Creator location " + String.valueOf(creator.location()) + " not even a directory.");
            return DaemonSearchResult.Nothing.INSTANCE;
        }
        ArrayList<DataDirectoryStatus> awaitingData = new ArrayList<DataDirectoryStatus>();
        DataDirectoryStatus existingDaemon = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream<Path> dirs = DaemonUtils.dataDirIterate(parent, creator);){
            for (Path dataDirectory : StreamUtils.iterableOf(dirs)) {
                Optional<DataDirectoryStatus> status = DaemonUtils.checkDataDirectory(dataDirectory, ourVersion, true, logger);
                if (!status.isPresent()) continue;
                DataDirectoryStatus stat = status.get();
                if (stat.runningFileStatus().isAwaiting()) {
                    logger.daemonLog(() -> "Found awaiting file: " + String.valueOf(stat.runningFile()));
                    awaitingData.add(stat);
                } else {
                    if (!stat.sharedData().isPresent()) continue;
                    SlcDaemonSharedData shared = stat.sharedData().get();
                    logger.daemonLog(() -> "Found a complete .running file: " + String.valueOf(stat.runningFile()) + "[ pid: " + shared.processId() + " ]");
                    existingDaemon = stat;
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (existingDaemon != null) {
            assert (existingDaemon.sharedData().isPresent()) : "Detected an existing daemon but did not properly check shared data availability.";
            return new DaemonSearchResult.AcceptableDaemon(existingDaemon.sharedData().get());
        }
        if (!awaitingData.isEmpty()) {
            return new DaemonSearchResult.AwaitingFiles(Collections.unmodifiableList(awaitingData));
        }
        logger.daemonLog(() -> "No running daemons, no awaiting files. Nothing of any substance found");
        return DaemonSearchResult.Nothing.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path ensureCreatedNewAwaitingDataDirectory(ISlcDaemon creator, IInfoTracer logger) throws IOException {
        block20: {
            block19: {
                try {
                    if (!Files.exists(creator.location(), new LinkOption[0])) {
                        Files.createDirectories(creator.location(), new FileAttribute[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.exists(creator.location(), new LinkOption[0])) break block19;
                    throw new IOException("Creation of directory failed, but subsequent check shows it does not exist: " + e.getMessage(), e);
                }
            }
            Throwable e = null;
            Object var3_5 = null;
            try {
                DataDirLock lock;
                block21: {
                    Stream<Path> dirs = DaemonUtils.dataDirIterate(creator.location(), creator);
                    Iterator iterator = StreamUtils.iterableOf(dirs).iterator();
                    finally {
                        if (!iterator.hasNext()) break block20;
                    }
                    Path dataDirectory = (Path)iterator.next();
                    Path runningFileExpected = dataDirectory.resolve(RUNNING_FILE_NAME);
                    Throwable throwable = null;
                    Object var9_13 = null;
                    try {
                        Path path;
                        lock = DaemonUtils.acquireLock(dataDirectory.resolve(LOCK_FILE_NAME), logger);
                        try {
                            if (Files.exists(runningFileExpected, new LinkOption[0])) break block21;
                            DaemonUtils.cleanDataFolder(dataDirectory, logger);
                            Files.createFile(runningFileExpected, new FileAttribute[0]);
                            logger.daemonLog(() -> "Reusing an old data directory: " + String.valueOf(dataDirectory));
                            path = dataDirectory;
                            if (lock == null) return path;
                        }
                        catch (Throwable throwable2) {
                            if (lock == null) throw throwable2;
                            lock.close();
                            throw throwable2;
                        }
                        lock.close();
                        return path;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                    throw e;
                }
                if (e == throwable) throw e;
                e.addSuppressed(throwable);
                throw e;
            }
        }
        Path newDataFolder = creator.newFolder();
        try {
            Files.createDirectory(newDataFolder, new FileAttribute[0]);
            Path runningFile = newDataFolder.resolve(RUNNING_FILE_NAME);
            Files.createFile(runningFile, new FileAttribute[0]);
            logger.daemonLog(() -> "Created a new data directory at " + String.valueOf(newDataFolder));
            return newDataFolder;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            logger.daemonLog(() -> "Another process beat us to creating " + String.valueOf(newDataFolder));
        }
        return newDataFolder;
    }

    public static Optional<DataDirectoryStatus> checkDataDirectory(Path dataDir, DaemonVersionInfo ourInfo, boolean checkVersions, IInfoTracer logger) throws IOException {
        if (Files.isRegularFile(dataDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Expecting data directory but got a file: " + String.valueOf(dataDir));
        }
        logger.daemonLog(() -> "Checking data directory status of " + String.valueOf(dataDir));
        Path runningFile = dataDir.resolve(RUNNING_FILE_NAME);
        if (!Files.exists(runningFile, new LinkOption[0])) {
            logger.daemonLog(() -> "No .running file at " + String.valueOf(runningFile));
            return Optional.empty();
        }
        RunningFileRead possibleFile = DaemonUtils.readRunningFile(runningFile);
        if (possibleFile instanceof RunningFileRead.EmptyStates) {
            RunningFileRead.EmptyStates emptyState = (RunningFileRead.EmptyStates)possibleFile;
            if (emptyState == RunningFileRead.EmptyStates.CORRUPTED_RUNNING_FILE) {
                logger.daemonLog(() -> "Invalid .running file, so cleanup operation is occurring in " + String.valueOf(dataDir));
                Files.delete(runningFile);
                Files.deleteIfExists(dataDir.resolve(VERSION_FILE_NAME));
                return Optional.empty();
            }
            logger.daemonLog(() -> "Awaiting or otherwise unknown .running file at " + String.valueOf(dataDir));
            return Optional.of(new DataDirectoryStatus(null, possibleFile, dataDir));
        }
        assert (possibleFile instanceof RunningFileRead.ProperFile) : "Controlled interface RunningFileRead had an unaccounted for type added -- " + possibleFile.getClass().getName();
        SlcDaemonSharedData loadedShared = ((RunningFileRead.ProperFile)possibleFile).sharedData();
        Path versionFile = loadedShared.versionFile();
        if (!Files.exists(versionFile, new LinkOption[0])) {
            logger.daemonLog(() -> "valid .running file with no .version at " + String.valueOf(loadedShared.dataFolder()));
            Files.delete(runningFile);
            return Optional.empty();
        }
        if (ourInfo == null || !checkVersions) {
            logger.daemonLog(() -> "Data directory found at " + String.valueOf(loadedShared.dataFolder()));
            return Optional.of(new DataDirectoryStatus(loadedShared, possibleFile, dataDir));
        }
        DaemonVersionInfo.VersionComparison sameVersion = ourInfo.strictVersionCompare(versionFile);
        switch (sameVersion) {
            case BROKEN: {
                logger.daemonLog(() -> "Broken .version file, performing cleanup operation in " + String.valueOf(loadedShared.dataFolder()));
                Files.delete(versionFile);
                Files.delete(runningFile);
                return Optional.empty();
            }
            case DIFFERENT: {
                DaemonUtils.cleanupIfNeeded(runningFile, versionFile, loadedShared, logger);
                return Optional.empty();
            }
            case SAME: {
                boolean hadToClean = DaemonUtils.cleanupIfNeeded(runningFile, versionFile, loadedShared, logger);
                if (hadToClean) {
                    return Optional.empty();
                }
                return Optional.of(new DataDirectoryStatus(loadedShared, possibleFile, dataDir));
            }
        }
        throw new RuntimeException("Missing case statement: " + String.valueOf((Object)sameVersion));
    }

    public static boolean isSharedDataOurs(SlcDaemonSharedData shared) {
        return shared.processId() == daemonProcessFunctions.currentProcessId();
    }

    public static boolean cleanupIfNeeded(Path file, Path versionFile, SlcDaemonSharedData shared, IInfoTracer logger) throws IOException {
        if (!daemonProcessFunctions.isProcessActive(shared.processId())) {
            logger.daemonLog(() -> "Data directory at " + String.valueOf(shared.dataFolder()) + " represents a non-running process, so it will be cleaned.");
            Files.delete(file);
            Files.delete(versionFile);
            return true;
        }
        return false;
    }

    public static boolean cleanupIfNeeded(SlcDaemonSharedData shared, IInfoTracer logger) throws IOException {
        return DaemonUtils.cleanupIfNeeded(shared.runningFile(), shared.versionFile(), shared, logger);
    }

    public static void cleanDataFolder(Path dataFolder, IInfoTracer logger) throws IOException {
        Path possibleRunning;
        logger.daemonLog(() -> "Running a cleanup on data folder " + String.valueOf(dataFolder));
        Path possibleVersion = dataFolder.resolve(VERSION_FILE_NAME);
        if (Files.deleteIfExists(possibleVersion)) {
            logger.daemonLog(() -> "Removed version file: " + String.valueOf(possibleVersion));
        }
        if (Files.deleteIfExists(possibleRunning = dataFolder.resolve(RUNNING_FILE_NAME))) {
            logger.daemonLog(() -> "Removed running file: " + String.valueOf(possibleRunning));
        }
    }

    public static RunningFileRead readRunningFile(Path sharedFile) {
        int readPort;
        long readPid;
        if (!Files.isRegularFile(sharedFile, new LinkOption[0])) {
            return RunningFileRead.EmptyStates.NO_RUNNING_FILE;
        }
        try {
            Properties readProps = FileUtils.readProperties((File)sharedFile.toFile());
            if (readProps.isEmpty()) {
                return RunningFileRead.EmptyStates.AWAITING_RUNNING_FILE;
            }
            if (!readProps.containsKey(PROP_PROCESS_ID) || !readProps.containsKey(PROP_PORT_NUMBER)) {
                return RunningFileRead.EmptyStates.CORRUPTED_RUNNING_FILE;
            }
            readPid = Long.parseLong(readProps.getProperty(PROP_PROCESS_ID));
            readPort = Integer.parseInt(readProps.getProperty(PROP_PORT_NUMBER));
        }
        catch (IOException | NumberFormatException e) {
            Log.info((String)("Issue interpreting shared file " + String.valueOf(sharedFile) + " due to " + e.getMessage()), (Throwable)e);
            return RunningFileRead.EmptyStates.CORRUPTED_RUNNING_FILE;
        }
        return new RunningFileRead.ProperFile(new SlcDaemonSharedData(readPort, readPid, sharedFile.getParent(), false));
    }

    public static Optional<SlcDaemonSharedData> fillInRunning(DaemonVersionInfo versioning, Path dataDirectory, ISlcDaemon creator, int portNumber, IInfoTracer logger) throws IOException {
        if (!Files.exists(dataDirectory, new LinkOption[0])) {
            logger.daemonLog(() -> "Cannot fill in .running file when data directory does not exist.");
            return Optional.empty();
        }
        if (Files.isRegularFile(dataDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Passed data folder points to a file: " + String.valueOf(dataDirectory));
        }
        Properties props = new Properties();
        long pid = daemonProcessFunctions.currentProcessId();
        props.setProperty(PROP_PROCESS_ID, String.valueOf(pid));
        props.setProperty(PROP_PORT_NUMBER, String.valueOf(portNumber));
        Path lockFile = dataDirectory.resolve(LOCK_FILE_NAME);
        Path runningFile = dataDirectory.resolve(RUNNING_FILE_NAME);
        Throwable throwable = null;
        Object var11_11 = null;
        try (DataDirLock lock = DaemonUtils.acquireLock(lockFile, logger);){
            logger.daemonLog(() -> "Acquired lock for writing out full .running file process id and port data: " + String.valueOf(runningFile) + " pid " + pid + "port" + portNumber);
            if (!Files.isRegularFile(runningFile, new LinkOption[0])) {
                logger.daemonLog(() -> "Nothing to do -- the .running file did NOT exist. " + String.valueOf(runningFile));
                return Optional.empty();
            }
            Throwable throwable2 = null;
            Object var14_16 = null;
            try (OutputStream sharedStream = Files.newOutputStream(runningFile, new OpenOption[0]);){
                props.store(sharedStream, "Autogenerated: do not manually edit, move, or remove! Basically don't touch.");
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            String versionFileContents = versioning.versionContent();
            Path versionFile = dataDirectory.resolve(VERSION_FILE_NAME);
            if (Files.exists(versionFile, new LinkOption[0])) {
                Files.delete(versionFile);
            }
            FileUtils.writeFileContents((File)versionFile.toFile(), (String)versionFileContents);
            logger.daemonLog(() -> ".running file written out with pid and port info successfully: " + String.valueOf(runningFile));
            return Optional.of(new SlcDaemonSharedData(portNumber, pid, dataDirectory, true));
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static Optional<SlcDaemonSharedData> waitForRunning(List<Path> awaitingFiles, DaemonVersionInfo ourVersion, IInfoTracer logger) throws RunningFileWaitTimeExceededException, IOException {
        return DaemonUtils.waitForRunningInternal(awaitingFiles, ourVersion, 30, logger);
    }

    public static Optional<SlcDaemonSharedData> waitForRunning(List<Path> awaitingFiles, DaemonVersionInfo ourVersion, int timeoutInSeconds, IInfoTracer logger) throws RunningFileWaitTimeExceededException, IOException {
        return DaemonUtils.waitForRunningInternal(awaitingFiles, ourVersion, timeoutInSeconds < 0 ? 30 : timeoutInSeconds, logger);
    }

    /*
     * Exception decompiling
     */
    public static DataDirLock acquireLockInternal(Path lockFile, int totalAttempts, int waitTimePerLockInSeconds, IInfoTracer logger, Runnable testInject) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void cleanUpLockLock(Path lockFile, boolean created) throws IOException {
        try {
            if (created) {
                Files.delete(lockFile);
                return;
            }
            boolean isOlder = Files.getLastModifiedTime(lockFile, new LinkOption[0]).toInstant().isBefore(Instant.now().plusMillis(100L));
            if (isOlder) {
                Files.delete(lockFile);
            }
        }
        catch (NoSuchFileException noSuchFileException) {}
    }

    private static void repairDeadLock(Path lockFile, int waitTimePerLockInSeconds, IInfoTracer logger) throws LockFileAcquisitionException {
        block14: {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = Files.newBufferedReader(lockFile, StandardCharsets.UTF_8);){
                    String processIdMaybe = reader.readLine();
                    try {
                        long processId = Long.parseLong(processIdMaybe);
                        if (daemonProcessFunctions.isProcessActive(processId)) {
                            throw new LockFileAcquisitionException(".lock file may be stale -- no deletion attempt detected after " + waitTimePerLockInSeconds + " seconds, and it is still owned by a currently running process.");
                        }
                        logger.daemonLog(() -> "Repairing stale .lock at " + String.valueOf(lockFile) + " held by dead process " + processId);
                        Files.delete(lockFile);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.daemonLog(() -> ".lock at " + String.valueOf(lockFile) + " + doesn't even make sense. First line was not a number: " + processIdMaybe);
                        Files.delete(lockFile);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (!Files.exists(lockFile, new LinkOption[0])) break block14;
                throw new LockFileAcquisitionException("Could not read .lock file at " + String.valueOf(lockFile) + " to determine deadness state due to " + e.getMessage(), e);
            }
        }
    }

    public static Optional<SlcDaemonSharedData> waitForRunningInternal(List<Path> awaitingFiles, DaemonVersionInfo ourVersion, int timeoutInSeconds, IInfoTracer logger) throws RunningFileWaitTimeExceededException, IOException {
        for (Path running : awaitingFiles) {
            logger.daemonLog(() -> "Waiting for " + String.valueOf(running) + " to fill with contents.");
            Path home = running.getParent();
            Path lockFile = home.resolve(LOCK_FILE_NAME);
            long lastModifiedTsMs = -1L;
            Throwable throwable = null;
            Object var11_12 = null;
            try (DataDirLock lock = DaemonUtils.acquireLock(lockFile, logger);){
                RunningFileRead result = DaemonUtils.readRunningFile(running);
                if (DaemonUtils.checkDaemonVersion(ourVersion, result.connectedDaemon())) {
                    logger.daemonLog(() -> ".running file must have already been filled in: " + String.valueOf(running));
                    return result.connectedDaemon();
                }
                if (result.isAwaiting()) {
                    lastModifiedTsMs = Files.getLastModifiedTime(running, new LinkOption[0]).toMillis();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (lastModifiedTsMs == -1L) continue;
            long lastModifiedConst = lastModifiedTsMs;
            Future<?> futureResult = runningWatcherPool.submit(() -> DaemonUtils.waitForRunningFileModification(running, lastModifiedConst, logger));
            try {
                futureResult.get(timeoutInSeconds, TimeUnit.SECONDS);
                logger.daemonLog(() -> ".running file at " + String.valueOf(running) + " detected modified! Checking for viability.");
                RunningFileRead secondResult = null;
                Throwable throwable3 = null;
                Object var15_19 = null;
                try (DataDirLock secondLock = DaemonUtils.acquireLock(lockFile, logger);){
                    secondResult = DaemonUtils.readRunningFile(running);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                if (!DaemonUtils.checkDaemonVersion(ourVersion, secondResult.connectedDaemon())) continue;
                logger.daemonLog(() -> ".running file at " + String.valueOf(running) + " is viable!");
                return secondResult.connectedDaemon();
            }
            catch (TimeoutException timeoutException) {
                logger.daemonLog(() -> "A .running file in awaiting state took more than " + timeoutInSeconds + " whilst waiting for a proper Daemon process to fill it with content.");
                DaemonUtils.cleanDataFolder(home, logger);
            }
            catch (ExecutionException ex) {
                throw new RunningFileWaitTimeExceededException("A .running file in awaiting state could not be waited for due to an issue with thread execution: " + ex.getMessage(), ex);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        logger.daemonLog(() -> "No viable .running files found whilst waiting on all of " + String.valueOf(awaitingFiles));
        return Optional.empty();
    }

    public static DataDirLock acquireLock(Path lockFile, IInfoTracer logger) throws IOException {
        return DaemonUtils.acquireLockInternal(lockFile, 100, 30, logger, null);
    }

    private static boolean checkDaemonVersion(DaemonVersionInfo ourVersion, Optional<SlcDaemonSharedData> shared) {
        if (shared.isPresent()) {
            SlcDaemonSharedData data = shared.get();
            if (ourVersion == null || ourVersion.strictVersionCompare(data.versionFile()) == DaemonVersionInfo.VersionComparison.SAME) {
                return true;
            }
        }
        return false;
    }

    private static void waitForRunningFileModification(Path running, long lastModifiedTsMs, IInfoTracer logger) {
        int waitTime = 500;
        try {
            long currentModifiedTsMs = lastModifiedTsMs;
            while (currentModifiedTsMs == lastModifiedTsMs) {
                currentModifiedTsMs = Files.getLastModifiedTime(running, new LinkOption[0]).toMillis();
                Thread.sleep(waitTime);
                waitTime = 50;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex.getMessage(), ex);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.daemonLog(() -> "Thread interrupted whilst trying to wait for the .running file at " + String.valueOf(running) + " to be modified.");
        }
    }

    public static IDaemonProcessFunctions mockOutProcessFunctions(IDaemonProcessFunctions newFunctions) {
        if (!RuntimeUtils.isJUnitRunning()) {
            throw new RuntimeException("Mocking out static functions is only allowed in JUnit tests. This should not be called in production code!");
        }
        IDaemonProcessFunctions old = daemonProcessFunctions;
        daemonProcessFunctions = newFunctions;
        return old;
    }

    public static void mockRestoreProcessFunctions() {
        if (!RuntimeUtils.isJUnitRunning()) {
            throw new RuntimeException("Mocking out static functions is only allowed in JUnit tests. This should not be called in production code!");
        }
        daemonProcessFunctions = DaemonProcessFunctions.INSTANCE;
    }

    private static /* synthetic */ String lambda$25(Path path) {
        return ".lock exists: " + String.valueOf(path) + ". We will now wait...";
    }

    private static /* synthetic */ String lambda$26(Path path) {
        return ".lock timeout -- checking if it is referring to a dead process: " + String.valueOf(path);
    }

    private static /* synthetic */ String lambda$27(Path path) {
        return "Unexpected thread interruption whilst waiting for lock file: " + String.valueOf(path);
    }

    private static /* synthetic */ String lambda$28(Path path) {
        return "Lock created: " + String.valueOf(path);
    }

    private static /* synthetic */ String lambda$29(Path path, FileSystemException fileSystemException) {
        return "Process contention with creating a new lock, so we will try again: " + String.valueOf(path) + ". We ran into " + fileSystemException.getClass().getCanonicalName() + " with message " + fileSystemException.getMessage();
    }

    private static /* synthetic */ String lambda$30(Path path, int n) {
        return "Lock not acquired: " + String.valueOf(path) + ". Will try again. There are " + n + " attempts remaining.";
    }

    private static enum DaemonProcessFunctions implements IDaemonProcessFunctions
    {
        INSTANCE{

            @Override
            public long currentProcessId() {
                return ProcessHandle.current().pid();
            }

            @Override
            public boolean isProcessActive(long pid) {
                return !ProcessHandle.of(pid).isEmpty();
            }
        };

    }

    public static final class DataDirLock
    implements AutoCloseable {
        private final Path lockFile;

        private DataDirLock(Path lockFile) {
            this.lockFile = lockFile;
        }

        @Override
        public void close() throws IOException {
            Files.delete(this.lockFile);
        }
    }

    public static interface IDaemonProcessFunctions {
        public long currentProcessId();

        public boolean isProcessActive(long var1);
    }

    private static final class WaitForLockFileDeletion
    implements Callable<Boolean> {
        private final Path lockFile;
        volatile boolean stop = false;

        public WaitForLockFileDeletion(Path lockFile) {
            this.lockFile = lockFile;
        }

        @Override
        public Boolean call() throws Exception {
            while (!this.stop && Files.exists(this.lockFile, new LinkOption[0])) {
                Thread.onSpinWait();
            }
            return !this.stop;
        }
    }
}

