/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.util;

import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcAdditionalFramework;
import com.silabs.ss.framework.uc.core.api.IUcFramework;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.UcSdkReference;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.uc.cli.internal.command.mixin.CliExtensionMixin;
import com.silabs.uc.cli.internal.command.util.FoundComponent;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.Optional;

public final class UcCliUtils {
    public static Optional<FoundComponent> findComponent(String componentName, CliExtensionMixin mixin, IUcSdk sdk, IUcProject project, ICliOutput feedback) {
        Optional<IUcAdditionalFramework> ifExtension = mixin.findExtension(feedback, sdk.framework());
        return ifExtension.flatMap(ext -> UcCliUtils.findByExtension(componentName, ext, sdk, feedback)).or(() -> UcCliUtils.findBySdk(componentName, sdk, project));
    }

    public static Optional<UcSdkReference> translateExtensionId(String extId, ICliOutput feedback) {
        return (Optional)UcSdkReference.fromCombinedString((String)extId).map(Optional::of, err -> {
            feedback.err().println((String)err);
            return Optional.empty();
        });
    }

    private static Optional<FoundComponent> findBySdk(String componentName, IUcSdk sdk, IUcProject project) {
        IUcFramework framework = project != null ? project.ucFramework() : sdk.framework();
        return framework.findComponent(componentName).map(comp -> new FoundComponent((IUcComponent)comp, null));
    }

    private static Optional<FoundComponent> findByExtension(String componentName, IUcAdditionalFramework sdkExtension, IUcSdk sdk, ICliOutput feedback) {
        return sdkExtension.findByUnmangledId(componentName).map(comp -> new FoundComponent((IUcComponent)comp, sdkExtension.extensionId()));
    }
}

