/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command.metaexport;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.platform.api.rcp.core.analytics.route.BuiltInAnalyticsRoutes;
import com.silabs.uc.cli.internal.command.metaexport.UcCliMetadataExport;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import picocli.CommandLine;

@CommandLine.Command(name="performance", description={"Exports performance data to a given location as a single file."})
public class UcCliMEPerformance
implements Callable<Integer> {
    private static final String NO_PERF_DATA = "No performance data available -- nothing exported.";
    @CommandLine.ParentCommand
    private UcCliMetadataExport root;
    @CommandLine.Option(names={"-o", "--output"}, paramLabel="OUTPUT_FILE", description={"Output file to put all analytics into. This will be in the same form as the analytics packets, but will collapse  what may be many files into a single analytic file that can be sent to developers."})
    private String outputPath;
    @CommandLine.Option(names={"-x", "--clear"}, description={"Clears out the performance data after the export is done. In other words, attempting to export again will not produce any output, as the data was internally removed. Data will only be cleared if the export was successful. Be careful with the exported file if you use this option, as the data cannot be exported again! Be aware that SLC already has a max file limit for performance data and will adhere to that already."})
    private Boolean clear;

    @Override
    public Integer call() throws Exception {
        ICliOutput feedback = this.root.session();
        if (this.clear == null && this.outputPath == null) {
            feedback.out().println("Specify at least one of the option to export, clear, or both. Nothing was done.");
            return 1;
        }
        if (this.outputPath != null) {
            Path localStorage = BuiltInAnalyticsRoutes.performance().outgoing();
            if (Files.exists(localStorage, new LinkOption[0])) {
                this.handleMerge(localStorage, feedback);
            } else {
                feedback.out().println(NO_PERF_DATA);
            }
        }
        if (Boolean.TRUE.equals(this.clear)) {
            FileUtils.deleteDirectoryContents((File)BuiltInAnalyticsRoutes.performance().outgoing().toFile());
        }
        return 0;
    }

    private void handleMerge(Path localStorage, ICliOutput feedback) throws IOException {
        block23: {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<Path> fileListing = Files.list(localStorage);){
                    JSONObject merged = fileListing.sorted((p1, p2) -> p1.getFileName().compareTo(p2.getFileName())).map(p -> this.readOrNull((Path)p, feedback)).filter(Objects::nonNull).reduce(new JSONObject(), this::mergeJson);
                    if (merged.has("events")) {
                        Path finalOutput = feedback.resolve(this.outputPath);
                        if (!Files.exists(finalOutput.getParent(), new LinkOption[0])) {
                            Files.createDirectories(finalOutput.getParent(), new FileAttribute[0]);
                        }
                        if (!Files.exists(finalOutput, new LinkOption[0])) {
                            Files.createFile(finalOutput, new FileAttribute[0]);
                        }
                        Throwable throwable2 = null;
                        Object var10_13 = null;
                        try (BufferedWriter writer = Files.newBufferedWriter(finalOutput, StandardCharsets.UTF_8, new OpenOption[0]);){
                            writer.write(merged.toString(4));
                            break block23;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    feedback.out().println(NO_PERF_DATA);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (JSONException e) {
                feedback.unifiedLogger().userError("Could not complete operation: malformed analytics JSON: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public JSONObject mergeJson(JSONObject accumulator, JSONObject next) {
        if (!accumulator.has("studio")) {
            accumulator.put("studio", (Object)next.getJSONObject("studio"));
            accumulator.put("version", next.getInt("version"));
            accumulator.put("events", (Object)new JSONArray());
        }
        JSONArray events = accumulator.getJSONArray("events");
        JSONArray nextEvents = next.getJSONArray("events");
        int i = 0;
        while (i < nextEvents.length()) {
            JSONObject nextEvent = nextEvents.getJSONObject(i);
            events.put((Object)nextEvent);
            ++i;
        }
        return accumulator;
    }

    public JSONObject readOrNull(Path p, ICliOutput feedback) {
        try {
            String contents = FileUtils.readFileContents((Path)p, (Charset)StandardCharsets.UTF_8);
            return new JSONObject(contents);
        }
        catch (JSONException e) {
            feedback.unifiedLogger().userError("Internal anlaytics error: Performance data captured was NOT in json format for file " + String.valueOf(p) + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            feedback.unifiedLogger().userError("Could not read " + String.valueOf(p) + " to process performance logs due to: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }
}

