/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.StreamUtils;
import com.silabs.ss.framework.uc.api.python.validator.ConfigValidationIssue;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IUcSharedMetadata;
import com.silabs.ss.framework.uc.core.api.comp.ApiPartaker;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentConfiguration;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentContainer;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.log.IUnifiedLogger;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.ss.framework.uc.core.api.project.gen.GenerationFilenameConstants;
import com.silabs.ss.framework.uc.core.api.projectfilter.IProjectFilters;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.rule.ApiRule;
import com.silabs.ss.framework.uc.core.api.validate.ApiValidationIssue;
import com.silabs.ss.framework.uc.core.api.validate.ExclusivityIssue;
import com.silabs.ss.framework.uc.core.api.validate.IApiTypedIssues;
import com.silabs.ss.framework.uc.core.api.validate.RecommendsIssue;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.ss.framework.uc.core.api.validate.UcApiValidator;
import com.silabs.ss.framework.uc.core.api.validate.UcRecommendsValidator;
import com.silabs.ss.framework.uc.core.api.validate.ValidationIssue;
import com.silabs.ss.framework.uc.internal.api.project.setup.UcConfigurationValidator;
import com.silabs.ss.framework.uc.internal.api.python.validator.PyQuickFix;
import com.silabs.ss.platform.api.content.core.asset.AcceptedStudioFilters;
import com.silabs.ss.platform.api.content.core.asset.StudioFiltersUtilities;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.ProjectRequiredException;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliExternalTools;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.mixin.CliWithinWithout;
import com.silabs.uc.cli.internal.command.model.ProjectContainer;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.RecommendedStatus;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliUtility;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="validate-project", description={"validates (without generation) a project. This will include both issues that can be patched up automatically as well as show a tree of issues that must be handled manually"})
public final class UcCliValidateProject
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProjectImplicit projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"-cfg-loc", "--config-location"}, description={"Provides an optional configuration folder of already generated config files to use for configuration validation. If this is specified, the config values appearing in any file in this folder take precedence over default computed values."})
    private String configLocation;
    @CommandLine.Option(names={"--sdk-configs"}, description={"Disable the automatic configuration folder lookup if --config-location is not defined. If that is explicitly defined, then this command has no effect."})
    private boolean useSdkConfigs;
    private static final String PRETTY_SEPARATOR = ".-----~*~------.";

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        SltSdkFeatures sltFeatures = SltSdkFeatures.fromMixin(this.sdkBase, feedback);
        return UcCliValidateProject.runValidateProjectCommon(sdk, this.projectBase, sltFeatures, this.useSdkConfigs, this.configLocation, false, feedback);
    }

    public static int runValidateProjectExternal(IUcSdk sdk, String projectFile, CliWithinWithout withinWithout, CliExternalTools extTools, SltSdkFeatures sltFeatures, String baseDestination, ICliOutput feedback) {
        CliProjectImplicit projectBase = CliProjectImplicit.createDirectly(projectFile, withinWithout, extTools);
        return UcCliValidateProject.runValidateProjectCommon(sdk, projectBase, sltFeatures, false, baseDestination, true, feedback);
    }

    private static int runValidateProjectCommon(IUcSdk sdk, CliProjectImplicit projBase, SltSdkFeatures sltFeatures, boolean useSdkCfgs, String cfgLocation, boolean mustApplyConfigFolder, ICliOutput feedback) {
        return projBase.loadProjectContainer((IUcSdkContent)sdk, feedback, sltFeatures, true, true, true).map(p -> UcCliValidateProject.doRunValidateProject(p, useSdkCfgs, cfgLocation, mustApplyConfigFolder, feedback)).orElseThrow(ProjectRequiredException::new);
    }

    private static int doRunValidateProject(ProjectContainer projectContainer, boolean useSdkCfgs, String cfgLocation, boolean mustApplyConfigFolder, ICliOutput feedback) {
        Path resolvedConfigFolder;
        IUcProjectMutable project = projectContainer.project();
        if (!Strings.isNullOrEmpty((String)cfgLocation)) {
            resolvedConfigFolder = feedback.resolve(cfgLocation);
            if (mustApplyConfigFolder) {
                resolvedConfigFolder = resolvedConfigFolder.resolve(GenerationFilenameConstants.config());
            }
        } else {
            Path projConfigDir;
            resolvedConfigFolder = useSdkCfgs ? null : (Files.isDirectory(projConfigDir = project.context().projectState().configDirectory(), new LinkOption[0]) ? projConfigDir : null);
        }
        String msg = resolvedConfigFolder == null ? "SDK sources" : resolvedConfigFolder.toString();
        feedback.out().println("Using project config files from " + msg);
        boolean isOk = UcCliValidateProject.solveAndReport((IUcProject)project, (ICliOutput)feedback).validationIssues.isEmpty();
        isOk &= UcCliValidateProject.reportPythonIssues((IUcProject)project, feedback, resolvedConfigFolder).isEmpty();
        isOk &= UcCliValidateProject.reportRecommendsIssues((IUcProject)project, feedback.out()).isEmpty();
        isOk &= UcCliValidateProject.reportFiltersIssues(project, feedback);
        if (projectContainer.hasIssues()) {
            isOk = false;
            feedback.out().println("Project considered invalid due to previous parsing issues.");
        }
        return isOk ? IApplication.EXIT_OK : 1;
    }

    private static boolean reportFiltersIssues(IUcProjectMutable project, ICliOutput feedback) {
        IProjectFilters currentProjectFilters = project.projectFilters();
        ImmutableList currentFilterPaths = currentProjectFilters.getAllProjectFilterPaths();
        ArrayList<String> notAccepted = new ArrayList<String>();
        for (String filterPath : currentFilterPaths) {
            List pathList = StudioFiltersUtilities.splitFilterPath((String)filterPath);
            if (AcceptedStudioFilters.instance().isAcceptableStudioHeadingAndFilter((String)pathList.get(0), (String)pathList.get(1))) continue;
            notAccepted.add(filterPath);
        }
        CliSessionData session = feedback.session();
        if (!notAccepted.isEmpty()) {
            feedback.out().println(session.colourIfNeeded("Project filter paths are not part of Accepted Studio Filters", CliColour.RED));
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("DISCLAIMER: Any filter paths that are longer than " + currentProjectFilters.getMaxPathLength() + " are automatically truncated.");
            feedback.out().println("DISCLAIMER: Any filter paths that are shorter than 2 are automatically removed and invalid.");
            feedback.out().println("The following are not part of the Accepted Studio Filters:");
            CliUtility.printStringsNicely(notAccepted, feedback.out(), comp -> session.colourIfNeeded((String)comp, CliColour.GREEN), session.consoleWidth(), "");
        }
        return notAccepted.isEmpty();
    }

    public static ImmutableList<RecommendsIssue> reportRecommendsIssues(IUcProject project, PrintStream print) {
        UcApiUtils.SelectedWithApis selection = UcApiUtils.calculateSelected((IUcProject)project);
        List issues = UcRecommendsValidator.checkRecommends((List)selection.trulySelected(), selection.totalApis().keySet().stream().map(ApiId::id).collect(Collectors.toSet()));
        if (!(issues = issues.stream().filter(issue -> project.selectionMetaFor(issue.who().id()).isAutoSelected()).collect(Collectors.toList())).isEmpty()) {
            print.println(PRETTY_SEPARATOR);
            print.println("Recommendation issues:\n- there are some autoselected instantiable components whose instance names cannot be automatically determined. They must be selected manaually and given instance name(s) in the project file.");
        }
        for (RecommendsIssue issue2 : issues) {
            print.println(issue2.message());
        }
        return ImmutableList.copyOf(issues);
    }

    public static SolveAndReportResult solveAndReport(IUcProject project, ICliOutput feedback) {
        UcApiUtils.SelectedWithApis selections = UcApiUtils.calculateSelected((IUcProject)project);
        CliSessionData session = feedback.session();
        Set selectedByUser = selections.trulySelected().stream().map(IUcSharedMetadata::id).filter(id -> project.selectionMetaFor(id).who().isUserSelected()).map(ApiPartaker::calculateDisplayableId).collect(Collectors.toSet());
        Set selectedAutomatically = selections.trulySelected().stream().map(IUcSharedMetadata::id).filter(id -> project.selectionMetaFor(id).who().isAutoSelected()).map(ApiPartaker::calculateDisplayableId).collect(Collectors.toSet());
        List unfixableIssues = UcApiValidator.validate((IUcComponentContainer)project.ucFramework(), (IUcComponentConfiguration)project).collect(Collectors.toList());
        Collection recStatus = RecommendedStatus.fromConfigurationParts((List<IUcComponent>)selections.trulySelected(), (Set<String>)UcApiUtils.makeRaw((Set)selections.totalApis().keySet()), project.ucFramework(), unfixableIssues.stream().map(issue -> issue.failedId().id()).distinct().collect(Collectors.toSet())).stream().filter(r -> !r.isEmpty()).collect(Collectors.toList());
        List<String> alreadySelectedIds = selectedByUser.stream().sorted().collect(Collectors.toList());
        if (unfixableIssues.isEmpty()) {
            feedback.out().println("Valid Project Dependencies");
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("Already selected: ");
            CliUtility.printStringsNicely(alreadySelectedIds, feedback.out(), comp -> session.colourIfNeeded((String)comp, CliColour.GREEN), session.consoleWidth(), "");
            feedback.out().println();
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("Dependencies brought in: ");
            CliUtility.printStringsNicely(selectedAutomatically.stream().sorted().collect(Collectors.toList()), feedback.out(), comp -> session.colourIfNeeded((String)comp, CliColour.GREEN), session.consoleWidth(), "");
        } else {
            feedback.out().println(session.colourIfNeeded("Project dependencies are invalid.", CliColour.RED));
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("Already selected: ");
            CliUtility.printStringsNicely(alreadySelectedIds, feedback.out(), comp -> session.colourIfNeeded((String)comp, CliColour.GREEN), session.consoleWidth(), "");
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("Dependencies brought in: ");
            CliUtility.printStringsNicely(selectedAutomatically.stream().sorted().collect(Collectors.toList()), feedback.out(), comp -> session.colourIfNeeded((String)comp, CliColour.GREEN), session.consoleWidth(), "");
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("Unsolvable Issues: ");
            CliUtility.printIssuesNicely(unfixableIssues, feedback.out(), session);
            UcCliValidateProject.reportRecommended(recStatus, unfixableIssues, feedback);
        }
        return new SolveAndReportResult(selections, (ImmutableList<RecommendedStatus>)ImmutableList.copyOf((Collection)recStatus), (ImmutableList<ApiValidationIssue>)ImmutableList.copyOf(unfixableIssues));
    }

    public static ImmutableList<ConfigValidationIssue> reportPythonIssues(IUcProject project, ICliOutput feedback, Path existingConfigs) {
        List issues = UcConfigurationValidator.validate((IUcProject)project, (Path)existingConfigs, (IUnifiedLogger)feedback.unifiedLogger()).collect(Collectors.toList());
        CliSessionData session = feedback.session();
        if (!issues.isEmpty()) {
            feedback.out().println(PRETTY_SEPARATOR);
            feedback.out().println("Configuration Issues:");
            for (ConfigValidationIssue issue : issues) {
                CliColour colour = CliUtility.colourForSeverity(issue.severity());
                StringBuilder issueRow = new StringBuilder();
                issueRow.append(session.colourIfNeeded(issue.severity().toString(), colour));
                issueRow.append(" -- ").append(issue.where().message()).append(": ").append(issue.problem());
                if (issue.quickfix().isPresent()) {
                    PyQuickFix qf = (PyQuickFix)issue.quickfix().get();
                    issueRow.append(" [Suggestions: ").append(qf.suggestedValues().stream().map(sug -> session.colourIfNeeded((String)sug, CliColour.YELLOW)).collect(Collectors.joining(", ")));
                    Multimap otherSuggestions = qf.otherVariablesMulti();
                    if (!otherSuggestions.isEmpty()) {
                        issueRow.append(", ");
                        issueRow.append(otherSuggestions.keySet().stream().map(define -> session.colourIfNeeded((String)define, CliColour.MAGENTA) + " = " + otherSuggestions.get(define).stream().map(sug -> session.colourIfNeeded((String)sug, CliColour.YELLOW)).collect(Collectors.joining("/"))).collect(Collectors.joining(", ")));
                    }
                    issueRow.append("]");
                }
                if (!Strings.isNullOrEmpty((String)issue.description())) {
                    issueRow.append(System.lineSeparator()).append(" -> ").append(issue.description());
                }
                feedback.out().println(issueRow.toString());
            }
        }
        return ImmutableList.copyOf(issues);
    }

    public static void reportRecommended(Collection<RecommendedStatus> recStatus, Collection<? extends ValidationIssue> issues, ICliOutput feedback) {
        CliSessionData session = feedback.session();
        if (!recStatus.isEmpty()) {
            IApiTypedIssues group = IApiTypedIssues.group(issues);
            if (!group.unfulfilledIssues().isEmpty()) {
                feedback.out().println("Some unresolved apis can be solved via recommended components, but there may be some ambiguity issues that prevented these recommended components from being autoselected.");
            }
            for (RecommendedStatus rec : recStatus) {
                for (IUcComponent recommendedComp : rec.recommended()) {
                    feedback.out().println(UcCliValidateProject.writeXRecommendsY(session, rec, recommendedComp));
                }
            }
            if (!group.exclusivityIssues().isEmpty()) {
                feedback.out().println("Some recommended components have exclusivity issues -- you will likely have to manually select a non-recommended solution or change other aspects of your project state.");
            }
            HashMultimap exApiToProvider = HashMultimap.create();
            for (ExclusivityIssue exIssue : group.exclusivityIssues()) {
                exApiToProvider.put((Object)exIssue.failedId().id(), (Object)exIssue.partaker());
            }
            for (RecommendedStatus rec : recStatus) {
                for (IUcComponent recommendedComp : rec.recommended()) {
                    for (ApiRule rule : StreamUtils.iterableOf((Stream)recommendedComp.providedApis())) {
                        String apiId = rule.getApi().id();
                        if (!exApiToProvider.containsKey((Object)apiId) || rec.api().equals(apiId)) continue;
                        feedback.out().println(UcCliValidateProject.writeXRecommendsY(session, rec, recommendedComp) + ", but that component also provides '" + apiId + "' which conflicts with the same api provided by component(s) " + UcCliValidateProject.isolateOtherProvider((Multimap<String, ApiPartaker>)exApiToProvider, apiId, recommendedComp).map(ApiPartaker::displayableId).collect(Collectors.joining(", ")) + (String)(!rule.getProvided().conditions().isEmpty() ? " [ only under conditions " + session.colourIfNeeded(rule.getProvided().conditionExpression(), CliColour.MAGENTA) + "]" : ""));
                    }
                }
            }
        }
    }

    private static Stream<ApiPartaker> isolateOtherProvider(Multimap<String, ApiPartaker> exApiToProvider, String apiId, IUcComponent recommendedComponent) {
        Collection providersOfApi = exApiToProvider.get((Object)apiId);
        return providersOfApi.stream().filter(provider -> !provider.id().equals(recommendedComponent.id()));
    }

    private static String writeXRecommendsY(CliSessionData session, RecommendedStatus rec, IUcComponent recommendedComp) {
        return session.colourIfNeeded(rec.api(), CliColour.MAGENTA) + ": " + rec.sponsers(recommendedComp).stream().map(ApiPartaker::displayableId).map(id -> session.colourIfNeeded((String)id, CliColour.GREEN)).collect(Collectors.joining(", ")) + " recommends " + session.colourIfNeeded(recommendedComp.displayableId(), CliColour.MAGENTA);
    }

    public static class SolveAndReportResult {
        public final UcApiUtils.SelectedWithApis selectedWithApis;
        public final ImmutableList<RecommendedStatus> recommendedStatus;
        public final ImmutableList<ApiValidationIssue> validationIssues;

        private SolveAndReportResult(UcApiUtils.SelectedWithApis selWithApis, ImmutableList<RecommendedStatus> recStatus, ImmutableList<ApiValidationIssue> validationIssues) {
            this.selectedWithApis = selWithApis;
            this.recommendedStatus = recStatus;
            this.validationIssues = validationIssues;
        }
    }
}

