/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.java.utils.Pair;
import com.silabs.ss.framework.uc.api.sdk.IUcSdk;
import com.silabs.ss.framework.uc.core.api.IConditional;
import com.silabs.ss.framework.uc.core.api.comp.ApiPartaker;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponent;
import com.silabs.ss.framework.uc.core.api.comp.IUcComponentConfiguration;
import com.silabs.ss.framework.uc.core.api.comp.UcInstancedComponent;
import com.silabs.ss.framework.uc.core.api.context.IUcSdkContent;
import com.silabs.ss.framework.uc.core.api.model.IUcProject;
import com.silabs.ss.framework.uc.core.api.model.IUcProjectMutable;
import com.silabs.ss.framework.uc.core.api.rule.ApiId;
import com.silabs.ss.framework.uc.core.api.validate.UcApiUtils;
import com.silabs.uc.cli.internal.command.CliRoot;
import com.silabs.uc.cli.internal.command.exception.ProjectRequiredException;
import com.silabs.uc.cli.internal.command.exception.SdkRequiredException;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliForce;
import com.silabs.uc.cli.internal.command.mixin.CliProjectImplicit;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.CliSlcSdk;
import com.silabs.uc.cli.internal.command.model.SltSdkFeatures;
import com.silabs.uc.cli.internal.model.CliSessionData;
import com.silabs.uc.cli.internal.model.ICliOutput;
import com.silabs.uc.cli.internal.model.ShowSdkWarnings;
import com.silabs.uc.cli.internal.util.CliColour;
import com.silabs.uc.cli.internal.util.CliUtility;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="summarise", aliases={"summarize"}, description={"Prints a summary of components in a project, both user selected and implicity brought in"})
public class UcCliSummary
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliSlcSdk ptcSdkBase;
    @CommandLine.Mixin
    private CliProjectImplicit projectBase;
    @CommandLine.Mixin
    private CliForce force;
    @CommandLine.ParentCommand
    private CliRoot root;
    @CommandLine.Option(names={"--api"}, description={"Enables summarising total provided apis as well."})
    private boolean showApis;
    @CommandLine.Option(names={"--why"}, hidden=true, description={"Deprecated: Has no function anymore. Use 'graph' instead."})
    private boolean showDeps;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.feedback(this.cliConfig);
        IUcSdk sdk = this.ptcSdkBase.loadPtcSdk(feedback, this.sdkBase, ShowSdkWarnings.DO_NOT_SHOW_WARNINGS).orElseThrow(SdkRequiredException::new);
        return this.projectBase.loadProject((IUcSdkContent)sdk, feedback, SltSdkFeatures.fromMixin(this.sdkBase, feedback), true, true, this.force.forceOperations()).map(p -> this.runSummarise((IUcProjectMutable)p, feedback)).orElseThrow(ProjectRequiredException::new);
    }

    public int runSummarise(IUcProjectMutable project, ICliOutput feedback) {
        feedback.out().println("Calculating Dependencies and Preparing Summary...");
        if (this.showDeps) {
            feedback.out().println("The --why option is no longer supported. It is greatly superceded by the 'graph' command. This message will not always exist and eventually --why will be completely removed, so please use 'graph' instead. Support for --why is gone and this summarise call will act as if you did not request --why.");
        }
        UcCliSummary.summarise((IUcProject)project, this.showApis, feedback);
        return IApplication.EXIT_OK;
    }

    public static void summarise(IUcProject project, boolean printProvides, ICliOutput output) {
        CliSessionData session = output.session();
        PrintStream feedback = output.out();
        UcApiUtils.SelectedWithApis selApis = UcApiUtils.calculateSelected((IUcProject)project);
        IUcComponentConfiguration.SplitSelection split = project.splitByExplicitImplicit((List)selApis.trulySelected());
        Set conditionalComponents = project.selectedComponents().filter(cond -> !cond.isUnconditional()).map(IConditional::data).collect(Collectors.toSet());
        Pair<List<String>, List<String>> explicitSels = UcCliSummary.splitSelectionListIncludeInstances((Collection<ApiPartaker>)split.explicitlySelected, project);
        List<String> userStandardComponentsRaw = ((List)explicitSels.first()).stream().sorted().map(ApiPartaker::calculateDisplayableId).collect(Collectors.toList());
        List<String> userInstancedComponentsRaw = ((List)explicitSels.second()).stream().sorted().map(ApiPartaker::calculateDisplayableId).collect(Collectors.toList());
        List<String> implicitComponentsRaw = split.implicitlySelected.stream().map(ApiPartaker::id).sorted().map(ApiPartaker::calculateDisplayableId).collect(Collectors.toList());
        List<String> componentsWithConditions = project.selectedComponents().filter(cond -> !cond.isUnconditional()).map(UcCliSummary::renderComponent).sorted().collect(Collectors.toList());
        feedback.println("User Standard Components: ");
        CliUtility.printStringsNicely(userStandardComponentsRaw, feedback, s -> session.colourIfNeeded((String)s, CliColour.GREEN) + (conditionalComponents.contains(s) ? "*" : ""), session.consoleWidth(), "");
        if (!userInstancedComponentsRaw.isEmpty()) {
            feedback.println("User Instanced Components: ");
            CliUtility.printStringsNicely(userInstancedComponentsRaw, feedback, s -> session.colourIfNeeded((String)s, CliColour.GREEN), session.consoleWidth(), "");
        }
        feedback.println("Auto-computed Dependencies: ");
        CliUtility.printStringsNicely(implicitComponentsRaw, feedback, s -> session.colourIfNeeded((String)s, CliColour.CYAN), session.consoleWidth(), "");
        if (!componentsWithConditions.isEmpty()) {
            feedback.println("* Some components are selected conditionally: ");
            CliUtility.printStringsNicely(componentsWithConditions, feedback, s -> session.colourIfNeeded((String)s, CliColour.GREEN), session.consoleWidth(), "");
        }
        if (printProvides) {
            UcApiUtils.SelectedWithApis selData = UcApiUtils.calculateSelected((IUcProject)project);
            feedback.println("All Apis Provided By All Selected Components");
            CliUtility.printStringsNicely(selData.totalApis().keySet().stream().map(ApiId::id).sorted().collect(Collectors.toList()), output.out(), s -> session.colourIfNeeded((String)s, CliColour.MAGENTA), session.consoleWidth(), "");
        }
    }

    private static Pair<List<String>, List<String>> splitSelectionListIncludeInstances(Collection<ApiPartaker> selections, IUcProject project) {
        ArrayList<String> normal = new ArrayList<String>();
        ArrayList<CallSite> insta = new ArrayList<CallSite>();
        for (ApiPartaker partaker : selections) {
            if (partaker instanceof IUcComponent && ((IUcComponent)partaker).instantiability().isInstantiable()) {
                IUcComponent component = (IUcComponent)partaker;
                String instances = project.instancesFor(component).stream().map(IConditional::data).map(UcInstancedComponent::rawInstanceName).collect(Collectors.joining(":", "(", ")"));
                insta.add((CallSite)((Object)(component.id() + " " + instances)));
                continue;
            }
            normal.add(partaker.id());
        }
        return Pair.of(normal, insta);
    }

    private static String renderComponent(IConditional<String> sel) {
        return String.format("[%-20s | %s]", ApiPartaker.calculateDisplayableId((String)((String)sel.data())), sel.conditionExpression());
    }
}

