/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.security.core.ISecurityCheckpoint;
import com.silabs.ss.platform.api.security.core.ISigningResult;
import com.silabs.ss.platform.api.security.core.trust.ISignable;
import com.silabs.uc.cli.internal.command.UcCliSignature;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.security.CliInternalSignOptimisation;
import com.silabs.uc.cli.internal.command.mixin.security.FileSummaryOutputMixin;
import com.silabs.uc.cli.internal.command.util.FeedbackProgressMonitor;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import picocli.CommandLine;

@CommandLine.Command(name="sign", hidden=true, description={"Signs an sdk or extension with a provided certificate. Be aware that 1) you may not sign the gsdk if you are not Silicon Labs. Doing so and distributing it is a violation of the SDK Extension Partnership Agreement.2) check your agreement to confirm that you are following applicable policies if you plan on distributing what you sign in any form."})
public class UcCliSignatureSign
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.Mixin
    private CliInternalSignOptimisation cmdOptimisation;
    @CommandLine.Mixin
    private FileSummaryOutputMixin fSummary;
    @CommandLine.ParentCommand
    private UcCliSignature root;
    @CommandLine.Option(names={"-pk", "--private-key"}, paramLabel="PRIVATE_KEY_PATH", description={"Location of your private key, used to sign the extension. This must be the same private key that your public key certificate file derived from. (If you have version mismatch issues, you must convert your key to pkcs8 syntax.)"}, required=true)
    private String privateKeyPath;
    @CommandLine.Option(names={"-cert", "--certificate"}, paramLabel="CERTIFICATE_PATH", description={"Location of your certificate. This should contain the public key extracted from your ECDSA private key, and it must have been signed by Silicon Labs."}, required=true)
    private String publicCertPath;

    @Override
    public Integer call() {
        ICliOutput feedback = this.root.session();
        ISDKDescriptor descriptor = this.root.getDescriptor(this.sdkBase, feedback);
        if (descriptor == null) {
            return 1;
        }
        Path privateKey = feedback.resolve(this.privateKeyPath);
        Path publicCert = feedback.resolve(this.publicCertPath);
        this.cmdOptimisation.apply();
        try {
            ISecurityCheckpoint checkpoint = ISecurityCheckpoint.instance();
            feedback.out().println("Beginning Signing of " + descriptor.getInstallationPath().toString());
            FeedbackProgressMonitor monitor = new FeedbackProgressMonitor(feedback);
            ISigningResult result = checkpoint.sign((ISignable)descriptor, privateKey, publicCert, (IProgressMonitor)monitor);
            feedback.out().println(result.message());
            this.fSummary.writeSummaryIfRequested((SortedSet<Path>)result.summary(), feedback);
            return result.wasSigned() ? IApplication.EXIT_OK : 1;
        }
        catch (IllegalArgumentException e) {
            feedback.out().println("Some supplied input data is incorrect: " + e.getLocalizedMessage());
            feedback.unifiedLogger().internalWarning("During call to sign: " + e.getLocalizedMessage(), (Throwable)e);
            return 2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

