/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.command;

import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.uc.cli.internal.command.UcCliSignature;
import com.silabs.uc.cli.internal.command.mixin.BaseOptions;
import com.silabs.uc.cli.internal.command.mixin.CliSdk;
import com.silabs.uc.cli.internal.command.mixin.UcCliTrustMixin;
import com.silabs.uc.cli.internal.command.trust.SignatureTrustOrDisavow;
import com.silabs.uc.cli.internal.model.ICliOutput;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="disavow", description={"Removes the given sdk or extension as part of the set of trusted extensions. Depending on further options to this method, this will either be disavowed from trusted unsigned extensions, or implicitly trusted signed ones (which will force them to be revalidated next time they are used)"})
public class UcCliSignatureDisavow
implements Callable<Integer> {
    @CommandLine.Mixin
    private BaseOptions cliConfig;
    @CommandLine.Mixin
    private CliSdk sdkBase;
    @CommandLine.ParentCommand
    private UcCliSignature signatureCommand;
    @CommandLine.Mixin
    private UcCliTrustMixin trustMixin;

    @Override
    public Integer call() {
        ICliOutput feedback = this.signatureCommand.session();
        ISDKDescriptor descriptor = this.signatureCommand.getDescriptor(this.sdkBase, feedback);
        if (descriptor == null) {
            return 1;
        }
        SignatureTrustOrDisavow helperCommand = new SignatureTrustOrDisavow(this.trustMixin, descriptor, feedback);
        return helperCommand.doDisavow();
    }
}

