/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.toolchain.core;

import com.silabs.java.utils.CollectionUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.toolchain.core.IResolvedToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.IToolOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToolOption
implements IToolOption,
IResolvedToolOption {
    private String toolId;
    private String optionId;
    private String value;
    private boolean builtin;
    private Map<String, BUILTIN> listValues;

    public ToolOption() {
    }

    public ToolOption(String toolId, String optionId, String value, Stream<String> listValues) {
        this.toolId = toolId.intern();
        this.optionId = optionId.intern();
        this.value = value != null ? value.intern() : "";
        this.setListValues(listValues);
    }

    public ToolOption(String toolId, String optionId, String value, String ... listValues) {
        this(toolId, optionId, value, listValues == null ? Stream.empty() : Stream.of(listValues));
    }

    public ToolOption(String toolId, String optionId, String value, List<String> listValues) {
        this(toolId, optionId, value, listValues == null ? Stream.empty() : listValues.stream());
    }

    public String toString() {
        return "ToolOption [toolId=" + this.toolId + ", optionId=" + this.optionId + ", value=" + this.value + ", builtin=" + this.builtin + ", listValues= " + TextUtils.catenateStrings(this.listValues.keySet(), (String)", ") + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.optionId == null ? 0 : this.optionId.hashCode());
        result = 31 * result + (this.toolId == null ? 0 : this.toolId.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.listValues == null ? 0 : this.listValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolOption other = (ToolOption)obj;
        if (this.optionId == null ? other.optionId != null : !this.optionId.equals(other.optionId)) {
            return false;
        }
        if (this.toolId == null ? other.toolId != null : !this.toolId.equals(other.toolId)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.listValues == null ? other.listValues != null : !this.listValues.equals(other.listValues));
    }

    @Override
    public String getToolIdPattern() {
        return this.getToolId();
    }

    @Override
    public String getOptionIdRepl() {
        return this.getOptionId();
    }

    @Override
    public String getValueRepl() {
        return this.getValue();
    }

    @Override
    public List<String> getListValues() {
        return new ArrayList<String>(this.listValues.keySet());
    }

    public void setListValues(List<String> listValues) {
        this.setListValues(listValues.stream());
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setListValueBuiltin(String value, boolean builtin) {
        this.listValues.put(value, BUILTIN.getFor(builtin));
    }

    @Override
    public boolean isListValueBuiltin(String value) {
        BUILTIN builtin = Optional.ofNullable(this.listValues.get(value)).orElse(BUILTIN.FALSE);
        return builtin.get(this);
    }

    private void setListValues(Stream<String> listValues) {
        if (this.listValues == null || this.listValues.isEmpty()) {
            this.listValues = (Map)listValues.distinct().collect(CollectionUtils.toMap(v -> v, v -> BUILTIN.PARENT, LinkedHashMap::new));
        }
    }

    @Override
    public void resolveBuiltinState(IToolOption option) {
        ToolOption opt = (ToolOption)option;
        this.setBuiltin(opt.isBuiltin());
        option.getListValues().forEach(v -> this.setListValueBuiltin((String)v, opt.isListValueBuiltin((String)v)));
    }

    @Override
    public String getToolId() {
        return this.toolId;
    }

    @Override
    public String getOptionId() {
        return this.optionId;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setToolId(String toolId) {
        this.toolId = toolId;
    }

    public void setOptionId(String optionId) {
        this.optionId = optionId;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, String> getListValuesMap() {
        return this.listValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BUILTIN)((Object)((Object)e.getValue()))).name()));
    }

    public void setListValuesMap(Map<String, String> listValueMap) {
        this.listValues = listValueMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> BUILTIN.valueOf((String)e.getValue())));
    }

    private static enum BUILTIN {
        TRUE,
        FALSE,
        PARENT;


        private boolean get(ToolOption opt) {
            switch (this) {
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
                case PARENT: {
                    return opt.builtin;
                }
            }
            throw new IllegalStateException();
        }

        private static BUILTIN getFor(Boolean bool) {
            if (bool == null) {
                return PARENT;
            }
            return bool != false ? TRUE : FALSE;
        }
    }
}

