/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.toolchain.core;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.toolchain.core.IToolchainDescriptor;
import com.silabs.ss.framework.project.internal.toolchain.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.IWriteableVersionedDescriptor;
import com.silabs.ss.platform.api.rcp.core.DevUtils;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.IPath;
import org.osgi.framework.Version;

public class SystemToolchainCache {
    private static final String CACHE_FILE_EXTENSION = ".properties";
    private final String cacheId;
    private final BiFunction<IPath, String, IPath> pathGenerator;
    private final String[] checkedTools;

    public SystemToolchainCache(String cacheId, BiFunction<IPath, String, IPath> pathGenerator, String ... checkedTools) {
        this.cacheId = SystemToolchainCache.formatCacheId(cacheId);
        this.pathGenerator = pathGenerator;
        this.checkedTools = checkedTools;
    }

    private static String formatCacheId(String cacheId) {
        if (!((String)cacheId).endsWith(CACHE_FILE_EXTENSION)) {
            cacheId = (String)cacheId + CACHE_FILE_EXTENSION;
        }
        return cacheId;
    }

    public boolean checkForSavedData(IToolchainDescriptor toolchain, IPath installPath) {
        File toolchainCacheFile = this.getToolchainCacheFile();
        Properties props = SystemToolchainCache.getProperties(toolchainCacheFile);
        String toolchainData = props.getProperty(SystemToolchainCache.generateKey(installPath));
        if (TextUtils.isEmpty((String)toolchainData)) {
            return false;
        }
        String[] entries = TextUtils.splitByCharacter((String)toolchainData, (char)',');
        if (entries.length != this.checkedTools.length + 1) {
            return false;
        }
        int i = 0;
        while (i < this.checkedTools.length) {
            try {
                long currentTimeStamp = this.pathGenerator.apply(installPath, this.checkedTools[i]).toFile().lastModified();
                long savedTimeStamp = Long.parseLong(entries[i]);
                if (currentTimeStamp != savedTimeStamp) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                Activator.reporter.logError("Failed to load the timestamps for " + String.valueOf(entries[0]), (Throwable)e);
                return false;
            }
            ++i;
        }
        ((IWriteableVersionedDescriptor)toolchain).setVersion(entries[this.checkedTools.length]);
        return true;
    }

    public void saveToolchainData(IToolchainDescriptor toolchain, IPath installPath) {
        if (Version.emptyVersion.equals((Object)toolchain.getVersion()) || toolchain.getVersion() == null) {
            return;
        }
        if (!installPath.toFile().exists()) {
            return;
        }
        File toolchainCacheFile = this.getToolchainCacheFile();
        Properties props = SystemToolchainCache.getProperties(toolchainCacheFile);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.checkedTools.length) {
            long currentTimeStamp = this.pathGenerator.apply(installPath, this.checkedTools[i]).toFile().lastModified();
            sb.append(String.valueOf(currentTimeStamp)).append(",");
            ++i;
        }
        String savedString = sb.append(toolchain.getVersionString()).toString();
        props.setProperty(SystemToolchainCache.generateKey(installPath), savedString);
        try {
            FileUtils.writeProperties((Properties)props, (File)toolchainCacheFile);
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
            return;
        }
    }

    private static Properties getProperties(File toolchainCacheFile) {
        Properties props;
        Optional.of(toolchainCacheFile).map(File::getParentFile).filter(f -> !f.exists()).ifPresent(File::mkdirs);
        try {
            props = toolchainCacheFile.createNewFile() ? new Properties() : FileUtils.readProperties((File)toolchainCacheFile);
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
            props = new Properties();
        }
        return props;
    }

    private static String generateKey(IPath installPath) {
        String key = installPath.toString().replaceAll("(/|\\\\)+", "/");
        if (key.endsWith("/")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private File getToolchainCacheFile() {
        if (RuntimeUtils.isJUnitRunning()) {
            return DevUtils.getWorkspaceLocation().append(".metadata/toolchainCache").append(this.cacheId).toFile();
        }
        return HostUtils.getUserAppDataLocation().resolve(this.cacheId).toFile();
    }
}

