/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.model.options;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IReverseOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.OptionMappingAtom;
import com.silabs.ss.framework.project.internal.core.model.options.ListOptionMappingAtom;
import com.silabs.ss.framework.project.internal.core.model.options.ValueOptionMappingAtom;
import com.silabs.ss.framework.project.internal.core.model.options.VariableValueOptionMappingAtom;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.PropertyConversionUtils;
import com.silabs.ss.platform.api.descriptor.core.type.IListType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class BaseOptionMappingFactory<OutgoingOption extends MConvertedOption, IncomingMapping extends IOptionMapping<OutgoingOption>, OutgoingMapping extends IReverseOptionMapping<OutgoingOption>> {
    protected Map<String, List<OptionMappingAtom>> incomingToOutgoingMap = new LinkedHashMap<String, List<OptionMappingAtom>>();
    protected IProperty incomingOption;
    protected EMappingStatus status;
    protected Object incomingValue;

    protected BaseOptionMappingFactory(IProperty incomingOption) {
        if (incomingOption == null) {
            throw new IllegalArgumentException("no property defined");
        }
        this.incomingOption = incomingOption;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> forSpecific(Object valueOrPattern) {
        if (this.incomingValue != null) {
            throw new IllegalArgumentException("forSpecific value already defined");
        }
        this.incomingValue = valueOrPattern;
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapTo(IProperty outgoingOption) {
        ValueOptionMappingAtom atom = new ValueOptionMappingAtom(outgoingOption, null);
        this.addAtom(null, atom);
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapToReplacing(IProperty outgoingOption, Map<String, String> replacements) {
        VariableValueOptionMappingAtom atom = new VariableValueOptionMappingAtom(replacements, outgoingOption, null);
        this.addAtom(null, atom);
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapToList(IProperty outgoingOption) {
        if (!(outgoingOption.getType() instanceof IListType)) {
            throw new IllegalArgumentException("type of " + String.valueOf(outgoingOption) + " is not a list");
        }
        ListOptionMappingAtom atom = new ListOptionMappingAtom(outgoingOption);
        this.addAtom(null, atom);
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapFromTo(IProperty outgoingOption, Object ... externalAndOutgoingValues) {
        if (outgoingOption == null) {
            throw new IllegalArgumentException("no outgoing option");
        }
        int i = 0;
        while (i < externalAndOutgoingValues.length) {
            Object externalValue = externalAndOutgoingValues[i];
            Object outgoingValue = externalAndOutgoingValues[i + 1];
            if (outgoingValue != "<<any value>>") {
                PropertyConversionUtils.stringizeValue((IProperty)outgoingOption, (Object)outgoingValue);
            }
            if (!(externalValue instanceof Pattern) && externalValue != "<<any value>>") {
                PropertyConversionUtils.stringizeValue((IProperty)this.incomingOption, (Object)externalValue);
            }
            ValueOptionMappingAtom atom = new ValueOptionMappingAtom(outgoingOption, outgoingValue);
            if (!(externalValue instanceof Pattern)) {
                this.addAtom(externalValue, atom);
            } else {
                Pattern pattern = (Pattern)externalValue;
                List enums = this.incomingOption.getType().getEnumValues();
                if (enums == null) {
                    throw new IllegalArgumentException("use of a Pattern for mapFromTo requires an enum specificOption");
                }
                boolean matchAny = false;
                for (String enum_ : enums) {
                    if (!pattern.matcher(enum_).matches()) continue;
                    matchAny = true;
                    this.addAtom(enum_, atom);
                }
                if (!matchAny) {
                    throw new IllegalArgumentException("Pattern " + String.valueOf(pattern) + " does not match any values for " + String.valueOf(this.incomingOption.getType()) + ": " + TextUtils.catenateStrings((Collection)enums, (String)", "));
                }
            }
            i += 2;
        }
        return this;
    }

    protected void addAtom(Object externalValue, OptionMappingAtom atom) {
        String extValueStr = externalValue != null && externalValue != "<<any value>>" ? PropertyConversionUtils.stringizeValue((IProperty)this.incomingOption, (Object)externalValue) : "<<any value>>";
        List<OptionMappingAtom> atoms = this.incomingToOutgoingMap.get(extValueStr);
        if (atoms == null) {
            atoms = new ArrayList<OptionMappingAtom>(1);
            this.incomingToOutgoingMap.put(extValueStr, atoms);
        }
        atoms.add(atom);
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapValue(IProperty outgoingOption, Object outgoingValue) {
        return this.mapFromTo(outgoingOption, "<<any value>>", outgoingValue);
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapIgnored(IProperty ... outgoingOptions) {
        IProperty[] iPropertyArray = outgoingOptions;
        int n = outgoingOptions.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty outgoingOption = iPropertyArray[n2];
            this.mapValue(outgoingOption, "<<any value>>");
            ++n2;
        }
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapTrue(IProperty ... outgoingOptions) {
        IProperty[] iPropertyArray = outgoingOptions;
        int n = outgoingOptions.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty outgoingOption = iPropertyArray[n2];
            this.mapValue(outgoingOption, Boolean.TRUE);
            ++n2;
        }
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> mapFalse(IProperty ... outgoingOptions) {
        IProperty[] iPropertyArray = outgoingOptions;
        int n = outgoingOptions.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty outgoingOption = iPropertyArray[n2];
            this.mapValue(outgoingOption, Boolean.FALSE);
            ++n2;
        }
        return this;
    }

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> is(EMappingStatus status) {
        this.status = status;
        return this;
    }

    protected void doRegister(IOptionMappingRegistry<?, ?, ?> registry) {
        if (this.status == null) {
            throw new IllegalArgumentException("need a call to #is(EMappingStatus)");
        }
        if (this.incomingValue instanceof Pattern) {
            Pattern pattern = (Pattern)this.incomingValue;
            List enums = this.incomingOption.getType().getEnumValues();
            if (enums == null) {
                throw new IllegalArgumentException("use of a Pattern for forSpecific requires an enum specificOption");
            }
            boolean matchAny = false;
            for (String enum_ : enums) {
                if (!pattern.matcher(enum_).matches()) continue;
                matchAny = true;
                this.registerOptionMapping(registry, enum_);
            }
            if (!matchAny) {
                throw new IllegalArgumentException("Pattern " + String.valueOf(pattern) + " does not match any values for " + String.valueOf(this.incomingOption.getType()) + ": " + TextUtils.catenateStrings((Collection)enums, (String)", "));
            }
        } else {
            this.registerOptionMapping(registry, this.incomingValue);
        }
    }

    protected abstract void registerOptionMapping(IOptionMappingRegistry<?, ?, ?> var1, Object var2);

    protected abstract BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> doWith(IProperty var1);

    public BaseOptionMappingFactory<OutgoingOption, IncomingMapping, OutgoingMapping> addTo(IOptionMappingRegistry<OutgoingOption, IncomingMapping, OutgoingMapping> registry) {
        this.doRegister(registry);
        return this.doWith(this.incomingOption);
    }
}

