/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.splitter;

import com.silabs.pti.splitter.ISplitter;
import com.silabs.pti.util.ICharacterListener;
import java.util.ArrayList;
import java.util.List;

public class ChainSplitter
implements ISplitter {
    private final List<ISplitter> splitters = new ArrayList<ISplitter>();

    public ChainSplitter(ISplitter ... splitters) {
        for (int i = 1; i < splitters.length; ++i) {
            splitters[i - 1].setCharacterListener(0, splitters[i]);
        }
        for (ISplitter s : splitters) {
            this.splitters.add(s);
        }
    }

    @Override
    public void received(byte[] ch, int offset, int len) {
        this.splitters.get(0).received(ch, offset, len);
    }

    @Override
    public void setCharacterListener(int bucket, ICharacterListener l) {
        if (bucket == 0) {
            this.splitters.get(this.splitters.size() - 1).setCharacterListener(0, l);
        } else {
            for (ISplitter s : this.splitters) {
                s.setCharacterListener(1, l);
            }
        }
    }

    @Override
    public int bucketCount() {
        return this.splitters.get(0).bucketCount();
    }

    @Override
    public void flush() {
        for (ISplitter s : this.splitters) {
            s.flush();
        }
    }
}

