/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.protocol;

import com.silabs.pti.decode.ISparseFieldEnum;

public enum ZWaveRegion implements ISparseFieldEnum
{
    INVALID(0, "Default Invalid", new int[]{100000, 40000, 9600}),
    EU(1, "European Union", new int[]{100000, 40000, 9600}),
    US(2, "United States", new int[]{100000, 40000, 9600}),
    ANZ(3, "Australia/New Zealand", new int[]{100000, 40000, 9600}),
    HK(4, "Hong Kong", new int[]{100000, 40000, 9600}),
    MY(5, "Malaysia", new int[]{100000, 40000, 9600}),
    IN(6, "India", new int[]{100000, 40000, 9600}),
    JP(7, "Japan", new int[]{100000, 100000, 100000}),
    RU(8, "Russia", new int[]{100000, 40000, 9600}),
    IL(9, "Israel", new int[]{100000, 40000, 9600}),
    KR(10, "Korea", new int[]{100000, 100000, 100000}),
    CN(11, "China", new int[]{100000, 40000, 9600}),
    US_LR1(12, "United States, first long range PHY", new int[]{100000, 40000, 9600, 100000}),
    US_LR2(13, "United States, second long range PHY", new int[]{100000, 40000, 9600, 100000}),
    US_LR_END_DEVICE(14, "United States, long range end device PHY", new int[]{100000, 100000});

    private int id;
    private String title;
    private int[] channelToBaudRate;

    private ZWaveRegion(int id, String title, int[] channelToBaudRate) {
        this.id = id;
        this.title = title;
        this.channelToBaudRate = channelToBaudRate;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String title() {
        return this.title;
    }

    public int crcLengthFromChannel(int channel) {
        if (channel >= 0 && channel < this.channelToBaudRate.length) {
            int baudRate = this.channelToBaudRate[channel];
            switch (baudRate) {
                case 100000: {
                    return 2;
                }
            }
            return 1;
        }
        return 1;
    }

    public static int calculateZWaveCrcLength(byte[] payload) {
        if (payload.length < 4) {
            return 1;
        }
        int region = payload[payload.length - 4] & 0xF;
        int channel = payload[payload.length - 3] & 0x3F;
        return ZWaveRegion.crcLengthFromRegionNumberAndChannelNumber(region, channel);
    }

    public static int crcLengthFromRegionNumberAndChannelNumber(int region, int channel) {
        for (ZWaveRegion r : ZWaveRegion.values()) {
            if (r.id != region) continue;
            return r.crcLengthFromChannel(channel);
        }
        return 1;
    }
}

