/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.format;

import com.silabs.na.pcap.IPcapOutput;
import com.silabs.na.pcap.LinkType;
import com.silabs.pti.debugchannel.DebugMessage;
import com.silabs.pti.debugchannel.EventType;
import com.silabs.pti.format.IDebugChannelExportFormat;
import com.silabs.pti.format.IDebugChannelExportOutput;
import com.silabs.pti.format.PcapngOutput;
import com.silabs.pti.protocol.RadioInfoEfr32;
import java.io.File;
import java.io.IOException;

public class PcapngFormat
implements IDebugChannelExportFormat<IPcapOutput> {
    private final Mode mode;

    public PcapngFormat(Mode mode) {
        this.mode = mode;
    }

    @Override
    public IDebugChannelExportOutput<IPcapOutput> createOutput(File f, boolean append) throws IOException {
        if (append) {
            throw new IOException("Appending to pcap files not supported.");
        }
        return new PcapngOutput(f);
    }

    @Override
    public IDebugChannelExportOutput<IPcapOutput> createStdoutOutput() throws IOException {
        return null;
    }

    @Override
    public String description() {
        return this.mode.description();
    }

    @Override
    public void writeHeader(IPcapOutput out) throws IOException {
        out.writeInterfaceDescriptionBlock(this.mode.linkType(), 6);
    }

    @Override
    public boolean formatDebugMessage(IPcapOutput out, String originator, DebugMessage dm, EventType type) throws IOException {
        long time;
        byte[] content;
        switch (this.mode) {
            case BLUETOOTH: 
            case MATTER: 
            case ZIGBEE: 
            case WISUN: {
                if (!type.isPacket()) {
                    return false;
                }
                byte[] buff = dm.contents();
                int startOffset = 0;
                int endOffset = buff.length;
                if (type.isFromEfr()) {
                    int len;
                    if (buff[startOffset] == -8 || buff[startOffset] == -4) {
                        ++startOffset;
                    }
                    if (this.mode == Mode.WISUN) {
                        ++startOffset;
                    }
                    if (!type.hasNoLengthByte()) {
                        ++startOffset;
                    }
                    if ((len = (endOffset -= RadioInfoEfr32.determineRadioInfoLength(type, buff, this.mode == Mode.BLUETOOTH)) - startOffset) < 0) {
                        return false;
                    }
                    content = new byte[len];
                    System.arraycopy(buff, startOffset, content, 0, len);
                } else {
                    content = buff;
                }
                time = dm.networkTime();
                break;
            }
            default: {
                content = dm.contents();
                time = dm.networkTime();
            }
        }
        out.writeEnhancedPacketBlock(0, time, content);
        return true;
    }

    @Override
    public boolean formatRawBytes(IPcapOutput out, long pcTimeMs, byte[] rawBytes, int offset, int length) throws IOException {
        out.writeEnhancedPacketBlock(0, pcTimeMs, rawBytes);
        return true;
    }

    @Override
    public void writeRawUnframedData(IPcapOutput out, byte[] rawBytes, int offset, int length) throws IOException {
        throw new IOException("PCAP NG does not support unframed writing.");
    }

    @Override
    public boolean isUsingDebugMessages() {
        return true;
    }

    @Override
    public boolean isUsingRawBytes() {
        return this.mode.usesRawBytes();
    }

    public static enum Mode {
        DCH(LinkType.USER12, "PCAPNG format: capturing whole debug channel as custom linktype 'user12'. All channel data is captured.", true),
        ZIGBEE(LinkType.IEEE802_15_4_NOFCS, "PCAPNG format for Zigbee: using 802.15.4 no-FCS link type. Only 15.4 packets are captured.", false),
        MATTER(LinkType.IEEE802_15_4_NOFCS, "PCAPNG format for Matter: using 802.15.4 no-FCS link type. Only 15.4 packets are captured.", false),
        BLUETOOTH(LinkType.BLUETOOTH_LE_LL, "PCAPNG format for Bluetooth: using Bluetooth LE_LL link type. Only Bluetooth packets are captured.", false),
        WISUN(LinkType.IEEE802_15_4_NOFCS, "PCAPNG format for Wi-SUN: using 802.15.4 no-FCS link type. Only 15.4 packets are captured.", false);

        private LinkType linkType;
        private String description;
        private boolean usesRawBytes;

        private Mode(LinkType linkType, String description, boolean usesRawBytes) {
            this.linkType = linkType;
            this.description = description;
            this.usesRawBytes = usesRawBytes;
        }

        public LinkType linkType() {
            return this.linkType;
        }

        public String description() {
            return this.description;
        }

        public boolean usesRawBytes() {
            return this.usesRawBytes;
        }
    }
}

