/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.debugchannel;

import java.util.ResourceBundle;

public enum DebugMessageType {
    TIME_SYNC(0),
    RESET_INFO(1),
    PRINTF(2),
    API_TRACE(3),
    ASSERT(4),
    CORE_DUMP(5),
    PHY_RX(6),
    API_RX(7),
    PHY_TX(8),
    API_TX(9),
    PACKET_TRACE(10),
    ERROR(11),
    STATS(12),
    TIME_SYNC_TEST(13),
    RADIO_REBOOT_COUNT(14),
    VIRTUAL_UART_TX(17),
    VIRTUAL_UART_RX(18),
    PACKET_TRACE_EM2420_TX(32),
    PACKET_TRACE_EM2420_RX(33),
    PACKET_TRACE_EM2XX_TX(34),
    PACKET_TRACE_EM2XX_RX(35),
    PACKET_TRACE_EM3XX_TX(36),
    PACKET_TRACE_EM3XX_RX(37),
    PACKET_TRACE_PRO2P_TX(38),
    PACKET_TRACE_PRO2P_RX(39),
    PACKET_TRACE_PRO2P_OTHER(40),
    PACKET_TRACE_EFR_TX(41),
    PACKET_TRACE_EFR_RX(42),
    PACKET_TRACE_EFR_OTHER(43),
    FLASH_READ_REQUEST(48),
    FLASH_READ_RESPONSE(49),
    EEPROM_READ_REQUEST(50),
    EEPROM_READ_RESPONSE(51),
    EEPROM_WRITE_REQUEST(52),
    EEPROM_WRITE_RESPONSE(53),
    RAM_READ_REQUEST(54),
    RAM_READ_RESPONSE(55),
    RAM_WRITE_REQUEST(56),
    RAM_WRITE_RESPONSE(57),
    INFO_REQUEST(58),
    INFO_RESPONSE(59),
    EZSP(60),
    EZSP_UART(61),
    DAG_TRACE(62),
    SIMULATED_EZSP_CALLBACK_READY(63),
    SIMULATED_WAKEUP_NCP(64),
    SIMULATED_NCP_IS_AWAKE(65),
    INFO_ZNET_VERSION(66),
    INFO_ZIP_VERSION(67),
    TIME(68),
    HEAP_STACK(69),
    MUSTANG(70),
    LATENCY(71),
    TMSP(72),
    AEM_SAMPLE(80),
    AEM_COUNTER(81),
    AEM_REQUEST(96),
    AEM_RESPONSE(97),
    AEM_CURRENT_PACKET(98),
    AEM_CURRENT_PACKET_V2(99),
    PC_SAMPLE_PACKET(100),
    EXCEPTION_PACKET(101),
    LOGIC_ANALYZER(102),
    CPU_USAGE(112),
    CONFIG_OVER_SWO(128),
    USER_COMMAND(65534),
    USER_RESPONSE(65535),
    INVALID(-1);

    private final int value;
    private static final String BUNDLE_NAME = "debugMessageType";
    private static final ResourceBundle names;

    private DebugMessageType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public String description() {
        try {
            return names.getString(this.name());
        }
        catch (Exception e) {
            return this.name().toLowerCase();
        }
    }

    public String longDescription() {
        try {
            return names.getString(this.name() + ".long");
        }
        catch (Exception e) {
            return this.description();
        }
    }

    public static DebugMessageType get(int value) {
        DebugMessageType[] values = DebugMessageType.values();
        int low = 0;
        int high = values.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            DebugMessageType dmt = values[mid];
            if (dmt.value() == value) {
                return dmt;
            }
            if (dmt.value() > value) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return INVALID;
    }

    public static int featureLevel() {
        return 22;
    }

    public static String featureDate() {
        return "2022.1.8";
    }

    static {
        names = ResourceBundle.getBundle(BUNDLE_NAME);
    }
}

