/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;

public class TimeSynchronizer {
    public static LongSupplier DEFAULT_PC_TIME_SUPPLIER = () -> System.currentTimeMillis();
    private final LongSupplier millisecondTimeSupplier;
    private final boolean performDriftCorrection;
    private final long driftThreshold;
    private final long zeroTimeDifferenceThreshold;
    private Long masterPcTimeZero = null;
    private final Map<String, Long> tZeroMap;
    private Op lastOp = Op.NONE;
    private Long lastCorrection = null;

    public TimeSynchronizer(LongSupplier millisecondTimeSupplier, boolean performDriftCorrection, long driftThresholdMicroseconds, long zeroTimeDifferenceThreshold) {
        this.performDriftCorrection = performDriftCorrection;
        this.millisecondTimeSupplier = millisecondTimeSupplier;
        this.driftThreshold = driftThresholdMicroseconds;
        this.zeroTimeDifferenceThreshold = zeroTimeDifferenceThreshold;
        this.tZeroMap = new HashMap<String, Long>();
    }

    public Long timeZero(String originator) {
        return this.tZeroMap.get(originator);
    }

    private void setTimeZero(String originator, Long time) {
        this.tZeroMap.put(originator, time);
    }

    public Op lastOp() {
        return this.lastOp;
    }

    public Long lastCorrection() {
        return this.lastCorrection;
    }

    public long synchronizedTime(String originatorId, long timeInMicroseconds) {
        Op op;
        long tMillis = this.millisecondTimeSupplier.getAsLong();
        Long tZero = this.timeZero(originatorId);
        if (tZero == null) {
            if (this.tZeroMap.isEmpty()) {
                tZero = timeInMicroseconds;
                this.masterPcTimeZero = tMillis;
                this.setTimeZero(originatorId, tZero);
                op = Op.GLOBAL_ZERO;
            } else {
                Long usableT0 = this.findUsableTimeZero(tMillis, timeInMicroseconds);
                if (usableT0 == null) {
                    long expectedRealMicrosecondTime = (tMillis - this.masterPcTimeZero) * 1000L;
                    tZero = timeInMicroseconds - expectedRealMicrosecondTime;
                    op = Op.ORIGINATOR_ZERO_WITH_CORRECTION;
                    this.lastCorrection = tZero;
                } else {
                    tZero = usableT0;
                    op = Op.ORIGINATOR_ZERO;
                }
                this.setTimeZero(originatorId, tZero);
            }
        } else if (this.performDriftCorrection) {
            long expectedRealMicrosecondTime = (tMillis - this.masterPcTimeZero) * 1000L;
            long microsecondTime = timeInMicroseconds - tZero;
            if (this.isDriftTooLarge(microsecondTime, expectedRealMicrosecondTime)) {
                long newTZero = timeInMicroseconds - expectedRealMicrosecondTime;
                this.setTimeZero(originatorId, newTZero);
                op = Op.ZERO_OFFSET_WITH_CORRECTION;
                this.lastCorrection = newTZero - tZero;
                tZero = newTZero;
            } else {
                op = Op.ZERO_OFFSET;
            }
        } else {
            op = Op.ZERO_OFFSET;
        }
        this.lastOp = op;
        return timeInMicroseconds - tZero;
    }

    private boolean isDriftTooLarge(long micros1, long micros2) {
        return Math.abs(micros1 - micros2) >= this.driftThreshold;
    }

    private Long findUsableTimeZero(long tMillis, long micros) {
        long expectedRealMicrosecondTime = (tMillis - this.masterPcTimeZero) * 1000L;
        for (Long t0 : this.tZeroMap.values()) {
            long expectedEventMicrosecondTime = t0 + expectedRealMicrosecondTime;
            if (!this.isZeroTimeWithinThreshold(expectedEventMicrosecondTime, micros)) continue;
            return t0;
        }
        return null;
    }

    private boolean isZeroTimeWithinThreshold(long micros1, long micros2) {
        return Math.abs(micros1 - micros2) < this.zeroTimeDifferenceThreshold;
    }

    public static enum Op {
        NONE(false),
        GLOBAL_ZERO(false),
        ORIGINATOR_ZERO(false),
        ORIGINATOR_ZERO_WITH_CORRECTION(true),
        ZERO_OFFSET(false),
        ZERO_OFFSET_WITH_CORRECTION(true);

        private boolean correction;

        private Op(boolean performedCorrection) {
            this.correction = performedCorrection;
        }

        public boolean performedCorrection() {
            return this.correction;
        }
    }
}

