/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.log.PtiLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class DataBuffer<T>
implements Runnable {
    private final List<T> buffer = new ArrayList<T>(1000);
    private Thread fetchThread = null;
    private ThreadGroup threadGroup = null;
    private boolean stopThread;
    private final Consumer<T> listener;
    private final String consumerThreadName;

    public DataBuffer(String consumerThreadName, Consumer<T> listener) {
        this(null, consumerThreadName, listener);
    }

    public DataBuffer(ThreadGroup tg, String consumerThreadName, Consumer<T> listener) {
        this.threadGroup = tg;
        this.consumerThreadName = consumerThreadName;
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        this.listener = listener;
    }

    public void startThread() {
        if (this.fetchThread != null) {
            return;
        }
        this.stopThread = false;
        this.fetchThread = new Thread(this.threadGroup, this, this.consumerThreadName);
        this.fetchThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        if (this.fetchThread != null && this.fetchThread.isAlive()) {
            this.stopThread = true;
            List<T> list = this.buffer;
            synchronized (list) {
                this.buffer.notifyAll();
            }
            try {
                if (this.fetchThread != null) {
                    this.fetchThread.join();
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InterruptedException ie) {
                PtiLog.warning("Could not wait for thread to die.", ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(T object) {
        List<T> list = this.buffer;
        synchronized (list) {
            this.buffer.add(object);
            this.buffer.notify();
        }
    }

    private T fetchObject() throws InterruptedException {
        List<T> list = this.buffer;
        synchronized (list) {
            while (true) {
                if (this.buffer.size() > 0) {
                    return this.buffer.remove(0);
                }
                if (this.stopThread) {
                    return null;
                }
                this.buffer.wait();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                T dm;
                if ((dm = this.fetchObject()) == null) {
                    this.fetchThread = null;
                    return;
                }
                this.listener.accept(dm);
            }
        }
        catch (InterruptedException ie) {
            PtiLog.warning("Data buffer thread is interrupted", ie);
            return;
        }
    }
}

