/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.pti.adapter;

import com.silabs.pti.adapter.BaseConnection;
import com.silabs.pti.adapter.IConnectivityLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class BufferedNioConnection
extends BaseConnection {
    private SocketChannel channel = null;
    private Selector selector;
    private SelectionKey readKey;
    private Thread selectionThread = null;

    public BufferedNioConnection(String host, int port, IConnectivityLogger logger) {
        super(host, port, logger);
    }

    @Override
    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        if (this.connectionEnabler != null) {
            this.connectionEnabler.prepareConnection(this.host + ":" + this.port);
        }
        this.channel = SocketChannel.open(address);
        this.channel.configureBlocking(false);
        this.selector = Selector.open();
        this.selectionThread = new Thread(){

            @Override
            public void run() {
                BufferedNioConnection.this.logInfo("Reading thread start.");
                ByteBuffer buffer = ByteBuffer.allocate(100000);
                block3: while (true) {
                    try {
                        while (true) {
                            int ret;
                            if ((ret = BufferedNioConnection.this.selector.select()) <= 0 || !BufferedNioConnection.this.selector.selectedKeys().contains(BufferedNioConnection.this.readKey)) {
                                continue;
                            }
                            buffer.rewind();
                            int readCount = BufferedNioConnection.this.channel.read(buffer);
                            long readTime = System.currentTimeMillis();
                            if (readCount == -1) break block3;
                            if (readCount <= 0) continue;
                            byte[] data = new byte[readCount];
                            buffer.rewind();
                            buffer.get(data);
                            BufferedNioConnection.this.processIncomingData(readTime, readCount, data);
                        }
                    }
                    catch (ClosedSelectorException cse) {
                    }
                    catch (IOException ioe) {
                        BufferedNioConnection.this.reportProblem("Error reading data", ioe);
                        BufferedNioConnection.this.logError("Reading thread error.", ioe);
                        continue;
                    }
                    break;
                }
                BufferedNioConnection.this.logInfo("Reading thread stop.");
            }
        };
        this.readKey = this.channel.register(this.selector, 1);
        this.logInfo("Connect.");
        this.selectionThread.start();
        this.informListenersOfState(true);
    }

    @Override
    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.logInfo("Disconnect.");
            this.channel.close();
            this.selector.close();
        }
        catch (IOException ioe) {
            this.reportProblem("Close socket.", ioe);
            this.logError("Disconnect error.", ioe);
        }
        if (this.connectionEnabler != null) {
            this.connectionEnabler.releaseConnection(this.host + ":" + this.port);
        }
        this.informListenersOfState(false);
    }

    @Override
    public void send(byte[] message) throws IOException {
        if (!this.isConnected()) {
            this.logError("Attempting to write, but socket is not connected.", null);
            return;
        }
        byte[] outgoing = this.frameOutgoing ? this.outgoingFramer.frame(message) : message;
        this.logInfo("Write " + outgoing.length + " bytes.");
        this.channel.write(ByteBuffer.wrap(outgoing));
    }

    @Override
    public boolean isConnected() {
        return this.channel != null;
    }
}

