/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.internal.scripting;

import com.silabs.ss.support.mcu.internal.scripting.DataHexFileLineInfo;
import com.silabs.ss.support.mcu.internal.scripting.ExtAddrLineInfo;
import com.silabs.ss.support.mcu.internal.scripting.IHexFileLineInfo;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class HexFileUtils {
    public static final int DATA_TYPE = 0;
    public static final int EXT_LINEAR_ADDR_TYPE = 4;

    public static String getHexFileContents(List<IHexFileLineInfo> lineInfos) {
        StringBuilder sb = new StringBuilder();
        for (IHexFileLineInfo lineInfo : lineInfos) {
            sb.append(lineInfo.formatLine());
            sb.append('\n');
        }
        sb.append(":00000001FF\n");
        return sb.toString();
    }

    public static void addToLineInfos(List<IHexFileLineInfo> lineInfos, int index, int maxLineLength, int address, byte[] bytes) {
        int numLines = (bytes.length + maxLineLength - 1) / maxLineLength;
        int i = 0;
        while (i < numLines) {
            DataHexFileLineInfo lineInfo = new DataHexFileLineInfo(maxLineLength, address);
            int leftover = bytes.length % maxLineLength;
            int length = i < numLines - 1 || leftover == 0 ? maxLineLength : leftover;
            lineInfo.setLen(length);
            System.arraycopy(bytes, i * maxLineLength, lineInfo.array(), 0, length);
            lineInfos.add(index++, lineInfo);
            address += maxLineLength;
            ++i;
        }
    }

    public static List<IHexFileLineInfo> readHexFileContents(String hexFileContents) throws IOException {
        ArrayList<IHexFileLineInfo> lines = new ArrayList<IHexFileLineInfo>();
        BufferedReader reader = new BufferedReader(new CharArrayReader(hexFileContents.toCharArray()));
        String line = reader.readLine();
        while (line != null) {
            IHexFileLineInfo lineInfo = HexFileUtils.createLineInfo(line);
            if (lineInfo != null) {
                lines.add(lineInfo);
            }
            line = reader.readLine();
        }
        return lines;
    }

    public static IHexFileLineInfo createLineInfo(String line) {
        int type = HexFileUtils.readHex(line, 7, 1);
        if (type == 0) {
            return new DataHexFileLineInfo(line);
        }
        if (type == 4) {
            return new ExtAddrLineInfo(line, 4);
        }
        return null;
    }

    public static byte getChecksum(byte[] lineBytes) {
        int cs = 0;
        byte[] byArray = lineBytes;
        int n = lineBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            cs += b;
            ++n2;
        }
        return (byte)(-1 - HexFileUtils.asByte(cs) + 1);
    }

    public static byte asByte(int i) {
        return (byte)(i & 0xFF);
    }

    public static int readHex(String str, int beginIndex, int numBytes) {
        String s = str.substring(beginIndex, beginIndex + numBytes * 2);
        return Integer.parseInt(s, 16);
    }

    public static String formatAsHex(int value, int numDigits) {
        String string = String.format(MessageFormat.format("%0{0}X", numDigits), value);
        int length = string.length();
        if (length > numDigits) {
            return string.substring(length - numDigits, length);
        }
        return string;
    }
}

