/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.api.IActionParserListener;
import com.silabs.java.utils.api.ILineHandler;
import com.silabs.ss.platform.api.apack.core.execution.Executioner;
import com.silabs.ss.platform.api.apack.core.execution.IExecutionContext;
import com.silabs.ss.platform.api.apack.core.function.ProgressLineHandler;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunction;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunctionFilter;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackJobCreator;
import com.silabs.ss.platform.api.device.core.DeviceFilter;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.UploadArgsFactory;
import com.silabs.ss.support.mcu.api.part.core.secure.SecurePartUtils;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UploadUtils {
    private static AtomicBoolean flashComplete = new AtomicBoolean(false);

    public static IStatus upload(IDevice device, IPath image, long baseAddress, boolean reset, boolean run, boolean extFlash, IProgressMonitor monitor) {
        return UploadUtils.upload(device, image, baseAddress, reset, run, extFlash, null, monitor);
    }

    public static IStatus upload(IDevice device, IPath image, long baseAddress, boolean reset, boolean run, boolean extFlash, String eraseMode, IProgressMonitor monitor) {
        UploadArgsFactory factory = UploadArgsFactory.createFactory(device).setImage(image).setBaseAddress(baseAddress).setReset(reset).setRun(run).setExtFlash(extFlash).setEraseMode(eraseMode);
        return UploadUtils.upload(factory, monitor);
    }

    public static IStatus upload(UploadArgsFactory factory, final IProgressMonitor monitor) {
        IStatus unlockStatus;
        IDevice device = factory.getDevice();
        if (factory.isSecureUnlockEnabled() && !(unlockStatus = UploadUtils.unlockSecureDevice(device)).isOK()) {
            return unlockStatus;
        }
        IStatus status = null;
        ProgressLineHandler lineHandler = new ProgressLineHandler(UploadArgsFactory.TYPE.id(), monitor);
        DeviceFilter filter = new DeviceFilter(device);
        List fns = AdapterPackManager.instance().findManagedFunctions(UploadArgsFactory.TYPE, (IAdapterPackFunctionFilter)filter);
        if (fns == null || fns.isEmpty()) {
            return Activator.reporter.newErrorStatus(MessageFormat.format("Fail to find utility (known as adapter pack internally) to download program to device ''{0}({1}'').", device.label(), device.hardware()));
        }
        assert (fns.size() == 1);
        IAdapterPackFunction fn = (IAdapterPackFunction)fns.get(0);
        String name = factory.getImage();
        if (name == null) {
            name = "files";
        }
        monitor.beginTask("Copying " + name + " to " + device.label(), 100);
        try {
            flashComplete.set(false);
            Executioner.instance().execute((IAdapterPackJobCreator)fn, () -> device == null ? "" : device.label(), factory.getArgs(), (ILineHandler)lineHandler, (IActionParserListener)new IActionParserListener<IExecutionContext>(){

                public void parseAction(IExecutionContext context, String token, Object ... values) {
                }

                public void endOfInput(IExecutionContext context) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    flashComplete.set(true);
                    monitor.worked(100);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            flashComplete.set(true);
            status = Activator.reporter.newStatus(4, e.getMessage(), (Throwable)e);
        }
        while (!flashComplete.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (status == null && lineHandler.hasError()) {
            String errStr = lineHandler.getError();
            if (lineHandler.hasWarning()) {
                errStr = String.valueOf(errStr) + " ";
                errStr = String.valueOf(errStr) + lineHandler.getWarning();
            }
            status = Activator.reporter.newStatus(4, errStr, null);
        }
        if (status == null) {
            status = Status.OK_STATUS;
        }
        return status;
    }

    private static IStatus unlockSecureDevice(IDevice device) {
        try {
            if (SecurePartUtils.isLocked(device)) {
                SecurePartUtils.unlock(device);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

