/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.api.IActionParserListener;
import com.silabs.java.utils.api.ILineHandler;
import com.silabs.ss.platform.api.apack.core.execution.Executioner;
import com.silabs.ss.platform.api.apack.core.execution.IExecutionContext;
import com.silabs.ss.platform.api.apack.core.function.SimpleLineHandler;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunction;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackFunctionFilter;
import com.silabs.ss.platform.api.apack.core.model.IAdapterPackJobCreator;
import com.silabs.ss.platform.api.device.core.DeviceFilter;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.support.mcu.api.part.core.IExecutionCompleteCallback;
import com.silabs.ss.support.mcu.api.part.core.RecoverDeviceJobArgs;
import com.silabs.ss.support.mcu.internal.part.core.Activator;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RecoverDeviceJob
extends Job {
    public static final String JOB_NAME = "Recover Target Device";
    private final IDevice device;
    private final IExecutionCompleteCallback completionListener;
    private final boolean ignoreErrors;
    private AtomicBoolean recoverComplete = new AtomicBoolean(false);

    public RecoverDeviceJob(IDevice device, IExecutionCompleteCallback completionListener, boolean ignoreErrors) {
        super(JOB_NAME);
        this.device = device;
        this.completionListener = completionListener;
        this.ignoreErrors = ignoreErrors;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        IStatus status = null;
        RecoverResposeLineHandler lineHandler = new RecoverResposeLineHandler(RecoverDeviceJobArgs.TYPE.id(), monitor);
        DeviceFilter filter = new DeviceFilter(this.device);
        List fns = AdapterPackManager.instance().findManagedFunctions(RecoverDeviceJobArgs.TYPE, (IAdapterPackFunctionFilter)filter);
        if (fns == null || fns.isEmpty()) {
            return Activator.reporter.newErrorStatus(MessageFormat.format("Fail to find utility (known as adapter pack internally) to recover device ''{0}({1}'').", this.device.label(), this.device.hardware()));
        }
        assert (fns.size() == 1);
        IAdapterPackFunction fn = (IAdapterPackFunction)fns.get(0);
        monitor.beginTask("Recovering " + this.device.label(), 100);
        try {
            this.recoverComplete.set(false);
            Executioner.instance().execute((IAdapterPackJobCreator)fn, () -> this.device == null ? "" : this.device.label(), RecoverDeviceJobArgs.makeArguments(this.device), (ILineHandler)lineHandler, (IActionParserListener)new IActionParserListener<IExecutionContext>(){

                public void parseAction(IExecutionContext context, String token, Object ... values) {
                }

                public void endOfInput(IExecutionContext context) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    RecoverDeviceJob.this.recoverComplete.set(true);
                    monitor.worked(100);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            this.recoverComplete.set(true);
            status = Activator.reporter.newStatus(4, e.getMessage(), (Throwable)e);
        }
        while (!this.recoverComplete.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (status == null && lineHandler.hasError()) {
            String errStr = lineHandler.getError();
            if (lineHandler.hasWarning()) {
                errStr = String.valueOf(errStr) + " ";
                errStr = String.valueOf(errStr) + lineHandler.getWarning();
            }
            status = Activator.reporter.newStatus(4, errStr, null);
        }
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (this.completionListener != null) {
            this.completionListener.executionComplete(status);
        }
        return this.ignoreErrors ? Status.OK_STATUS : status;
    }

    protected class ExecutionContext
    implements IExecutionContext {
        protected IDevice device;

        public ExecutionContext(IDevice device) {
            this.device = device;
        }

        public String name() {
            return this.device == null ? "" : this.device.label();
        }
    }

    private static class RecoverResposeLineHandler
    extends SimpleLineHandler {
        public RecoverResposeLineHandler(String name, IProgressMonitor pm) {
            super(name, pm);
        }
    }
}

