/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.mcu.api.part.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.platform.api.apack.ip.IpDiscoveryKey;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.content.part.core.Part;
import com.silabs.ss.platform.api.device.core.DeviceExtensionKey;
import com.silabs.ss.platform.api.device.core.DeviceUtils;
import com.silabs.ss.platform.api.device.core.IDevice;
import com.silabs.ss.platform.api.device.core.IDeviceExtension;
import com.silabs.ss.platform.api.device.core.detection.IDeviceDetectionInfo;
import com.silabs.ss.platform.api.device.core.identifier.SessionTemporaryPart;
import com.silabs.ss.support.mcu.api.part.core.IExecutionCompleteCallback;
import com.silabs.ss.support.mcu.api.part.core.MCUPartProperties;
import com.silabs.ss.support.mcu.api.part.core.RecoverDeviceJob;
import com.silabs.ss.support.mcu.api.part.core.ResetJob;
import com.silabs.ss.support.mcu.internal.api.part.core.MCUDeviceSettingExtension;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;

public class MCUUtils {
    private static final String MCU_PART_ID_PREFIX = "mcu.";
    private static final String DEBUG_MODE = "debugMode";
    private static final String DEBUG_MODE_TYPE_OUT = "out";
    private static final String DEBUG_MODE_TYPE_MINI = "mini";
    private static final String ADAPTER_TYPE_JLINK = "jlink";
    private static final String ADAPTER_LABEL = "adapterLabel";
    private static final String ADAPTER_LABEL_TAG = "j-link";

    public static String getTargetInterface(IDevice device) {
        IDeviceExtension deviceExt;
        String tif = null;
        tif = ((MCUDeviceSettingExtension)device.settings().getExtension(MCUDeviceSettingExtension.class)).getTargetInterface();
        if (device.hasExtension(DeviceExtensionKey.SESSION_TEMP_PART.key()) && (deviceExt = device.deviceExtension(DeviceExtensionKey.SESSION_TEMP_PART.key())) instanceof SessionTemporaryPart) {
            tif = ((SessionTemporaryPart)deviceExt).getTargetInterface();
        }
        return tif;
    }

    public static void setTargetInterface(IDevice device, String tif) {
        if (device != null && device.settings() != null && device.settings().getExtension(MCUDeviceSettingExtension.class) != null) {
            ((MCUDeviceSettingExtension)device.settings().getExtension(MCUDeviceSettingExtension.class)).setTargetInterface(tif);
        }
    }

    public static boolean isMCUPart(String partId) {
        if (partId != null) {
            return partId.startsWith(MCU_PART_ID_PREFIX);
        }
        return false;
    }

    public static boolean isMCUPart(IPartDescriptor part) {
        if (part != null) {
            return MCUUtils.isMCUPart(part.getId());
        }
        return false;
    }

    public static IPartDescriptor getTargetPartFromDevice(IDevice device) {
        IDeviceExtension deviceExt;
        if (device != null && device.hardware() != null && device.hardware().targetPart() != null) {
            return device.hardware().targetPart();
        }
        if (device != null && device.hasExtension(DeviceExtensionKey.SESSION_TEMP_PART.key()) && (deviceExt = device.deviceExtension(DeviceExtensionKey.SESSION_TEMP_PART.key())) instanceof SessionTemporaryPart) {
            return ((SessionTemporaryPart)deviceExt).getTargetPart();
        }
        return null;
    }

    public static String getDebugPartName(IDevice d, boolean allowOverride) {
        IDeviceExtension deviceExt;
        if (d == null) {
            return "";
        }
        String partName = "";
        IPartDescriptor part = d.hardware().targetPart();
        if (part == null && d.hasExtension(DeviceExtensionKey.SESSION_TEMP_PART.key()) && (deviceExt = d.deviceExtension(DeviceExtensionKey.SESSION_TEMP_PART.key())) instanceof SessionTemporaryPart) {
            part = ((SessionTemporaryPart)deviceExt).getTargetPart();
        }
        if (part != null) {
            int idx;
            String prop;
            if (allowOverride && (prop = (String)part.getProperty(MCUPartProperties.DEBUG_PART_NAME)) != null && !prop.isEmpty()) {
                partName = prop;
            }
            if (TextUtils.isEmpty((String)partName) && (idx = (partName = part.getName()).indexOf(45)) > 0) {
                partName = partName.substring(0, idx);
            }
        }
        return partName;
    }

    public static String[] getSupportedResetTypes(IDevice device) {
        if (device != null && device.hardware().targetPart() != null) {
            IPartDescriptor part = device.hardware().targetPart();
            Collection typeList = (Collection)part.getProperty(MCUPartProperties.SUPPORTED_RESET_TYPES);
            return typeList.toArray(new String[typeList.size()]);
        }
        return new String[0];
    }

    public static void resetDevice(IDevice device, IExecutionCompleteCallback completionListener) {
        ResetJob resetJob = new ResetJob(device, completionListener);
        resetJob.setUser(false);
        resetJob.schedule();
    }

    public static void recoverDevice(IDevice device, IExecutionCompleteCallback completionListener, boolean ignoreErrors) {
        RecoverDeviceJob recoverDeviceJob = new RecoverDeviceJob(device, completionListener, ignoreErrors);
        recoverDeviceJob.setUser(false);
        recoverDeviceJob.schedule();
    }

    public static boolean isAdapterTypeJLink(IDevice device) {
        boolean isJlink = false;
        if (device != null) {
            if (device.hardware().adapterIPAddress() != null) {
                IDeviceDetectionInfo[] iDeviceDetectionInfoArray = device.detectionInfos();
                int n = iDeviceDetectionInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDeviceDetectionInfo info = iDeviceDetectionInfoArray[n2];
                    boolean bl = isJlink = info.properties().get(IpDiscoveryKey.SN) != null;
                    if (!isJlink) {
                        String label = info.label();
                        boolean bl2 = isJlink = label != null && label.toLowerCase(Locale.ROOT).contains(ADAPTER_LABEL_TAG);
                    }
                    if (!isJlink) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else if (device.hardware().inspectionInfo() != null) {
                isJlink = MCUUtils.isUsbAdapterTypeJLink(device);
            }
        }
        return isJlink;
    }

    public static boolean isUsbAdapterTypeJLink(IDevice device) {
        boolean isJlink;
        String adapterType = DeviceUtils.getAdapterType((IDevice)device);
        boolean bl = isJlink = adapterType != null && adapterType.toLowerCase(Locale.ROOT).equals(ADAPTER_TYPE_JLINK);
        if (!isJlink) {
            isJlink = DeviceUtils.inspectionValueContains((IDevice)device, (String)ADAPTER_LABEL, (String)ADAPTER_LABEL_TAG);
        }
        if (!isJlink) {
            isJlink = DeviceUtils.inspectionExtrasContains((IDevice)device, (String)ADAPTER_LABEL_TAG);
        }
        return isJlink;
    }

    public static String getDebugMode(IDevice device) {
        block3: {
            try {
                if (device != null && device.hardware().inspectionInfo() != null) break block3;
                return "";
            }
            catch (IOException iOException) {
                return "";
            }
        }
        String mode = device.hardware().inspectionInfo().value(DEBUG_MODE);
        return mode == null ? "" : mode;
    }

    public static boolean isInDebutOutMode(IDevice device) {
        String mode = MCUUtils.getDebugMode(device);
        return TextUtils.isEmpty((String)mode) ? MCUUtils.isUsbAdapterTypeJLink(device) : mode.toLowerCase().compareTo(DEBUG_MODE_TYPE_OUT) == 0 || mode.toLowerCase().compareTo(DEBUG_MODE_TYPE_MINI) == 0;
    }

    public static IPartDescriptor[] findPartDescriptorInRegistryByPartNum(String partNum) {
        if (TextUtils.isEmpty((String)partNum)) {
            return new IPartDescriptor[0];
        }
        IPartDescriptor[] targetParts = (IPartDescriptor[])Part.manager().getRegistry().findDescriptorsFromName(partNum);
        if (targetParts.length == 0) {
            String modPartNum = partNum.substring(0, partNum.length() - 1);
            targetParts = (IPartDescriptor[])Part.manager().getRegistry().findDescriptorsFromName(modPartNum);
        }
        return targetParts;
    }
}

