/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.instrumented.configuration.internal.api.instrument.shared;

import com.silabs.java.utils.log.ILogger;
import com.silabs.java.utils.variables.EnvironmentVariableUtils;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.concurrent.TimeUnit;

public final class SlcCliTelemetryConfigure {
    public static final String OPENTELEMETRY_CONTEXT_PREFIX = "slc.ot.context";
    public static final String OPENTELEMETRY_CONTEXT_PARENT_TRACE = "slc.ot.context.parentid";
    private static final String OTEL_AUTOCONF_ENABLE_PROP = "otel.java.global.autoconfigure.enabled";
    private static final String OTEL_AUTOCONF_ENABLE_ENV = "OTEL_JAVA_GLOBAL_AUTOCONFIGURE_ENABLED";

    private SlcCliTelemetryConfigure() {
    }

    public static OpenTelemetry initialiseForSlcCliCore(ILogger logger) {
        return OpenTelemetrySingletonHolder.autoSdk;
    }

    public static OpenTelemetry internalDetermineAutoSdk() {
        if (SlcCliTelemetryConfigure.isOtEnabled()) {
            return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(false).build().getOpenTelemetrySdk();
        }
        return OpenTelemetry.noop();
    }

    public static boolean isOtEnabled() {
        String systemProp = System.getProperty(OTEL_AUTOCONF_ENABLE_PROP);
        if (systemProp != null) {
            return Boolean.parseBoolean(systemProp);
        }
        systemProp = EnvironmentVariableUtils.getOrDefault((String)OTEL_AUTOCONF_ENABLE_ENV, (String)"false");
        return Boolean.parseBoolean(systemProp);
    }

    public static <T> Context extractContext(OpenTelemetry telemetry, T carrier, TextMapGetter<T> retrieval) {
        if (retrieval != null) {
            return telemetry.getPropagators().getTextMapPropagator().extract(Context.current(), carrier, retrieval);
        }
        return Context.current();
    }

    public static void shutdown(OpenTelemetry tel) {
        if (tel instanceof OpenTelemetrySdk) {
            OpenTelemetrySdk telSdk = (OpenTelemetrySdk)tel;
            telSdk.getSdkLoggerProvider().shutdown().join(2L, TimeUnit.SECONDS);
            telSdk.getSdkTracerProvider().shutdown().join(2L, TimeUnit.SECONDS);
            telSdk.getSdkMeterProvider().shutdown().join(2L, TimeUnit.SECONDS);
        }
    }

    private static final class OpenTelemetrySingletonHolder {
        private static final OpenTelemetry autoSdk = SlcCliTelemetryConfigure.internalDetermineAutoSdk();

        private OpenTelemetrySingletonHolder() {
        }
    }
}

